/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.model.ibus.receipt.fiscal;

import com.gridnine.xtrip.common.l10n.model.L10nMessage;
import com.gridnine.xtrip.common.model.EntityContainer;
import com.gridnine.xtrip.common.model.EntityReference;
import com.gridnine.xtrip.common.model.NestedEntityReference;
import com.gridnine.xtrip.common.model.booking.BaseProduct;
import com.gridnine.xtrip.common.model.booking.BookingFile;
import com.gridnine.xtrip.common.model.booking.Fop;
import com.gridnine.xtrip.common.model.booking.GeneralProductFop;
import com.gridnine.xtrip.common.model.dict.ContractType;
import com.gridnine.xtrip.common.model.fiscal.IBusFiscalReceiptContextKeys;
import com.gridnine.xtrip.common.model.fiscal.PaymentMethod;
import com.gridnine.xtrip.common.model.fiscal.Receipt;
import com.gridnine.xtrip.common.model.fiscal.ReceiptData;
import com.gridnine.xtrip.common.model.fiscal.ReceiptLine;
import com.gridnine.xtrip.common.model.fiscal.ReceiptLineSellType;
import com.gridnine.xtrip.common.model.fiscal.ReceiptLineType;
import com.gridnine.xtrip.common.model.fiscal.ReceiptServiceType;
import com.gridnine.xtrip.common.model.helpers.BookingHelper;
import com.gridnine.xtrip.common.model.helpers.GeneralProductHelper;
import com.gridnine.xtrip.server.ibus.IntegrationBusFacade;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import org.junit.Assert;

public class ReceiptTestHelper {
    static Map<String, Object> createIbusContext(List<EntityContainer<BookingFile>> bookingCtrs, ReceiptServiceType serviceType) {
        HashMap<String, Object> ctx = new HashMap<String, Object>();
        HashMap<String, EntityReference> fopPayerMap = new HashMap<String, EntityReference>();
        HashMap mapProductsToPayReference = new HashMap();
        for (EntityContainer<BookingFile> bookingCtr : bookingCtrs) {
            for (BaseProduct product : BookingHelper.getProducts((BookingFile)((BookingFile)bookingCtr.getEntity()))) {
                NestedEntityReference productRef = new NestedEntityReference(bookingCtr.getUid(), BookingFile.class, product.getUid(), BaseProduct.class, null);
                ArrayList<NestedEntityReference> fopReferences = new ArrayList<NestedEntityReference>();
                for (GeneralProductFop fop : GeneralProductHelper.getFops((BaseProduct)product, (ContractType)ContractType.CLIENT)) {
                    fopReferences.add(new NestedEntityReference(bookingCtr.getUid(), BookingFile.class, fop.getUid(), Fop.class, null));
                    if (fop.getPayer() == null) continue;
                    fopPayerMap.put(fop.getUid(), fop.getPayer());
                }
                mapProductsToPayReference.put(productRef, fopReferences);
            }
        }
        ctx.put(IBusFiscalReceiptContextKeys.PRODUCTS_TO_PAY_REFERENCE.name(), mapProductsToPayReference);
        ctx.put(IBusFiscalReceiptContextKeys.FOP_PAYER_MAP.name(), fopPayerMap);
        ctx.put(IBusFiscalReceiptContextKeys.RECEIPT_SERVICE_TYPE.name(), serviceType);
        ctx.put(IBusFiscalReceiptContextKeys.CLIENT_ADDRESS.name(), "test@test.ttt");
        return ctx;
    }

    static List<EntityContainer<Receipt>> registerReceipts(Map<String, Object> ibusContext) {
        ReceiptTestHelper.invokeReceiptIbus(ibusContext, "receipt:fiscal:register-fiscal-receipt");
        return (List)ibusContext.get(IBusFiscalReceiptContextKeys.RECEIPT_CONTAINERS.name());
    }

    static List<EntityContainer<Receipt>> registerCancelReceipts(Map<String, Object> ibusContext) {
        ReceiptTestHelper.invokeReceiptIbus(ibusContext, "receipt:fiscal:register-cancel-fiscal-receipt");
        return (List)ibusContext.get(IBusFiscalReceiptContextKeys.RECEIPT_CONTAINERS.name());
    }

    static List<EntityContainer<Receipt>> createReceipts(Map<String, Object> ibusContext) {
        ReceiptTestHelper.invokeReceiptIbus(ibusContext, "receipt:fiscal:create-fiscal-receipt");
        return (List)ibusContext.get(IBusFiscalReceiptContextKeys.RECEIPT_CONTAINERS.name());
    }

    static List<EntityContainer<Receipt>> createCancelReceipts(Map<String, Object> ibusContext) {
        ReceiptTestHelper.invokeReceiptIbus(ibusContext, "receipt:fiscal:create-cancel-fiscal-receipt");
        return (List)ibusContext.get(IBusFiscalReceiptContextKeys.RECEIPT_CONTAINERS.name());
    }

    private static void invokeReceiptIbus(Map<String, Object> ibusContext, String route) {
        IntegrationBusFacade.get().processRouteSync(route, ibusContext);
        List messages = (List)ibusContext.get(IBusFiscalReceiptContextKeys.MESSAGE.name());
        if (messages != null) {
            Supplier<String> reasonSupplier = () -> messages.stream().map(message -> Optional.ofNullable(message.getMessage()).map(L10nMessage::toString).orElse(null)).filter(Objects::nonNull).collect(Collectors.joining("||"));
            Assert.assertEquals((String)reasonSupplier.get(), (long)0L, (long)messages.size());
        }
    }

    static class ReceiptValidator {
        private EntityReference<BookingFile> ownerRef;
        private String productUid;
        private boolean withSupplier;

        ReceiptValidator(EntityReference<BookingFile> ownerRef, String productUid, boolean withSupplier) {
            this.ownerRef = ownerRef;
            this.productUid = productUid;
            this.withSupplier = withSupplier;
        }

        void validateReceipt(Receipt receipt) {
            Assert.assertEquals((Object)receipt.getOwner(), this.ownerRef);
            Assert.assertNull((Object)receipt.getNextReceipt());
            Assert.assertNull((Object)receipt.getPreviousReceipt());
            ReceiptData receiptData = receipt.getReceiptData();
            Assert.assertNotNull((Object)receiptData.getClentEmail());
            List receiptLines = receiptData.getItems();
            for (ReceiptLine line : receiptLines) {
                Assert.assertEquals((Object)line.getTotal(), (Object)line.getPrice());
                Assert.assertEquals((Object)line.getProductReference().getNestedEntityUid(), (Object)this.productUid);
                Assert.assertEquals((Object)line.getPaymentMethod(), (Object)PaymentMethod.FULL_PAYMENT);
                if (this.withSupplier) {
                    com.gridnine.xtrip.common.model.fiscal.Supplier supplier = line.getSupplier();
                    Assert.assertNotNull((Object)supplier);
                    Assert.assertNotNull((Object)supplier.getINN());
                    Assert.assertNotNull((Object)supplier.getName());
                }
                if (line.getLineType() != ReceiptLineType.FEES) {
                    Assert.assertEquals((Object)ReceiptLineSellType.AGENT, (Object)line.getSellType());
                    continue;
                }
                Assert.assertEquals((Object)ReceiptLineSellType.OWN, (Object)line.getSellType());
            }
        }
    }
}

