/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.model.ibus.receipt.fiscal;

import com.gridnine.xtrip.common.model.EntityContainer;
import com.gridnine.xtrip.common.model.EntityReference;
import com.gridnine.xtrip.common.model.booking.BaseProduct;
import com.gridnine.xtrip.common.model.booking.BookingFile;
import com.gridnine.xtrip.common.model.booking.misc.UniversalProduct;
import com.gridnine.xtrip.common.model.dict.ContractType;
import com.gridnine.xtrip.common.model.entity.EntityStorage;
import com.gridnine.xtrip.common.model.fiscal.PaymentType;
import com.gridnine.xtrip.common.model.fiscal.Receipt;
import com.gridnine.xtrip.common.model.fiscal.ReceiptServiceType;
import com.gridnine.xtrip.common.model.fiscal.ReceiptType;
import com.gridnine.xtrip.common.model.helpers.BookingHelper;
import com.gridnine.xtrip.server.model.ibus.receipt.fiscal.ReceiptTestBase;
import com.gridnine.xtrip.server.model.ibus.receipt.fiscal.ReceiptTestHelper;
import com.gridnine.xtrip.server.model.test.TestBookingFileBuilder;
import com.gridnine.xtrip.server.model.test.TestContractBuilderBuilder;
import com.gridnine.xtrip.server.model.test.TestUniversalProductBuilder;
import com.gridnine.xtrip.server.model.test.TestUniversalProductDescriptionBuilder;
import java.math.BigDecimal;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.junit.Assert;
import org.junit.Test;

public class UniversalProductReceiptTest
extends ReceiptTestBase {
    @Override
    public void setUp() throws Exception {
        super.setUp();
        new TestContractBuilderBuilder().supplier(TestBookingFileBuilder.agency).contractType(ContractType.CLIENT).customer().customer(TestBookingFileBuilder.client).end().create();
    }

    @Test
    public void testUniversalProduct() throws Exception {
        EntityContainer<BookingFile> testCtr = this.buildBookingContainer();
        BaseProduct product = (BaseProduct)BookingHelper.getProducts((BookingFile)((BookingFile)testCtr.getEntity())).iterator().next();
        ReceiptTestHelper.ReceiptValidator validator = new ReceiptTestHelper.ReceiptValidator((EntityReference<BookingFile>)testCtr.toReference(), product.getUid(), false);
        Map<String, Object> ibusContext = ReceiptTestHelper.createIbusContext(Collections.singletonList(testCtr), ReceiptServiceType.ATOL_FISCAL_DEVICE);
        List<EntityContainer<Receipt>> receipts = ReceiptTestHelper.createReceipts(ibusContext);
        Assert.assertEquals((long)1L, (long)receipts.size());
        receipts = ReceiptTestHelper.registerReceipts(ibusContext);
        Receipt receipt = (Receipt)receipts.iterator().next().getEntity();
        validator.validateReceipt(receipt);
        Assert.assertEquals((Object)ReceiptType.SELL, (Object)receipt.getReceiptData().getType());
        Assert.assertEquals((long)1L, (long)receipt.getReceiptData().getItems().size());
        Assert.assertTrue((boolean)receipt.getReceiptData().getItems().stream().allMatch(line -> line.getPaymentType() == PaymentType.CASH));
    }

    private EntityContainer<BookingFile> buildBookingContainer() throws Exception {
        EntityContainer bookingCtr = ((TestUniversalProductBuilder)new TestBookingFileBuilder().reservation().product(TestUniversalProductBuilder.class, new Object[]{new TestUniversalProductDescriptionBuilder().rulesSupported(true).create().toReference()})).fare(BigDecimal.valueOf(1000L)).updateFops().setContractCurrency("RUB").end().end().traveller().end().create();
        UniversalProduct product = (UniversalProduct)BookingHelper.getProducts((BookingFile)((BookingFile)bookingCtr.getEntity())).iterator().next();
        ((BookingFile)bookingCtr.getEntity()).getTravellers().forEach(traveller -> product.getTravellersUids().add(traveller.getUid()));
        return EntityStorage.get().save(bookingCtr, false);
    }
}

