/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.model.ibus.receipt.fiscal.createReceipt;

import com.gridnine.xtrip.common.model.Xeption;
import com.gridnine.xtrip.common.model.booking.BaseProduct;
import com.gridnine.xtrip.common.model.booking.ExtendedProductType;
import com.gridnine.xtrip.common.model.booking.ProductStatus;
import com.gridnine.xtrip.common.model.dict.DictionaryReference;
import com.gridnine.xtrip.common.model.entity.EntityStorageContext;
import com.gridnine.xtrip.common.model.entity.EntityStorageHelper;
import com.gridnine.xtrip.common.model.fiscal.IBusFiscalReceiptContextKeys;
import com.gridnine.xtrip.common.model.fiscal.ReceiptLine;
import com.gridnine.xtrip.common.model.handlers.ProductHandler;
import com.gridnine.xtrip.common.model.helpers.GeneralProductHelper;
import com.gridnine.xtrip.common.model.rules.fiscal.FiscalReceiptItemActionSet;
import com.gridnine.xtrip.common.model.rules.fiscal.FiscalReceiptItemPropertySet;
import com.gridnine.xtrip.common.model.rules.fiscal.FiscalTargets;
import com.gridnine.xtrip.common.model.system.IBusStandardContextKeys;
import com.gridnine.xtrip.common.rules.RuleEngine;
import com.gridnine.xtrip.common.rules.RuleSet;
import com.gridnine.xtrip.common.rules.elements.RuleProxy;
import com.gridnine.xtrip.common.util.MiscUtil;
import com.gridnine.xtrip.server.ibus.components.BaseProcessor;
import com.gridnine.xtrip.server.ibus.components.MessageContext;
import com.gridnine.xtrip.server.model.ibus.receipt.fiscal.IbusFiscalReceiptHelper;
import com.gridnine.xtrip.server.model.ibus.receipt.fiscal.createReceipt.batch.ProductBatch;
import com.gridnine.xtrip.server.model.ibus.receipt.fiscal.createReceipt.batch.ReceiptLineValueHolder;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;

public class ApplyRulesToReceiptLinesProcessor
extends BaseProcessor {
    public void process(MessageContext ctx) throws Exception {
        ProductBatch batch = (ProductBatch)ctx.getMandatoryObject((Enum)IBusFiscalReceiptContextKeys.PRODUCT_BATCH);
        EntityStorageContext context = (EntityStorageContext)ctx.getMandatoryObject((Enum)IBusStandardContextKeys.ENTITY_STORAGE_CONTEXT);
        List receiptLineHolders = (List)ctx.getMandatoryObject((Enum)IBusFiscalReceiptContextKeys.RECEIPT_LINE_HOLDERS_LOCAL);
        BaseProduct product = (BaseProduct)Objects.requireNonNull(EntityStorageHelper.resolve(batch.getProductReference(), (EntityStorageContext)context));
        ProductHandler handler = ProductHandler.of((BaseProduct)product);
        BaseProduct previousProduct = handler.getPreviousProduct(product);
        ExtendedProductType ept = new ExtendedProductType();
        ept.setProductType(handler.getProductType(product));
        ept.setProductDescription(handler.getUniversalProductDescription(product));
        for (ReceiptLineValueHolder holder : receiptLineHolders) {
            ReceiptLine receiptLine = holder.getReceiptLine();
            RuleProxy fiscalReceiptItemProxy = new RuleProxy();
            FiscalReceiptItemPropertySet propertySet = new FiscalReceiptItemPropertySet();
            FiscalReceiptItemActionSet actionSet = new FiscalReceiptItemActionSet();
            propertySet.setProductType(ept);
            propertySet.setProductStatus(handler.getStatus(product));
            propertySet.setProductSupplier(GeneralProductHelper.getSupplier((BaseProduct)product));
            propertySet.setIssuedInExchange(previousProduct != null && handler.getStatus(previousProduct) == ProductStatus.EXCHANGE);
            propertySet.setReceiptDataType(IbusFiscalReceiptHelper.convertReceiptLineType2ReceiptDataType(receiptLine.getLineType()));
            fiscalReceiptItemProxy.setProxyType(FiscalTargets.FISCAL_RECEIPT_ITEM.getId());
            fiscalReceiptItemProxy.setProxyDate(new Date());
            fiscalReceiptItemProxy.setPropertySet((Object)propertySet);
            fiscalReceiptItemProxy.setActionSet((Object)actionSet);
            try {
                RuleEngine.applyRules(Collections.singletonList(fiscalReceiptItemProxy), (RuleSet)IbusFiscalReceiptHelper.getFiscalSettings().getRuleSet());
            }
            catch (Exception e) {
                throw Xeption.forDeveloper((String)String.format("Failed to apply fiscal rules to %s (%s)", handler.generateShortProductName(product), propertySet.getReceiptDataType()), (Object[])new Object[0]);
            }
            receiptLine.setVatType(IbusFiscalReceiptHelper.getReceiptVatType(actionSet.isShowVat() ? holder.getFopValueHolder().getFopComponent().getVatRate() : null));
            receiptLine.setPrintName(IbusFiscalReceiptHelper.getPrintName(holder, actionSet.getPattern(), context));
            if (actionSet.getSellType() != null) {
                receiptLine.setSellType(actionSet.getSellType());
            }
            holder.getFiscalCategories().addAll(actionSet.getFiscalCategories().stream().sorted(MiscUtil.comparator(DictionaryReference::getCode)).collect(Collectors.toList()));
        }
    }
}

