/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.model.ibus.receipt.fiscal.createReceipt;

import com.gridnine.xtrip.common.l10n.model.LocaleHelper;
import com.gridnine.xtrip.common.model.BaseEntity;
import com.gridnine.xtrip.common.model.EntityContainer;
import com.gridnine.xtrip.common.model.NestedEntityReference;
import com.gridnine.xtrip.common.model.booking.BaseProduct;
import com.gridnine.xtrip.common.model.booking.BookingFile;
import com.gridnine.xtrip.common.model.entity.EntityStorageContext;
import com.gridnine.xtrip.common.model.entity.EntityStorageHelper;
import com.gridnine.xtrip.common.model.fiscal.IBusFiscalReceiptContextKeys;
import com.gridnine.xtrip.common.model.fiscal.Receipt;
import com.gridnine.xtrip.common.model.fiscal.ReceiptData;
import com.gridnine.xtrip.common.model.fiscal.ReceiptLine;
import com.gridnine.xtrip.common.model.fiscal.ReceiptServiceType;
import com.gridnine.xtrip.common.model.fiscal.ReceiptStatus;
import com.gridnine.xtrip.common.model.handlers.ProductHandler;
import com.gridnine.xtrip.common.model.system.IBusStandardContextKeys;
import com.gridnine.xtrip.common.util.TextUtil;
import com.gridnine.xtrip.server.ibus.IbusHelper;
import com.gridnine.xtrip.server.ibus.components.BaseProcessor;
import com.gridnine.xtrip.server.ibus.components.MessageContext;
import com.gridnine.xtrip.server.model.ibus.receipt.fiscal.createReceipt.batch.BookingFileBatch;
import com.gridnine.xtrip.server.model.ibus.receipt.fiscal.createReceipt.batch.ReceiptLineValueHolder;
import com.gridnine.xtrip.server.model.ibus.receipt.fiscal.createReceipt.batch.ReceiptLinesHoldersBatch;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.stream.Collectors;

public class CreateFiscalReceiptProcessor
extends BaseProcessor {
    public void process(MessageContext ctx) throws Exception {
        BookingFileBatch bookingFileBatch = (BookingFileBatch)ctx.getMandatoryObject((Enum)IBusFiscalReceiptContextKeys.BOOKING_FILE_BATCH);
        String clientAddress = (String)ctx.getObject((Enum)IBusFiscalReceiptContextKeys.CLIENT_ADDRESS);
        ReceiptLinesHoldersBatch receiptLinesHoldersBatch = (ReceiptLinesHoldersBatch)ctx.getMandatoryObject((Enum)IBusFiscalReceiptContextKeys.RECEIPT_LINES_HOLDERS_BATCH);
        ReceiptServiceType serviceType = (ReceiptServiceType)ctx.getMandatoryObject((Enum)IBusFiscalReceiptContextKeys.RECEIPT_SERVICE_TYPE);
        EntityStorageContext context = (EntityStorageContext)ctx.getMandatoryObject((Enum)IBusStandardContextKeys.ENTITY_STORAGE_CONTEXT);
        List receiptContainers = (List)IbusHelper.getObjectN((MessageContext)ctx, (Enum)IBusFiscalReceiptContextKeys.RECEIPT_CONTAINERS, ArrayList::new);
        Locale loc = LocaleHelper.getCurrentLocale();
        Receipt receipt = new Receipt();
        receipt.setStatus(ReceiptStatus.NEW);
        receipt.setServiceType(serviceType);
        receipt.setOwner(bookingFileBatch.getBookingCtr().toReference());
        Date createDate = new Date();
        receipt.setCreated(createDate);
        receipt.setUpdated(createDate);
        ReceiptData receiptData = new ReceiptData();
        receipt.setReceiptData(receiptData);
        receiptData.setAgency(((BookingFile)bookingFileBatch.getBookingCtr().getEntity()).getAgency());
        receiptData.setType(receiptLinesHoldersBatch.getReceiptType());
        receiptData.setReceiptClient(receiptLinesHoldersBatch.getClient());
        receiptData.setClentEmail(TextUtil.nonBlank((String)clientAddress) ? clientAddress : null);
        HashSet<BaseEntity> receiptProducts = new HashSet<BaseEntity>();
        for (ReceiptLineValueHolder holder : receiptLinesHoldersBatch.getReceiptLineHolders()) {
            ReceiptLine receiptLine = holder.getReceiptLine();
            receiptData.getItems().add(receiptLine);
            receiptData.getCategories().addAll(holder.getFiscalCategories());
            receiptProducts.add(EntityStorageHelper.resolve((NestedEntityReference)receiptLine.getProductReference(), (EntityStorageContext)context));
        }
        String receiptType = receiptLinesHoldersBatch.getReceiptType().toString(loc);
        String productsName = receiptProducts.stream().map(product -> ProductHandler.of((BaseProduct)product).generateShortProductName(product)).filter(TextUtil::nonBlank).collect(Collectors.joining(", "));
        String receiptDataTypes = receiptLinesHoldersBatch.getReceiptDataTypes().stream().map(type -> type.toString(loc)).collect(Collectors.joining(", "));
        receipt.setDescription(String.format("%s %s (%s)", productsName, receiptDataTypes, receiptType));
        receiptContainers.add(EntityContainer.create((BaseEntity)receipt));
    }
}

