/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.model.ibus.receipt.fiscal.createReceipt;

import com.gridnine.xtrip.common.model.booking.BaseProduct;
import com.gridnine.xtrip.common.model.booking.Fop;
import com.gridnine.xtrip.common.model.booking.FopComponent;
import com.gridnine.xtrip.common.model.booking.ProductStatus;
import com.gridnine.xtrip.common.model.entity.EntityStorageContext;
import com.gridnine.xtrip.common.model.fiscal.IBusFiscalReceiptContextKeys;
import com.gridnine.xtrip.common.model.fiscal.ReceiptServiceType;
import com.gridnine.xtrip.common.model.handlers.ProductHandler;
import com.gridnine.xtrip.common.model.system.IBusStandardContextKeys;
import com.gridnine.xtrip.common.util.MiscUtil;
import com.gridnine.xtrip.server.ibus.components.BaseProcessor;
import com.gridnine.xtrip.server.ibus.components.MessageContext;
import com.gridnine.xtrip.server.model.ibus.receipt.fiscal.IbusFiscalReceiptHelper;
import com.gridnine.xtrip.server.model.ibus.receipt.fiscal.createReceipt.batch.BookingFileBatch;
import com.gridnine.xtrip.server.model.ibus.receipt.fiscal.createReceipt.batch.FopValueHolder;
import com.gridnine.xtrip.server.model.ibus.receipt.fiscal.createReceipt.batch.ProductBatch;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class CreateProductBatchesProcessor
extends BaseProcessor {
    public void process(MessageContext ctx) throws Exception {
        BookingFileBatch bookingFileBatch = (BookingFileBatch)ctx.getMandatoryObject((Enum)IBusFiscalReceiptContextKeys.BOOKING_FILE_BATCH);
        ReceiptServiceType serviceType = (ReceiptServiceType)ctx.getMandatoryObject((Enum)IBusFiscalReceiptContextKeys.RECEIPT_SERVICE_TYPE);
        EntityStorageContext context = (EntityStorageContext)ctx.getMandatoryObject((Enum)IBusStandardContextKeys.ENTITY_STORAGE_CONTEXT);
        Boolean isCancellation = (Boolean)ctx.getObject((Enum)IBusFiscalReceiptContextKeys.IS_CANCELLATION);
        HashMap<String, List> productBatchMap = new HashMap<String, List>();
        for (MiscUtil.Pair<BaseProduct, List<Fop>> pair : bookingFileBatch.getProductToFopsPairs()) {
            BaseProduct product = (BaseProduct)pair.getFirst();
            ProductStatus productStatus = ProductHandler.of((BaseProduct)product).getStatus(product);
            String batchKey = serviceType == ReceiptServiceType.ATOL_FISCAL_DEVICE ? product.getUid() : null;
            Map<Fop, List<FopComponent>> fopComponents = IbusFiscalReceiptHelper.getFopComponents(product, (List)pair.getSecond(), isCancellation, context);
            ArrayList<FopValueHolder> fopValueHolders = new ArrayList<FopValueHolder>();
            fopComponents.forEach((fop, components) -> {
                for (FopComponent component : components) {
                    fopValueHolders.add(new FopValueHolder((Fop)fop, component, productStatus));
                }
            });
            ProductBatch productBatch = new ProductBatch(bookingFileBatch.getBookingCtr(), product, fopValueHolders);
            productBatchMap.computeIfAbsent(batchKey, k -> new ArrayList()).add(productBatch);
        }
        ctx.putObject((Enum)IBusFiscalReceiptContextKeys.PRODUCT_BATCH_MAP, productBatchMap);
    }
}

