/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.model.ibus.receipt.fiscal.createReceipt;

import com.gridnine.xtrip.common.l10n.model.LocaleHelper;
import com.gridnine.xtrip.common.model.EntityContainer;
import com.gridnine.xtrip.common.model.NestedEntityReference;
import com.gridnine.xtrip.common.model.booking.BaseProduct;
import com.gridnine.xtrip.common.model.booking.BookingFile;
import com.gridnine.xtrip.common.model.booking.Fop;
import com.gridnine.xtrip.common.model.booking.FopComponent;
import com.gridnine.xtrip.common.model.booking.FopComponentType;
import com.gridnine.xtrip.common.model.dict.Airline;
import com.gridnine.xtrip.common.model.entity.EntityStorage;
import com.gridnine.xtrip.common.model.entity.EntityStorageContext;
import com.gridnine.xtrip.common.model.entity.EntityStorageHelper;
import com.gridnine.xtrip.common.model.fiscal.IBusFiscalReceiptContextKeys;
import com.gridnine.xtrip.common.model.fiscal.PaymentObject;
import com.gridnine.xtrip.common.model.fiscal.ReceiptLine;
import com.gridnine.xtrip.common.model.fiscal.ReceiptLineSellType;
import com.gridnine.xtrip.common.model.fiscal.ReceiptServiceType;
import com.gridnine.xtrip.common.model.fiscal.ReceiptType;
import com.gridnine.xtrip.common.model.fiscal.Supplier;
import com.gridnine.xtrip.common.model.handlers.ProductHandler;
import com.gridnine.xtrip.common.model.helpers.DictHelper;
import com.gridnine.xtrip.common.model.profile.BaseProfile;
import com.gridnine.xtrip.common.model.profile.Organization;
import com.gridnine.xtrip.common.model.profile.OrganizationIndex;
import com.gridnine.xtrip.common.model.system.IBusStandardContextKeys;
import com.gridnine.xtrip.common.util.TextUtil;
import com.gridnine.xtrip.server.ibus.IbusHelper;
import com.gridnine.xtrip.server.ibus.components.BaseProcessor;
import com.gridnine.xtrip.server.ibus.components.MessageContext;
import com.gridnine.xtrip.server.model.ibus.receipt.fiscal.IbusFiscalReceiptHelper;
import com.gridnine.xtrip.server.model.ibus.receipt.fiscal.createReceipt.batch.FopValueHolder;
import com.gridnine.xtrip.server.model.ibus.receipt.fiscal.createReceipt.batch.ProductBatch;
import com.gridnine.xtrip.server.model.ibus.receipt.fiscal.createReceipt.batch.ReceiptLineValueHolder;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;

public class CreateReceiptLineHoldersProcessor
extends BaseProcessor {
    public void process(MessageContext ctx) throws Exception {
        ProductBatch batch = (ProductBatch)ctx.getMandatoryObject((Enum)IBusFiscalReceiptContextKeys.PRODUCT_BATCH);
        EntityStorageContext context = (EntityStorageContext)ctx.getMandatoryObject((Enum)IBusStandardContextKeys.ENTITY_STORAGE_CONTEXT);
        Boolean isCancellation = (Boolean)ctx.getObject((Enum)IBusFiscalReceiptContextKeys.IS_CANCELLATION);
        ReceiptServiceType serviceType = (ReceiptServiceType)ctx.getMandatoryObject((Enum)IBusFiscalReceiptContextKeys.RECEIPT_SERVICE_TYPE);
        List productHolders = (List)IbusHelper.getForceObject((MessageContext)ctx, (Enum)IBusFiscalReceiptContextKeys.RECEIPT_LINE_HOLDERS_LOCAL, ArrayList::new);
        List holders = (List)IbusHelper.getObjectN((MessageContext)ctx, (Enum)IBusFiscalReceiptContextKeys.RECEIPT_LINE_HOLDERS, ArrayList::new);
        BaseProduct product = (BaseProduct)Objects.requireNonNull(EntityStorageHelper.resolve(batch.getProductReference(), (EntityStorageContext)context));
        ProductHandler productHandler = ProductHandler.of((BaseProduct)product);
        Supplier productSupplier = productHandler.getFiscalSupplier(product);
        boolean isTchProduct = Optional.ofNullable(productHandler.getBlankOwner(product)).map(arg_0 -> ((EntityStorage)EntityStorage.get()).resolve(arg_0)).map(EntityContainer::getEntity).map(BaseProfile::getCode).map("\u04281"::equals).orElse(false);
        for (FopValueHolder fopValueHolder : batch.getFopValueHolders()) {
            ReceiptLine receiptLine = new ReceiptLine();
            receiptLine.setQuantity(BigDecimal.ONE);
            receiptLine.setPaymentObject(PaymentObject.SERVICE);
            receiptLine.setPrice(fopValueHolder.getFopComponent().getAmount().abs());
            receiptLine.setTotal(fopValueHolder.getFopComponent().getAmount().abs());
            receiptLine.setProductReference(batch.getProductReference());
            receiptLine.setPaymentMethod(IbusFiscalReceiptHelper.getPaymentMethod(fopValueHolder.getFopComponent().getType(), serviceType));
            receiptLine.setPaymentType(IbusFiscalReceiptHelper.convertPaymentType(fopValueHolder.getPaymentType()));
            receiptLine.setFop(new NestedEntityReference(batch.getProductReference().getUid(), BookingFile.class, fopValueHolder.getFopUid(), Fop.class, null));
            receiptLine.setFopComponent(new NestedEntityReference(batch.getProductReference().getUid(), BookingFile.class, fopValueHolder.getFopComponent().getUid(), FopComponent.class, null));
            receiptLine.setLineType(IbusFiscalReceiptHelper.convertFopComponentType2ReceiptLineType(fopValueHolder.getFopComponent().getType()));
            receiptLine.setSellType(this.isSupplierFopComponent(fopValueHolder) ? ReceiptLineSellType.AGENT : ReceiptLineSellType.OWN);
            receiptLine.setSupplier(this.getSupplier(fopValueHolder, isTchProduct, productSupplier));
            ReceiptType receiptType = IbusFiscalReceiptHelper.defineReceiptType(fopValueHolder.getFopComponent().getAmount(), isCancellation, fopValueHolder.getProductStatus());
            ReceiptLineValueHolder valueHolder = new ReceiptLineValueHolder(receiptLine, receiptType, fopValueHolder);
            productHolders.add(valueHolder);
            holders.add(valueHolder);
        }
    }

    private Supplier getSupplier(FopValueHolder fopValueHolder, boolean isTchProduct, Supplier productSupplier) {
        if (fopValueHolder.getFopComponent().getType() == FopComponentType.VENDOR_FEES && isTchProduct || "ZZ".equals(fopValueHolder.getTaxCode())) {
            return this.getTchAsSupplier();
        }
        return productSupplier;
    }

    private Supplier getTchAsSupplier() {
        Airline tch = DictHelper.findAirlineByAnyCode((String)"\u04281");
        EntityContainer tchCtr = EntityStorage.get().find(OrganizationIndex.class, OrganizationIndex.Property.airline.name(), (Object)tch.toReference());
        String tchName = tch.getTranslations().entrySet().stream().filter(entry -> LocaleHelper.RU_LOCALE.getLanguage().equals(((Locale)entry.getKey()).getLanguage())).map(Map.Entry::getValue).findFirst().orElse((String)tch.getTranslations().get(LocaleHelper.EN_LOCALE));
        String registrationId = TextUtil.nonBlank((String)((Organization)tchCtr.getEntity()).getRegistrationId()) ? ((Organization)tchCtr.getEntity()).getRegistrationId() : tch.getRegistrationId();
        Supplier result = new Supplier();
        result.setName(tchName);
        result.setINN(registrationId);
        result.setPhoneNum(tch.getPhone());
        return result;
    }

    private boolean isSupplierFopComponent(FopValueHolder holder) {
        FopComponentType type = holder.getFopComponent().getType();
        return type != FopComponentType.OWN_FEES && type != FopComponentType.DISCOUNTS;
    }
}

