/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.model.ibus.receipt.fiscal.createReceipt;

import com.gridnine.xtrip.common.model.BaseEntity;
import com.gridnine.xtrip.common.model.EntityContainer;
import com.gridnine.xtrip.common.model.EntityReference;
import com.gridnine.xtrip.common.model.NestedEntityReference;
import com.gridnine.xtrip.common.model.booking.BaseProduct;
import com.gridnine.xtrip.common.model.booking.Fop;
import com.gridnine.xtrip.common.model.booking.FopDetalization;
import com.gridnine.xtrip.common.model.entity.EntityStorageContext;
import com.gridnine.xtrip.common.model.entity.EntityStorageHelper;
import com.gridnine.xtrip.common.model.fiscal.IBusFiscalReceiptContextKeys;
import com.gridnine.xtrip.common.model.fiscal.Receipt;
import com.gridnine.xtrip.common.model.system.IBusStandardContextKeys;
import com.gridnine.xtrip.server.ibus.IbusHelper;
import com.gridnine.xtrip.server.ibus.components.BaseProcessor;
import com.gridnine.xtrip.server.ibus.components.MessageContext;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;

public class FindPreviousReceiptsProcessor
extends BaseProcessor {
    public void process(MessageContext ctx) throws Exception {
        Map productsToFopsMap = (Map)ctx.getMandatoryObject((Enum)IBusFiscalReceiptContextKeys.PRODUCTS_TO_FOPS_MAP);
        EntityStorageContext context = (EntityStorageContext)ctx.getMandatoryObject((Enum)IBusStandardContextKeys.ENTITY_STORAGE_CONTEXT);
        Map fopPayerMap = (Map)IbusHelper.getObjectN((MessageContext)ctx, (Enum)IBusFiscalReceiptContextKeys.FOP_PAYER_MAP, HashMap::new);
        Map productsToPreviousReceipts = (Map)IbusHelper.getObjectN((MessageContext)ctx, (Enum)IBusFiscalReceiptContextKeys.PRODUCTS_TO_PREVIOUS_RECEIPTS_MAP, HashMap::new);
        productsToFopsMap.forEach((pair, fopList) -> {
            NestedEntityReference ref = new NestedEntityReference((EntityContainer)pair.getFirst(), (BaseEntity)pair.getSecond());
            Map fopDetalizations = ((BaseProduct)pair.getSecond()).getFopDetalizations();
            for (Fop fop : fopList) {
                FopDetalization fopDetalization = (FopDetalization)fopDetalizations.get(fop.getUid());
                if (fopDetalization == null) continue;
                List detalizationReceipts = fopDetalization.getComponents().stream().map(fopComponent -> EntityStorageHelper.resolve((EntityReference)fopComponent.getReceipt(), (EntityStorageContext)context)).filter(Objects::nonNull).distinct().collect(Collectors.toList());
                detalizationReceipts.stream().map(ctr -> ((Receipt)ctr.getEntity()).getReceiptData().getReceiptClient()).filter(Objects::nonNull).findFirst().ifPresent(client -> fopPayerMap.put(fop.getUid(), client.getProfileReference()));
                productsToPreviousReceipts.computeIfAbsent(ref, r -> new HashSet()).addAll(detalizationReceipts);
            }
        });
    }
}

