/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.model.ibus.receipt.fiscal.createReceipt;

import com.gridnine.xtrip.common.model.EntityContainer;
import com.gridnine.xtrip.common.model.EntityReference;
import com.gridnine.xtrip.common.model.NestedEntityReference;
import com.gridnine.xtrip.common.model.fiscal.IBusFiscalReceiptContextKeys;
import com.gridnine.xtrip.common.model.fiscal.Receipt;
import com.gridnine.xtrip.common.model.fiscal.ReceiptLine;
import com.gridnine.xtrip.common.model.fiscal.ReceiptType;
import com.gridnine.xtrip.common.util.CollectionUtil;
import com.gridnine.xtrip.common.util.MiscUtil;
import com.gridnine.xtrip.server.ibus.components.BaseProcessor;
import com.gridnine.xtrip.server.ibus.components.MessageContext;
import com.gridnine.xtrip.server.model.ibus.receipt.fiscal.IbusFiscalReceiptHelper;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;

public class FindReceiptsForCancelProcessor
extends BaseProcessor {
    public void process(MessageContext ctx) throws Exception {
        List receiptContainers = (List)ctx.getMandatoryObject((Enum)IBusFiscalReceiptContextKeys.RECEIPT_CONTAINERS);
        Map productsToPreviousReceipts = (Map)ctx.getMandatoryObject((Enum)IBusFiscalReceiptContextKeys.PRODUCTS_TO_PREVIOUS_RECEIPTS_MAP);
        HashMap<EntityReference, EntityContainer> previousReceipts = new HashMap<EntityReference, EntityContainer>();
        for (EntityContainer receiptContainer : receiptContainers) {
            NestedEntityReference productRef = (NestedEntityReference)((List)CollectionUtil.requireNonEmpty((Collection)((Receipt)receiptContainer.getEntity()).getReceiptData().getItems().stream().map(ReceiptLine::getProductReference).distinct().collect(Collectors.toList()), () -> "product is absent in receipt " + receiptContainer)).get(0);
            ReceiptType revertedReceiptType = IbusFiscalReceiptHelper.revertReceiptType(((Receipt)receiptContainer.getEntity()).getReceiptData().getType());
            EntityContainer previousReceiptContainer = ((Set)productsToPreviousReceipts.get(productRef)).stream().filter(previousReceipt -> ((Receipt)previousReceipt.getEntity()).getReceiptData().getType() == revertedReceiptType).filter(previousReceipt -> this.isSame((Receipt)previousReceipt.getEntity(), (Receipt)receiptContainer.getEntity())).findFirst().orElse(null);
            previousReceipts.put(receiptContainer.toReference(), previousReceiptContainer);
        }
        ctx.putObject((Enum)IBusFiscalReceiptContextKeys.PREVIOUS_RECEIPTS, previousReceipts);
    }

    private boolean isSame(Receipt first, Receipt second) {
        return first.getReceiptData() != null && second.getReceiptData() != null && CollectionUtil.equals((Collection)first.getReceiptData().getItems(), (Collection)second.getReceiptData().getItems(), this::isSame, (boolean)true);
    }

    private boolean isSame(ReceiptLine first, ReceiptLine second) {
        return MiscUtil.equals((Object)first.getTotal(), (Object)second.getTotal()) && first.getPaymentType() == second.getPaymentType();
    }
}

