/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.model.ibus.receipt.fiscal.createReceipt;

import com.gridnine.xtrip.common.model.NestedEntityReference;
import com.gridnine.xtrip.common.model.booking.Fop;
import com.gridnine.xtrip.common.model.entity.EntityStorageContext;
import com.gridnine.xtrip.common.model.entity.EntityStorageHelper;
import com.gridnine.xtrip.common.model.fiscal.IBusFiscalReceiptContextKeys;
import com.gridnine.xtrip.common.model.system.IBusStandardContextKeys;
import com.gridnine.xtrip.common.util.MiscUtil;
import com.gridnine.xtrip.server.ibus.components.BaseProcessor;
import com.gridnine.xtrip.server.ibus.components.MessageContext;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;

public class LoadProductsProcessor
extends BaseProcessor {
    public void process(MessageContext ctx) throws Exception {
        Map productsToFopReference = (Map)ctx.getMandatoryObject((Enum)IBusFiscalReceiptContextKeys.PRODUCTS_TO_PAY_REFERENCE);
        EntityStorageContext context = (EntityStorageContext)ctx.getMandatoryObject((Enum)IBusStandardContextKeys.ENTITY_STORAGE_CONTEXT);
        boolean alreadyLoaded = ctx.hasObject((Enum)IBusFiscalReceiptContextKeys.PRODUCTS_TO_FOPS_MAP);
        if (!alreadyLoaded) {
            Map<MiscUtil.Pair, List> productsToFopsMap = productsToFopReference.entrySet().stream().collect(Collectors.toMap(entry -> Objects.requireNonNull(EntityStorageHelper.resolveDetailed((NestedEntityReference)((NestedEntityReference)entry.getKey()), (EntityStorageContext)context), "Can't resolve booking or product: " + entry.getKey()), entry -> ((List)entry.getValue()).stream().map(ref -> (Fop)Objects.requireNonNull(EntityStorageHelper.resolve((NestedEntityReference)ref, (EntityStorageContext)context), "Can't resolve fop " + ref)).collect(Collectors.toList())));
            ctx.putObject((Enum)IBusFiscalReceiptContextKeys.PRODUCTS_TO_FOPS_MAP, productsToFopsMap);
        }
    }
}

