/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.model.ibus.receipt.fiscal.createReceipt;

import com.gridnine.xtrip.common.l10n.model.LocaleHelper;
import com.gridnine.xtrip.common.model.EntityContainer;
import com.gridnine.xtrip.common.model.EntityReference;
import com.gridnine.xtrip.common.model.dict.DictionaryReference;
import com.gridnine.xtrip.common.model.entity.EntityStorageContext;
import com.gridnine.xtrip.common.model.entity.EntityStorageHelper;
import com.gridnine.xtrip.common.model.fiscal.IBusFiscalReceiptContextKeys;
import com.gridnine.xtrip.common.model.fiscal.ReceiptClient;
import com.gridnine.xtrip.common.model.fiscal.ReceiptDataType;
import com.gridnine.xtrip.common.model.fiscal.ReceiptType;
import com.gridnine.xtrip.common.model.profile.Organization;
import com.gridnine.xtrip.common.model.system.IBusStandardContextKeys;
import com.gridnine.xtrip.common.util.MiscUtil;
import com.gridnine.xtrip.server.ibus.components.BaseProcessor;
import com.gridnine.xtrip.server.ibus.components.MessageContext;
import com.gridnine.xtrip.server.model.ibus.receipt.fiscal.IbusFiscalReceiptHelper;
import com.gridnine.xtrip.server.model.ibus.receipt.fiscal.createReceipt.batch.ReceiptLineValueHolder;
import com.gridnine.xtrip.server.model.ibus.receipt.fiscal.createReceipt.batch.ReceiptLinesHoldersBatch;
import java.util.Arrays;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Supplier;
import java.util.stream.Collectors;

public class ReceiptLinesBatchProcessor
extends BaseProcessor {
    private static final Comparator<ReceiptLinesHoldersBatch> LINES_HOLDERS_BATCH_COMPARATOR = MiscUtil.comparator(Arrays.asList((batch1, batch2) -> {
        Objects.requireNonNull(batch1.getReceiptType());
        Objects.requireNonNull(batch2.getReceiptType());
        if (batch1.getReceiptType() == batch2.getReceiptType()) {
            return 0;
        }
        if (batch1.getReceiptType() == ReceiptType.SELL && batch2.getReceiptType() == ReceiptType.SELL_REFUND) {
            return -1;
        }
        return 1;
    }, (batch1, batch2) -> {
        boolean batch2WithProduct;
        boolean batch1WithProduct = batch1.getReceiptDataTypes().stream().anyMatch(dataType -> dataType == ReceiptDataType.PRODUCT);
        if (batch1WithProduct == (batch2WithProduct = batch2.getReceiptDataTypes().stream().anyMatch(dataType -> dataType == ReceiptDataType.PRODUCT))) {
            return 0;
        }
        if (batch2WithProduct) {
            return 1;
        }
        return -1;
    }));

    public void process(MessageContext ctx) throws Exception {
        List receiptLineHolders = (List)ctx.getMandatoryObject((Enum)IBusFiscalReceiptContextKeys.RECEIPT_LINE_HOLDERS);
        Map fopPayerMap = (Map)ctx.getMandatoryObject((Enum)IBusFiscalReceiptContextKeys.FOP_PAYER_MAP);
        EntityStorageContext context = (EntityStorageContext)ctx.getMandatoryObject((Enum)IBusStandardContextKeys.ENTITY_STORAGE_CONTEXT);
        HashMap<String, ReceiptLinesHoldersBatch> receiptLineHoldersBatch = new HashMap<String, ReceiptLinesHoldersBatch>();
        for (ReceiptLineValueHolder holder : receiptLineHolders) {
            ReceiptType receiptType = holder.getReceiptType();
            EntityReference payer = (EntityReference)fopPayerMap.get(holder.getFopValueHolder().getFopUid());
            Supplier<ReceiptClient> clientSupplier = ReceiptLinesBatchProcessor.getReceiptClientSupplier((EntityReference<Organization>)payer, context);
            ReceiptDataType dataType = IbusFiscalReceiptHelper.convertReceiptLineType2ReceiptDataType(holder.getReceiptLine().getLineType());
            String category = holder.getFiscalCategories().stream().map(DictionaryReference::getCode).collect(Collectors.joining("-")) + String.format("(%s)", receiptType.name() + String.format("(%s)", payer));
            ReceiptLinesHoldersBatch batch = receiptLineHoldersBatch.computeIfAbsent(category, cat -> new ReceiptLinesHoldersBatch(receiptType, (ReceiptClient)clientSupplier.get()));
            batch.getReceiptLineHolders().add(holder);
            batch.getReceiptDataTypes().add(dataType);
        }
        List resultBatchList = receiptLineHoldersBatch.values().stream().sorted(LINES_HOLDERS_BATCH_COMPARATOR).collect(Collectors.toList());
        ctx.putObject((Enum)IBusFiscalReceiptContextKeys.RECEIPT_LINES_HOLDERS_BATCH_LIST, resultBatchList);
    }

    private static Supplier<ReceiptClient> getReceiptClientSupplier(EntityReference<Organization> payer, EntityStorageContext context) {
        return () -> Optional.ofNullable(EntityStorageHelper.resolve((EntityReference)payer, (EntityStorageContext)context)).map(EntityContainer::getEntity).map(client -> {
            ReceiptClient result = new ReceiptClient();
            result.setProfileReference(payer);
            result.setName(client.getFullName().toString(LocaleHelper.getCurrentLocale()));
            result.setINN(client.getRegistrationId());
            return result;
        }).orElse(null);
    }
}

