/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.model.ibus.receipt.fiscal.createReceipt;

import com.gridnine.xtrip.common.l10n.model.L10nString;
import com.gridnine.xtrip.common.l10n.model.L10nStringHelper;
import com.gridnine.xtrip.common.l10n.model.LocaleHelper;
import com.gridnine.xtrip.common.model.EntityContainer;
import com.gridnine.xtrip.common.model.EntityReference;
import com.gridnine.xtrip.common.model.booking.BaseProduct;
import com.gridnine.xtrip.common.model.booking.Fop;
import com.gridnine.xtrip.common.model.booking.FopComponent;
import com.gridnine.xtrip.common.model.booking.air.Product;
import com.gridnine.xtrip.common.model.booking.railway.RailwayProduct;
import com.gridnine.xtrip.common.model.dict.Airline;
import com.gridnine.xtrip.common.model.dict.ContractType;
import com.gridnine.xtrip.common.model.entity.EntityStorage;
import com.gridnine.xtrip.common.model.entity.EntityStorageContext;
import com.gridnine.xtrip.common.model.fiscal.IBusFiscalReceiptContextKeys;
import com.gridnine.xtrip.common.model.fiscal.Supplier;
import com.gridnine.xtrip.common.model.handlers.ProductHandler;
import com.gridnine.xtrip.common.model.helpers.BookingHelper;
import com.gridnine.xtrip.common.model.helpers.DictHelper;
import com.gridnine.xtrip.common.model.helpers.GeneralProductHelper;
import com.gridnine.xtrip.common.model.profile.AgreementType;
import com.gridnine.xtrip.common.model.profile.Contract;
import com.gridnine.xtrip.common.model.profile.Organization;
import com.gridnine.xtrip.common.model.profile.OrganizationIndex;
import com.gridnine.xtrip.common.model.standard.helpers.MessagesHelper;
import com.gridnine.xtrip.common.model.system.IBusStandardContextKeys;
import com.gridnine.xtrip.common.model.system.MessageType;
import com.gridnine.xtrip.common.model.validation.ValidationException;
import com.gridnine.xtrip.common.util.MiscUtil;
import com.gridnine.xtrip.common.util.TextUtil;
import com.gridnine.xtrip.server.ibus.IbusHelper;
import com.gridnine.xtrip.server.ibus.components.BaseProcessor;
import com.gridnine.xtrip.server.ibus.components.MessageContext;
import com.gridnine.xtrip.server.model.ibus.receipt.fiscal.IbusFiscalReceiptHelper;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;

public class ValidateProductsProcessor
extends BaseProcessor {
    public void process(MessageContext ctx) throws Exception {
        Map productsToFopsMap = (Map)ctx.getMandatoryObject((Enum)IBusFiscalReceiptContextKeys.PRODUCTS_TO_FOPS_MAP);
        EntityStorageContext context = (EntityStorageContext)ctx.getMandatoryObject((Enum)IBusStandardContextKeys.ENTITY_STORAGE_CONTEXT);
        Boolean isCancellation = (Boolean)ctx.getObject((Enum)IBusFiscalReceiptContextKeys.IS_CANCELLATION);
        List messages = (List)IbusHelper.getObjectN((MessageContext)ctx, (Enum)IBusFiscalReceiptContextKeys.MESSAGE, ArrayList::new);
        productsToFopsMap.forEach((productPair, fops) -> {
            Map<Fop, List<FopComponent>> fopComponents;
            boolean isProductWithHiddenFee;
            BaseProduct product = (BaseProduct)productPair.getSecond();
            ProductHandler handler = ProductHandler.of((BaseProduct)product);
            boolean bl = isProductWithHiddenFee = GeneralProductHelper.filterCommissions((Collection)GeneralProductHelper.getUnmodifiableCommissions((BaseProduct)product, (ContractType)ContractType.CLIENT), null, null, Collections.singleton(GeneralProductHelper.CommissionCategory.HIDDEN)).size() > 0;
            if (isProductWithHiddenFee) {
                messages.add(MessagesHelper.createMessage((MessageType)MessageType.ERROR, (String)"FiscalReceipt_productWithHiddenFeeFound", (Object[])new Object[]{product.getUid()}));
            }
            if ((fopComponents = IbusFiscalReceiptHelper.getFopComponents(product, fops, isCancellation, context)).isEmpty()) {
                messages.add(MessagesHelper.createMessage((MessageType)MessageType.ERROR, (String)"FiscalReceipt_missingFopComponentsForProduct", (Object[])new Object[]{BookingHelper.generateShortProductName((BaseProduct)product)}));
            }
            if (product.getClass() == Product.class) {
                boolean isTchProduct;
                Supplier supplier = handler.getFiscalSupplier(product);
                if (supplier != null) {
                    if (TextUtil.isBlank((String)supplier.getName())) {
                        messages.add(MessagesHelper.createMessage((MessageType)MessageType.ERROR, (String)"FiscalReceipt_missingCarrierName", (Object[])new Object[]{supplier.getINN()}));
                    }
                    if (TextUtil.isBlank((String)supplier.getINN())) {
                        messages.add(MessagesHelper.createMessage((MessageType)MessageType.ERROR, (String)"FiscalReceipt_missingCarrierRegistrationNumber", (Object[])new Object[0]));
                    }
                } else {
                    messages.add(MessagesHelper.createMessage((MessageType)MessageType.ERROR, (String)"FiscalReceipt_missingCarrier", (Object[])new Object[]{((Product)product).getSystemNumber()}));
                }
                if (isTchProduct = handler.getTaxes(product).stream().anyMatch(tax -> MiscUtil.equals((Object)tax.getCode(), (Object)"ZZ"))) {
                    Airline tch = DictHelper.findAirlineByAnyCode((String)"\u04281");
                    if (tch != null) {
                        EntityContainer tchCtr = EntityStorage.get().find(OrganizationIndex.class, OrganizationIndex.Property.airline.name(), (Object)tch.toReference());
                        if (tchCtr == null) {
                            messages.add(MessagesHelper.createMessage((MessageType)MessageType.ERROR, (String)"FiscalReceipt_missingTchOrganization", (Object[])new Object[0]));
                        } else if (TextUtil.isBlank((String)tch.getRegistrationId()) && TextUtil.isBlank((String)((Organization)tchCtr.getEntity()).getRegistrationId())) {
                            messages.add(MessagesHelper.createMessage((MessageType)MessageType.ERROR, (String)"FiscalReceipt_missingTchRegistrationNumber", (Object[])new Object[0]));
                        }
                    } else {
                        messages.add(MessagesHelper.createMessage((MessageType)MessageType.ERROR, (String)"FiscalReceipt_missingTchAirline", (Object[])new Object[0]));
                    }
                }
            } else if (product.getClass() == RailwayProduct.class) {
                Supplier supplier = handler.getFiscalSupplier(product);
                if (supplier != null) {
                    if (TextUtil.isBlank((String)supplier.getName())) {
                        messages.add(MessagesHelper.createMessage((MessageType)MessageType.ERROR, (String)"FiscalReceipt_missingPrincipalName", (Object[])new Object[]{supplier.getINN()}));
                    }
                    if (TextUtil.isBlank((String)supplier.getINN())) {
                        messages.add(MessagesHelper.createMessage((MessageType)MessageType.ERROR, (String)"FiscalReceipt_missingPrincipalRegistrationNumber", (Object[])new Object[0]));
                    }
                } else {
                    messages.add(MessagesHelper.createMessage((MessageType)MessageType.ERROR, (String)"FiscalReceipt_missingPrincipal", (Object[])new Object[]{product.getUid()}));
                }
            } else {
                EntityContainer vendorContractCtr = EntityStorage.get().resolve((EntityReference)Optional.ofNullable(GeneralProductHelper.getVendorContractRelation((BaseProduct)product)).map(vcr -> vcr.getGeneralData().getContractData().getContract()).orElse(null));
                if (vendorContractCtr != null && ((Contract)vendorContractCtr.getEntity()).getAgreementType() == AgreementType.AGENCY_CONTRACT) {
                    EntityContainer supplierCtr = EntityStorage.get().resolve(((Contract)vendorContractCtr.getEntity()).getSupplier());
                    if (supplierCtr != null) {
                        String supplierFullName = L10nStringHelper.getValue((L10nString)((Organization)supplierCtr.getEntity()).getFullName(), (Locale)LocaleHelper.RU_LOCALE, (boolean)false);
                        if (TextUtil.isBlank((String)supplierFullName)) {
                            messages.add(MessagesHelper.createMessage((MessageType)MessageType.ERROR, (String)"FiscalReceipt_missingSupplierName", (Object[])new Object[0]));
                        }
                        if (!((Organization)supplierCtr.getEntity()).isForeign() && TextUtil.isBlank((String)((Organization)supplierCtr.getEntity()).getRegistrationId())) {
                            messages.add(MessagesHelper.createMessage((MessageType)MessageType.ERROR, (String)"FiscalReceipt_missingSupplierRegistrationNumber", (Object[])new Object[0]));
                        }
                    } else {
                        messages.add(MessagesHelper.createMessage((MessageType)MessageType.ERROR, (String)"FiscalReceipt_missingSupplier", (Object[])new Object[]{product.getUid()}));
                    }
                }
            }
        });
        if (!messages.isEmpty()) {
            throw new ValidationException();
        }
    }
}

