/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.model.ibus.receipt.fiscal.createReceipt;

import com.gridnine.xtrip.common.l10n.model.LocaleHelper;
import com.gridnine.xtrip.common.model.EntityContainer;
import com.gridnine.xtrip.common.model.EntityReference;
import com.gridnine.xtrip.common.model.entity.EntityStorageContext;
import com.gridnine.xtrip.common.model.entity.EntityStorageHelper;
import com.gridnine.xtrip.common.model.fiscal.IBusFiscalReceiptContextKeys;
import com.gridnine.xtrip.common.model.profile.Organization;
import com.gridnine.xtrip.common.model.standard.helpers.MessagesHelper;
import com.gridnine.xtrip.common.model.system.IBusStandardContextKeys;
import com.gridnine.xtrip.common.model.system.MessageType;
import com.gridnine.xtrip.common.model.validation.ValidationException;
import com.gridnine.xtrip.common.util.MiscUtil;
import com.gridnine.xtrip.common.util.TextUtil;
import com.gridnine.xtrip.server.ibus.IbusHelper;
import com.gridnine.xtrip.server.ibus.components.BaseProcessor;
import com.gridnine.xtrip.server.ibus.components.MessageContext;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class ValidateReceiptPayersProcessor
extends BaseProcessor {
    public void process(MessageContext ctx) throws Exception {
        EntityStorageContext context = (EntityStorageContext)ctx.getMandatoryObject((Enum)IBusStandardContextKeys.ENTITY_STORAGE_CONTEXT);
        Map fopPayerMap = (Map)IbusHelper.getObjectN((MessageContext)ctx, (Enum)IBusFiscalReceiptContextKeys.FOP_PAYER_MAP, HashMap::new);
        List messages = (List)IbusHelper.getObjectN((MessageContext)ctx, (Enum)IBusFiscalReceiptContextKeys.MESSAGE, ArrayList::new);
        for (EntityReference payerRef : fopPayerMap.values()) {
            EntityContainer payerCtr = EntityStorageHelper.resolve((EntityReference)payerRef, (EntityStorageContext)context);
            if (payerCtr == null) {
                messages.add(MessagesHelper.createMessage((MessageType)MessageType.ERROR, (String)"FiscalReceiptPayer_missingPayer", (Object[])new Object[]{payerRef}));
                continue;
            }
            Organization payer = (Organization)payerCtr.getEntity();
            String name = payer.getFullName().toString(LocaleHelper.getCurrentLocale());
            if (TextUtil.isBlank((String)name)) {
                messages.add(MessagesHelper.createMessage((MessageType)MessageType.ERROR, (String)"FiscalReceiptPayer_missingPayerName", (Object[])new Object[0]));
            }
            if (TextUtil.isBlank((String)payer.getRegistrationId())) {
                messages.add(MessagesHelper.createMessage((MessageType)MessageType.ERROR, (String)"FiscalReceiptPayer_missingRegistrationId", (Object[])new Object[0]));
                continue;
            }
            boolean validLength = MiscUtil.isBetween((Number)10, (Number)12, (Number)payer.getRegistrationId().trim().length());
            boolean validValue = payer.getRegistrationId().matches("\\d*");
            if (validLength && validValue) continue;
            messages.add(MessagesHelper.createMessage((MessageType)MessageType.ERROR, (String)"FiscalReceiptPayer_invalidRegistrationId", (Object[])new Object[0]));
        }
        if (!messages.isEmpty()) {
            throw new ValidationException();
        }
    }
}

