/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.model.ibus.receipt.fiscal.registerReceipt;

import com.gridnine.xtrip.common.lockmanager.LockUtil;
import com.gridnine.xtrip.common.lockmanager.NamedLock;
import com.gridnine.xtrip.common.model.fiscal.IBusFiscalReceiptContextKeys;
import com.gridnine.xtrip.server.ibus.components.BaseAdvice;
import com.gridnine.xtrip.server.ibus.components.MessageContext;
import com.gridnine.xtrip.server.model.ibus.receipt.fiscal.registerReceipt.FiscalReceiptBatch;
import java.util.concurrent.TimeUnit;

public class BookingLockContainerAdvice
extends BaseAdvice {
    private final String LOCK_KEY = "ReceiptLockContainersAdvice_LOCK_KEY";

    public void before(MessageContext ctx) throws Exception {
        FiscalReceiptBatch fiscalReceiptBatch = (FiscalReceiptBatch)ctx.getMandatoryObject((Enum)IBusFiscalReceiptContextKeys.FISCAL_RECEIPT_BATCH);
        NamedLock lock = null;
        try {
            lock = LockUtil.getLockManager().getLock((Object)LockUtil.getLockKey(fiscalReceiptBatch.getBookingFileRef()), TimeUnit.MINUTES.toMillis(1L));
            if (!lock.tryLock(1L, TimeUnit.MINUTES)) {
                throw new Exception("unable to get lock for " + fiscalReceiptBatch.getBookingFileRef());
            }
            ctx.putObject("ReceiptLockContainersAdvice_LOCK_KEY", (Object)lock);
        }
        catch (Exception e) {
            this.unlock(lock);
            throw e;
        }
    }

    public void after(MessageContext ctx) throws Exception {
        NamedLock lock = (NamedLock)ctx.getObject("ReceiptLockContainersAdvice_LOCK_KEY");
        this.unlock(lock);
    }

    private void unlock(NamedLock lock) {
        if (lock != null) {
            try {
                lock.unlock();
            }
            catch (Exception e) {
                this.log.error(String.format("unable to unlock %s", lock.getName()), (Throwable)e);
            }
            finally {
                try {
                    lock.close();
                }
                catch (Exception e) {
                    this.log.error("unable to close lock for " + lock.getName(), (Throwable)e);
                }
            }
        }
    }
}

