/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.model.ibus.receipt.fiscal.registerReceipt;

import com.gridnine.xtrip.common.incidents.IncidentsLog;
import com.gridnine.xtrip.common.model.EntityContainer;
import com.gridnine.xtrip.common.model.NestedEntityReference;
import com.gridnine.xtrip.common.model.entity.EntityStorage;
import com.gridnine.xtrip.common.model.fiscal.IBusFiscalReceiptContextKeys;
import com.gridnine.xtrip.common.model.fiscal.Receipt;
import com.gridnine.xtrip.common.model.fiscal.ReceiptLine;
import com.gridnine.xtrip.common.model.fiscal.ReceiptStatus;
import com.gridnine.xtrip.common.model.fiscal.ReceiptType;
import com.gridnine.xtrip.common.model.standard.helpers.MessagesHelper;
import com.gridnine.xtrip.common.model.system.Message;
import com.gridnine.xtrip.common.model.system.MessageType;
import com.gridnine.xtrip.server.ibus.components.BaseProcessor;
import com.gridnine.xtrip.server.ibus.components.MessageContext;
import com.gridnine.xtrip.server.model.helpers.SysLogHelper;
import java.util.Iterator;
import java.util.List;
import java.util.stream.Collectors;

public class SaveFiscalReceiptsProcessor
extends BaseProcessor {
    public void process(MessageContext ctx) throws Exception {
        List receiptContainers = (List)ctx.getMandatoryObject((Enum)IBusFiscalReceiptContextKeys.RECEIPT_CONTAINERS);
        Iterator iterator = receiptContainers.iterator();
        while (iterator.hasNext()) {
            EntityContainer receiptCtr = (EntityContainer)iterator.next();
            ((Receipt)receiptCtr.getEntity()).setStatus(ReceiptStatus.COMPLETE);
            try {
                ReceiptType type = ((Receipt)receiptCtr.getEntity()).getReceiptData().getType();
                receiptCtr.getVersionInfo().setDataSource("register-fiscal-receipt-" + type.name());
                receiptCtr.getVersionInfo().setVersionNotes(((Receipt)receiptCtr.getEntity()).getServiceType().toString());
                EntityStorage.get().save(receiptCtr, true);
            }
            catch (Exception e) {
                Message message = MessagesHelper.createMessage((MessageType)MessageType.ERROR, (String)"FiscalReceipt_unableToSaveFiscalReceipt", (Throwable)e, (Object[])new Object[]{((Receipt)receiptCtr.getEntity()).getReceiptData().getItems().stream().map(ReceiptLine::getProductReference).distinct().map(NestedEntityReference::toString).collect(Collectors.joining(", "))});
                IncidentsLog.reportException((String)message.getMessage().toString(), (Throwable)e);
                SysLogHelper.audit(((Receipt)receiptCtr.getEntity()).getOwner(), "register-fiscal-receipt", message);
                iterator.remove();
            }
        }
    }
}

