/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.model.ibus.receipt.fiscal.registerReceipt;

import com.gridnine.xtrip.common.model.EntityContainer;
import com.gridnine.xtrip.common.model.NestedEntityReference;
import com.gridnine.xtrip.common.model.booking.BaseProduct;
import com.gridnine.xtrip.common.model.booking.FopComponent;
import com.gridnine.xtrip.common.model.booking.FopDetalization;
import com.gridnine.xtrip.common.model.booking.GeneralProductFop;
import com.gridnine.xtrip.common.model.dict.ContractType;
import com.gridnine.xtrip.common.model.entity.EntityStorageContext;
import com.gridnine.xtrip.common.model.entity.EntityStorageHelper;
import com.gridnine.xtrip.common.model.fiscal.IBusFiscalReceiptContextKeys;
import com.gridnine.xtrip.common.model.fiscal.Receipt;
import com.gridnine.xtrip.common.model.fiscal.ReceiptLine;
import com.gridnine.xtrip.common.model.helpers.GeneralProductHelper;
import com.gridnine.xtrip.common.model.helpers.ProfileHelper;
import com.gridnine.xtrip.common.model.system.IBusStandardContextKeys;
import com.gridnine.xtrip.common.util.BooleanUtil;
import com.gridnine.xtrip.server.ibus.components.BaseProcessor;
import com.gridnine.xtrip.server.ibus.components.MessageContext;
import com.gridnine.xtrip.server.model.ibus.receipt.fiscal.registerReceipt.FiscalReceiptBatch;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;

public class UpdateFopsProcessor
extends BaseProcessor {
    public void process(MessageContext ctx) throws Exception {
        EntityStorageContext context = (EntityStorageContext)ctx.getMandatoryObject((Enum)IBusStandardContextKeys.ENTITY_STORAGE_CONTEXT);
        FiscalReceiptBatch batch = (FiscalReceiptBatch)ctx.getMandatoryObject((Enum)IBusFiscalReceiptContextKeys.FISCAL_RECEIPT_BATCH);
        boolean isCancellation = BooleanUtil.nullAsFalse((Boolean)((Boolean)ctx.getObject((Enum)IBusFiscalReceiptContextKeys.IS_CANCELLATION)));
        HashMap<BaseProduct, List> productFopsMap = new HashMap<BaseProduct, List>();
        for (EntityContainer<Receipt> receiptCtr : batch.getReceipts()) {
            Receipt receipt = (Receipt)receiptCtr.getEntity();
            List products = receipt.getReceiptData().getItems().stream().map(ReceiptLine::getProductReference).distinct().map(ref -> (BaseProduct)EntityStorageHelper.resolve((NestedEntityReference)ref, (EntityStorageContext)context)).filter(Objects::nonNull).collect(Collectors.toList());
            HashSet<String> fopsUids = new HashSet<String>();
            for (ReceiptLine receiptLine : receipt.getReceiptData().getItems()) {
                FopComponent fopComponent2 = (FopComponent)EntityStorageHelper.resolve((NestedEntityReference)receiptLine.getFopComponent(), (EntityStorageContext)context);
                if (fopComponent2 != null) {
                    fopComponent2.setReceipt(isCancellation ? null : receiptCtr.toReference());
                }
                if (receiptLine.getFop() == null) continue;
                fopsUids.add(receiptLine.getFop().getNestedEntityUid());
            }
            for (BaseProduct product2 : products) {
                List generalProductFops = GeneralProductHelper.getClientFops((BaseProduct)product2).stream().filter(generalFop -> fopsUids.contains(generalFop.getUid())).collect(Collectors.toList());
                for (GeneralProductFop fop : generalProductFops) {
                    FopDetalization detalization = (FopDetalization)product2.getFopDetalizations().get(fop.getUid());
                    if (detalization == null) continue;
                    boolean isFopPayed = detalization.getComponents().stream().allMatch(fopComponent -> fopComponent.getReceipt() != null);
                    if (isFopPayed) {
                        fop.setOperationDate(new Date());
                        fop.setAgent(ProfileHelper.getCurrentUser());
                    } else {
                        fop.setOperationDate(null);
                        fop.setAgent(null);
                    }
                    productFopsMap.computeIfAbsent(product2, p -> new ArrayList()).add(fop);
                }
            }
        }
        productFopsMap.forEach((product, fops) -> GeneralProductHelper.updateFops((BaseProduct)product, (ContractType)ContractType.CLIENT, (List)fops));
    }
}

