/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.model.ibus.replace;

import com.gridnine.xtrip.common.model.EntityReference;
import com.gridnine.xtrip.common.model.booking.BaseProduct;
import com.gridnine.xtrip.common.model.booking.Fop;
import com.gridnine.xtrip.common.model.booking.IBusBookingContextKeys;
import com.gridnine.xtrip.common.model.profile.Organization;
import com.gridnine.xtrip.common.model.replace.IBusReplaceContextKeys;
import com.gridnine.xtrip.common.model.replace.OrganizationWrapper;
import com.gridnine.xtrip.server.ibus.components.BaseProcessor;
import com.gridnine.xtrip.server.ibus.components.MessageContext;
import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;

public abstract class AbstractProductOrganizationReplaceProcessor<P extends BaseProduct, F extends Fop>
extends BaseProcessor {
    private boolean updated;

    public void process(MessageContext context) throws Exception {
        List findWhatWrappers = (List)context.getMandatoryObject((Enum)IBusReplaceContextKeys.FIND_WHAT);
        List<EntityReference<Organization>> findWhat = findWhatWrappers.stream().map(OrganizationWrapper::getProfile).collect(Collectors.toList());
        EntityReference replaceWith = (EntityReference)context.getMandatoryObject((Enum)IBusReplaceContextKeys.REPLACE_WITH);
        BaseProduct product = (BaseProduct)context.getMandatoryObject((Enum)IBusBookingContextKeys.PRODUCT);
        Collection changedBookingFiles = (Collection)context.getMandatoryObject((Enum)IBusReplaceContextKeys.CHANGED_BOOKING_FILES);
        this.replace(this.getHandler(), product, findWhat, (EntityReference<Organization>)replaceWith);
        if (this.updated && product.getReservation() != null) {
            changedBookingFiles.add(product.getReservation().getBookingFile());
        }
    }

    public abstract Handler<P, F> getHandler();

    private void replace(Handler<P, F> handler, P product, List<EntityReference<Organization>> oldValues, EntityReference<Organization> newValue) {
        for (EntityReference<Organization> oldValue : oldValues) {
            this.replace(this.getHandler(), product, oldValue, newValue);
        }
    }

    private void replace(Handler<P, F> handler, P product, EntityReference<Organization> oldValue, EntityReference<Organization> newValue) {
        if (oldValue.equals(handler.getAgency(product))) {
            handler.setAgency(product, newValue);
            this.updated = true;
        }
        if (oldValue.equals(handler.getSubagency(product))) {
            handler.setSubagency(product, newValue);
            this.updated = true;
        }
        if (oldValue.equals(handler.getSupplier(product))) {
            handler.setSupplier(product, newValue);
            this.updated = true;
        }
        if (oldValue.equals(handler.getBlankOwner(product))) {
            handler.setBlankOwner(product, newValue);
            this.updated = true;
        }
        this.replaceFops(handler, handler.getVendorFops(product), oldValue, newValue);
        this.replaceFops(handler, handler.getSubagentFops(product), oldValue, newValue);
        this.replaceFops(handler, handler.getClientFops(product), oldValue, newValue);
    }

    private void replaceFops(Handler<P, F> handler, List<F> fops, EntityReference<Organization> oldValue, EntityReference<Organization> newValue) {
        for (Fop fop : fops) {
            if (!oldValue.equals(handler.getPayer(fop))) continue;
            handler.setPayer(fop, newValue);
            this.updated = true;
        }
    }

    public static interface Handler<P, F> {
        public EntityReference<Organization> getAgency(P var1);

        public void setAgency(P var1, EntityReference<Organization> var2);

        public EntityReference<Organization> getSubagency(P var1);

        public void setSubagency(P var1, EntityReference<Organization> var2);

        public EntityReference<Organization> getSupplier(P var1);

        public void setSupplier(P var1, EntityReference<Organization> var2);

        public EntityReference<Organization> getBlankOwner(P var1);

        public void setBlankOwner(P var1, EntityReference<Organization> var2);

        public List<F> getVendorFops(P var1);

        public List<F> getSubagentFops(P var1);

        public List<F> getClientFops(P var1);

        public EntityReference<Organization> getPayer(F var1);

        public void setPayer(F var1, EntityReference<Organization> var2);
    }
}

