/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.model.ibus.replace;

import com.gridnine.xtrip.common.model.EntityReference;
import com.gridnine.xtrip.common.model.booking.BaseProduct;
import com.gridnine.xtrip.common.model.booking.Fop;
import com.gridnine.xtrip.common.model.booking.IBusBookingContextKeys;
import com.gridnine.xtrip.common.model.booking.Traveller;
import com.gridnine.xtrip.common.model.profile.Person;
import com.gridnine.xtrip.common.model.replace.IBusReplaceContextKeys;
import com.gridnine.xtrip.common.model.replace.PersonWrapper;
import com.gridnine.xtrip.server.ibus.components.BaseProcessor;
import com.gridnine.xtrip.server.ibus.components.MessageContext;
import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;

public abstract class AbstractProductPersonReplaceProcessor<P extends BaseProduct, F extends Fop>
extends BaseProcessor {
    private boolean updated;

    public void process(MessageContext context) throws Exception {
        List findWhatWrappers = (List)context.getMandatoryObject((Enum)IBusReplaceContextKeys.FIND_WHAT);
        List<EntityReference<Person>> findWhat = findWhatWrappers.stream().map(PersonWrapper::getProfile).collect(Collectors.toList());
        EntityReference replaceWith = (EntityReference)context.getMandatoryObject((Enum)IBusReplaceContextKeys.REPLACE_WITH);
        BaseProduct product = (BaseProduct)context.getMandatoryObject((Enum)IBusBookingContextKeys.PRODUCT);
        Collection changedBookingFiles = (Collection)context.getMandatoryObject((Enum)IBusReplaceContextKeys.CHANGED_BOOKING_FILES);
        this.replace(this.getHandler(), product, findWhat, (EntityReference<Person>)replaceWith);
        if (this.updated && product.getReservation() != null) {
            changedBookingFiles.add(product.getReservation().getBookingFile());
        }
    }

    public abstract Handler<P, F> getHandler();

    private void replace(Handler<P, F> handler, P product, List<EntityReference<Person>> oldValues, EntityReference<Person> newValue) {
        for (EntityReference<Person> oldValue : oldValues) {
            this.replace(this.getHandler(), product, oldValue, newValue);
        }
    }

    private void replace(Handler<P, F> handler, P product, EntityReference<Person> oldValue, EntityReference<Person> newValue) {
        if (oldValue.equals(handler.getAgent(product))) {
            handler.setAgent(product, newValue);
            this.updated = true;
        }
        for (Traveller traveller : handler.getTravellers(product)) {
            if (traveller == null || !oldValue.equals((Object)traveller.getPassenger())) continue;
            traveller.setPassenger(newValue);
            this.updated = true;
        }
        this.replaceFops(handler, handler.getVendorFops(product), oldValue, newValue);
        this.replaceFops(handler, handler.getSubagentFops(product), oldValue, newValue);
        this.replaceFops(handler, handler.getClientFops(product), oldValue, newValue);
    }

    private void replaceFops(Handler<P, F> handler, List<F> fops, EntityReference<Person> oldValue, EntityReference<Person> newValue) {
        for (Fop fop : fops) {
            if (!oldValue.equals(handler.getFopAgent(fop))) continue;
            handler.setFopAgent(fop, newValue);
            this.updated = true;
        }
    }

    public static interface Handler<P, F> {
        public EntityReference<Person> getAgent(P var1);

        public void setAgent(P var1, EntityReference<Person> var2);

        public List<Traveller> getTravellers(P var1);

        public List<F> getVendorFops(P var1);

        public List<F> getSubagentFops(P var1);

        public List<F> getClientFops(P var1);

        public EntityReference<Person> getFopAgent(F var1);

        public void setFopAgent(F var1, EntityReference<Person> var2);
    }
}

