/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.model.ibus.replace;

import com.gridnine.xtrip.common.model.EntityReference;
import com.gridnine.xtrip.common.model.booking.Traveller;
import com.gridnine.xtrip.common.model.booking.air.Product;
import com.gridnine.xtrip.common.model.booking.air.ProductFop;
import com.gridnine.xtrip.common.model.helpers.AirProductHelper;
import com.gridnine.xtrip.common.model.profile.Person;
import com.gridnine.xtrip.server.model.ibus.replace.AbstractProductPersonReplaceProcessor;
import java.util.ArrayList;
import java.util.List;

public class AirProductPersonReplaceProcessor
extends AbstractProductPersonReplaceProcessor<Product, ProductFop> {
    @Override
    public AbstractProductPersonReplaceProcessor.Handler<Product, ProductFop> getHandler() {
        return new AbstractProductPersonReplaceProcessor.Handler<Product, ProductFop>(){

            @Override
            public EntityReference<Person> getAgent(Product product) {
                return product.getCashier();
            }

            @Override
            public void setAgent(Product product, EntityReference<Person> value) {
                product.setCashier(value);
            }

            @Override
            public List<Traveller> getTravellers(Product product) {
                ArrayList<Traveller> travellers = new ArrayList<Traveller>();
                if (product.getTraveller() != null) {
                    travellers.add(product.getTraveller());
                }
                return travellers;
            }

            @Override
            public List<ProductFop> getVendorFops(Product product) {
                return AirProductHelper.getVendorFops((Product)product);
            }

            @Override
            public List<ProductFop> getSubagentFops(Product product) {
                return AirProductHelper.getSubagentFops((Product)product, (boolean)false);
            }

            @Override
            public List<ProductFop> getClientFops(Product product) {
                return AirProductHelper.getClientFops((Product)product);
            }

            @Override
            public EntityReference<Person> getFopAgent(ProductFop fop) {
                return fop.getAgent();
            }

            @Override
            public void setFopAgent(ProductFop fop, EntityReference<Person> agent) {
                fop.setAgent(agent);
            }
        };
    }
}

