/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.model.ibus.replace;

import com.gridnine.xtrip.common.model.EntityContainer;
import com.gridnine.xtrip.common.model.EntityReference;
import com.gridnine.xtrip.common.model.booking.BookingFile;
import com.gridnine.xtrip.common.model.booking.IBusBookingContextKeys;
import com.gridnine.xtrip.common.model.booking.Traveller;
import com.gridnine.xtrip.common.model.profile.Person;
import com.gridnine.xtrip.common.model.replace.IBusReplaceContextKeys;
import com.gridnine.xtrip.common.model.replace.PersonWrapper;
import com.gridnine.xtrip.server.ibus.components.BaseProcessor;
import com.gridnine.xtrip.server.ibus.components.MessageContext;
import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;

public class BookingFilePersonReplaceProcessor
extends BaseProcessor {
    private boolean updated;

    public void process(MessageContext context) throws Exception {
        List findWhatWrappers = (List)context.getMandatoryObject((Enum)IBusReplaceContextKeys.FIND_WHAT);
        List<EntityReference<Person>> findWhat = findWhatWrappers.stream().map(PersonWrapper::getProfile).collect(Collectors.toList());
        EntityReference replaceWith = (EntityReference)context.getMandatoryObject((Enum)IBusReplaceContextKeys.REPLACE_WITH);
        EntityContainer bookingContainer = (EntityContainer)context.getMandatoryObject((Enum)IBusBookingContextKeys.BOOKING_FILE_CONTAINER);
        Collection changedBookingFiles = (Collection)context.getMandatoryObject((Enum)IBusReplaceContextKeys.CHANGED_BOOKING_FILES);
        BookingFile bookingFile = (BookingFile)bookingContainer.getEntity();
        this.replace(bookingFile, findWhat, (EntityReference<Person>)replaceWith);
        if (this.updated) {
            changedBookingFiles.add(bookingFile);
        }
    }

    private void replace(BookingFile bookingFile, List<EntityReference<Person>> oldValues, EntityReference<Person> newValue) {
        for (EntityReference<Person> oldValue : oldValues) {
            this.replace(bookingFile, oldValue, newValue);
        }
    }

    private void replace(BookingFile bookingFile, EntityReference<Person> oldValue, EntityReference<Person> newValue) {
        if (bookingFile.getCustomer() != null && oldValue.equals((Object)bookingFile.getCustomer().getProfile())) {
            bookingFile.getCustomer().setProfile(newValue);
            this.updated = true;
        }
        for (Traveller traveller : bookingFile.getTravellers()) {
            if (!oldValue.equals((Object)traveller.getPassenger())) continue;
            traveller.setPassenger(newValue);
            this.updated = true;
        }
    }
}

