/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.model.ibus.replace;

import com.gridnine.xtrip.common.model.EntityContainer;
import com.gridnine.xtrip.common.model.EntityReference;
import com.gridnine.xtrip.common.model.profile.Contract;
import com.gridnine.xtrip.common.model.profile.ContractCustomerInfo;
import com.gridnine.xtrip.common.model.profile.Organization;
import com.gridnine.xtrip.common.model.replace.IBusReplaceContextKeys;
import com.gridnine.xtrip.common.model.replace.OrganizationWrapper;
import com.gridnine.xtrip.server.ibus.components.BaseProcessor;
import com.gridnine.xtrip.server.ibus.components.MessageContext;
import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;

public class ContractOrganizationReplaceProcessor
extends BaseProcessor {
    private boolean updated;

    public void process(MessageContext context) throws Exception {
        List findWhatWrappers = (List)context.getMandatoryObject((Enum)IBusReplaceContextKeys.FIND_WHAT);
        List<EntityReference<Organization>> findWhat = findWhatWrappers.stream().map(OrganizationWrapper::getProfile).collect(Collectors.toList());
        EntityReference replaceWith = (EntityReference)context.getMandatoryObject((Enum)IBusReplaceContextKeys.REPLACE_WITH);
        EntityContainer contractContainer = (EntityContainer)context.getMandatoryObject((Enum)IBusReplaceContextKeys.CONTRACT_CONTAINER);
        Collection changedContracts = (Collection)context.getMandatoryObject((Enum)IBusReplaceContextKeys.CHANGED_CONTRACTS);
        Contract contract = (Contract)contractContainer.getEntity();
        this.replace(contract, findWhat, (EntityReference<Organization>)replaceWith);
        if (this.updated) {
            changedContracts.add(contract);
        }
    }

    private void replace(Contract contract, List<EntityReference<Organization>> oldValues, EntityReference<Organization> newValue) {
        oldValues.forEach(oldValue -> this.replace(contract, (EntityReference<Organization>)oldValue, newValue));
    }

    private void replace(Contract contract, EntityReference<Organization> oldValue, EntityReference<Organization> newValue) {
        if (oldValue.equals((Object)contract.getVendor())) {
            contract.setVendor(newValue);
            this.updated = true;
        }
        if (oldValue.equals((Object)contract.getSupplier())) {
            contract.setSupplier(newValue);
            this.updated = true;
        }
        if (oldValue.equals((Object)contract.getCustomer())) {
            contract.setCustomer(newValue);
            this.updated = true;
        }
        for (ContractCustomerInfo customerInfo : contract.getCustomers()) {
            if (!oldValue.equals((Object)customerInfo.getCustomer())) continue;
            customerInfo.setCustomer(newValue);
            this.updated = true;
        }
    }
}

