/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.model.ibus.replace;

import com.gridnine.xtrip.common.model.EntityIndex;
import com.gridnine.xtrip.common.model.EntityReference;
import com.gridnine.xtrip.common.model.entity.EntityStorage;
import com.gridnine.xtrip.common.model.profile.Contract;
import com.gridnine.xtrip.common.model.profile.ContractCustomerIndex;
import com.gridnine.xtrip.common.model.profile.ContractIndex;
import com.gridnine.xtrip.common.model.profile.Organization;
import com.gridnine.xtrip.common.model.replace.IBusReplaceContextKeys;
import com.gridnine.xtrip.common.model.replace.OrganizationWrapper;
import com.gridnine.xtrip.common.search.SearchCriterion;
import com.gridnine.xtrip.common.search.SearchQuery;
import com.gridnine.xtrip.server.ibus.components.BaseTargetsProvider;
import com.gridnine.xtrip.server.ibus.components.MessageContext;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public class OrganizationRelatedContractReferencesTargetsProvider
extends BaseTargetsProvider<EntityReference<Contract>> {
    public List<EntityReference<Contract>> getTargets(MessageContext context) {
        List findWhatWrappers = (List)context.getMandatoryObject((Enum)IBusReplaceContextKeys.FIND_WHAT);
        List<EntityReference<Organization>> findWhat = findWhatWrappers.stream().map(OrganizationWrapper::getProfile).collect(Collectors.toList());
        return OrganizationRelatedContractReferencesTargetsProvider.searchContractReferences(findWhat);
    }

    private static List<EntityReference<Contract>> searchContractReferences(List<EntityReference<Organization>> organizations) {
        return Stream.concat(OrganizationRelatedContractReferencesTargetsProvider.searchNewContractIndexes(organizations).stream(), OrganizationRelatedContractReferencesTargetsProvider.searchOldContractIndexes(organizations).stream()).map(EntityIndex::getSource).distinct().collect(Collectors.toList());
    }

    private static List<ContractCustomerIndex> searchOldContractIndexes(List<EntityReference<Organization>> organizations) {
        List<SearchCriterion> criterions = organizations.stream().map(organization -> SearchCriterion.or((SearchCriterion[])new SearchCriterion[]{SearchCriterion.eq((String)ContractCustomerIndex.Property.vendor.name(), (Object)organization), SearchCriterion.eq((String)ContractCustomerIndex.Property.supplier.name(), (Object)organization), SearchCriterion.eq((String)ContractCustomerIndex.Property.customer.name(), (Object)organization)})).collect(Collectors.toList());
        SearchQuery query = new SearchQuery();
        query.getCriteria().getCriterions().add(SearchCriterion.or((SearchCriterion[])criterions.toArray(new SearchCriterion[criterions.size()])));
        return EntityStorage.get().search(ContractCustomerIndex.class, query).getData();
    }

    private static List<ContractIndex> searchNewContractIndexes(List<EntityReference<Organization>> organizations) {
        List<SearchCriterion> criterions = organizations.stream().map(organization -> SearchCriterion.or((SearchCriterion[])new SearchCriterion[]{SearchCriterion.eq((String)ContractIndex.Property.vendor.name(), (Object)organization), SearchCriterion.eq((String)ContractIndex.Property.supplier.name(), (Object)organization), SearchCriterion.eq((String)ContractIndex.Property.customer.name(), (Object)organization)})).collect(Collectors.toList());
        SearchQuery query = new SearchQuery();
        query.getCriteria().getCriterions().add(SearchCriterion.or((SearchCriterion[])criterions.toArray(new SearchCriterion[criterions.size()])));
        return EntityStorage.get().search(ContractIndex.class, query).getData();
    }
}

