/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.model.ibus.replace;

import com.gridnine.xtrip.common.model.EntityReference;
import com.gridnine.xtrip.common.model.entity.EntityStorage;
import com.gridnine.xtrip.common.model.profile.Organization;
import com.gridnine.xtrip.common.model.profile.Person;
import com.gridnine.xtrip.common.model.profile.PersonIndex;
import com.gridnine.xtrip.common.model.replace.IBusReplaceContextKeys;
import com.gridnine.xtrip.common.model.replace.OrganizationWrapper;
import com.gridnine.xtrip.common.search.SearchCriterion;
import com.gridnine.xtrip.common.search.SearchQuery;
import com.gridnine.xtrip.server.ibus.components.BaseTargetsProvider;
import com.gridnine.xtrip.server.ibus.components.MessageContext;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;

public class OrganizationRelatedPersonEmploymentReferenceTargetsProvider
extends BaseTargetsProvider<EntityReference<Person>> {
    public Collection<EntityReference<Person>> getTargets(MessageContext context) throws Exception {
        List findWhatWrappers = (List)context.getMandatoryObject((Enum)IBusReplaceContextKeys.FIND_WHAT);
        List<EntityReference<Organization>> findWhat = findWhatWrappers.stream().map(OrganizationWrapper::getProfile).collect(Collectors.toList());
        return OrganizationRelatedPersonEmploymentReferenceTargetsProvider.searchPersonEmploymentReferences(findWhat);
    }

    private static List<EntityReference<Person>> searchPersonEmploymentReferences(List<EntityReference<Organization>> organizations) {
        ArrayList<EntityReference<Person>> personEmploymentReferences = new ArrayList<EntityReference<Person>>();
        List<PersonIndex> personIndices = OrganizationRelatedPersonEmploymentReferenceTargetsProvider.searchPersonEmploymentCustomerIndexes(organizations);
        for (PersonIndex personIndex : personIndices) {
            EntityReference personReference = personIndex.getSource();
            if (personEmploymentReferences.contains(personReference)) continue;
            personEmploymentReferences.add((EntityReference<Person>)personReference);
        }
        return personEmploymentReferences;
    }

    private static List<PersonIndex> searchPersonEmploymentCustomerIndexes(List<EntityReference<Organization>> organizations) {
        SearchCriterion[] criterions = (SearchCriterion[])organizations.stream().map(organization -> SearchCriterion.or((SearchCriterion[])new SearchCriterion[]{SearchCriterion.contains((String)PersonIndex.Property.employmentsUids.name(), (Object)organization.getUid())})).toArray(SearchCriterion[]::new);
        SearchQuery query = new SearchQuery();
        query.getCriteria().getCriterions().add(SearchCriterion.or((SearchCriterion[])criterions));
        return EntityStorage.get().search(PersonIndex.class, query).getData();
    }
}

