/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.model.ibus.replace;

import com.gridnine.xtrip.common.model.EntityReference;
import com.gridnine.xtrip.common.model.entity.EntityStorage;
import com.gridnine.xtrip.common.model.profile.Organization;
import com.gridnine.xtrip.common.model.profile.TripartiteContract;
import com.gridnine.xtrip.common.model.profile.TripartiteContractIndex;
import com.gridnine.xtrip.common.model.replace.IBusReplaceContextKeys;
import com.gridnine.xtrip.common.model.replace.OrganizationWrapper;
import com.gridnine.xtrip.common.search.SearchCriterion;
import com.gridnine.xtrip.common.search.SearchQuery;
import com.gridnine.xtrip.server.ibus.components.BaseTargetsProvider;
import com.gridnine.xtrip.server.ibus.components.MessageContext;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;

public class OrganizationRelatedTripartiteContractReferencesTargetsProvider
extends BaseTargetsProvider<EntityReference<TripartiteContract>> {
    public Collection<EntityReference<TripartiteContract>> getTargets(MessageContext context) {
        List findWhatWrappers = (List)context.getMandatoryObject((Enum)IBusReplaceContextKeys.FIND_WHAT);
        List<EntityReference<Organization>> findWhat = findWhatWrappers.stream().map(OrganizationWrapper::getProfile).collect(Collectors.toList());
        return OrganizationRelatedTripartiteContractReferencesTargetsProvider.searchTripartiteContractReferences(findWhat);
    }

    private static List<EntityReference<TripartiteContract>> searchTripartiteContractReferences(List<EntityReference<Organization>> organizations) {
        ArrayList<EntityReference<TripartiteContract>> contractReferences = new ArrayList<EntityReference<TripartiteContract>>();
        List<TripartiteContractIndex> tripartiteContractIndices = OrganizationRelatedTripartiteContractReferencesTargetsProvider.searchTripartiteContractCustomerIndexes(organizations);
        for (TripartiteContractIndex tripartiteContractIndex : tripartiteContractIndices) {
            EntityReference contractReference = tripartiteContractIndex.getSource();
            if (contractReferences.contains(contractReference)) continue;
            contractReferences.add((EntityReference<TripartiteContract>)contractReference);
        }
        return contractReferences;
    }

    private static List<TripartiteContractIndex> searchTripartiteContractCustomerIndexes(List<EntityReference<Organization>> organizations) {
        SearchCriterion[] criterions = (SearchCriterion[])organizations.stream().map(organization -> SearchCriterion.or((SearchCriterion[])new SearchCriterion[]{SearchCriterion.eq((String)TripartiteContractIndex.Property.agency.name(), (Object)organization), SearchCriterion.contains((String)TripartiteContractIndex.Property.customerUids.name(), (Object)organization.getUid())})).toArray(SearchCriterion[]::new);
        SearchQuery query = new SearchQuery();
        query.getCriteria().getCriterions().add(SearchCriterion.or((SearchCriterion[])criterions));
        return EntityStorage.get().search(TripartiteContractIndex.class, query).getData();
    }
}

