/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.model.ibus.replace;

import com.gridnine.xtrip.common.model.EntityContainer;
import com.gridnine.xtrip.common.model.EntityReference;
import com.gridnine.xtrip.common.model.profile.Organization;
import com.gridnine.xtrip.common.model.profile.Person;
import com.gridnine.xtrip.common.model.replace.IBusReplaceContextKeys;
import com.gridnine.xtrip.common.model.replace.OrganizationWrapper;
import com.gridnine.xtrip.server.ibus.components.BaseProcessor;
import com.gridnine.xtrip.server.ibus.components.MessageContext;
import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;

public class PersonEmploymentOrganizationReplaceProcessor
extends BaseProcessor {
    private boolean updated;

    public void process(MessageContext context) throws Exception {
        List findWhatWrappers = (List)context.getMandatoryObject((Enum)IBusReplaceContextKeys.FIND_WHAT);
        List<EntityReference<Organization>> findWhat = findWhatWrappers.stream().map(OrganizationWrapper::getProfile).collect(Collectors.toList());
        EntityReference replaceWith = (EntityReference)context.getMandatoryObject((Enum)IBusReplaceContextKeys.REPLACE_WITH);
        EntityContainer personEntityContainer = (EntityContainer)context.getMandatoryObject((Enum)IBusReplaceContextKeys.PERSON_EMPLOYMENT_CONTAINER);
        Collection changedContracts = (Collection)context.getMandatoryObject((Enum)IBusReplaceContextKeys.CHANGED_PERSON_EMPLOYMENT);
        Person person = (Person)personEntityContainer.getEntity();
        this.replace(person, findWhat, (EntityReference<Organization>)replaceWith);
        if (this.updated) {
            changedContracts.add(person);
        }
    }

    private void replace(Person person, List<EntityReference<Organization>> oldValues, EntityReference<Organization> newValue) {
        for (EntityReference<Organization> oldValue : oldValues) {
            this.replace(person, oldValue, newValue);
        }
    }

    private void replace(Person person, EntityReference<Organization> oldValue, EntityReference<Organization> newValue) {
        person.getEmployments().forEach(personEmployment -> {
            if (oldValue.equals((Object)personEmployment.getOrganization())) {
                personEmployment.setOrganization(newValue);
                this.updated = true;
            }
        });
    }
}

