/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.model.ibus.replace;

import com.gridnine.xtrip.common.model.EntityReference;
import com.gridnine.xtrip.common.model.booking.BookingFile;
import com.gridnine.xtrip.common.model.booking.CommonProductFopIndex;
import com.gridnine.xtrip.common.model.booking.CommonProductIndex;
import com.gridnine.xtrip.common.model.entity.EntityStorage;
import com.gridnine.xtrip.common.model.profile.Person;
import com.gridnine.xtrip.common.model.replace.IBusReplaceContextKeys;
import com.gridnine.xtrip.common.model.replace.PersonWrapper;
import com.gridnine.xtrip.common.search.SearchCriterion;
import com.gridnine.xtrip.common.search.SearchQuery;
import com.gridnine.xtrip.server.ibus.components.BaseTargetsProvider;
import com.gridnine.xtrip.server.ibus.components.MessageContext;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;

public class PersonRelatedBookingFileReferencesTargetsProvider
extends BaseTargetsProvider<EntityReference<BookingFile>> {
    public Collection<EntityReference<BookingFile>> getTargets(MessageContext context) throws Exception {
        List findWhatWrappers = (List)context.getMandatoryObject((Enum)IBusReplaceContextKeys.FIND_WHAT);
        List<EntityReference<Person>> findWhat = findWhatWrappers.stream().map(PersonWrapper::getProfile).collect(Collectors.toList());
        return PersonRelatedBookingFileReferencesTargetsProvider.searchBookingFileReferences(findWhat);
    }

    private static List<EntityReference<BookingFile>> searchBookingFileReferences(List<EntityReference<Person>> persons) {
        ArrayList<EntityReference<BookingFile>> bookingFileReferences = new ArrayList<EntityReference<BookingFile>>();
        List<CommonProductIndex> commonProductIndexes = PersonRelatedBookingFileReferencesTargetsProvider.searchCommonProductIndexes(persons);
        for (CommonProductIndex commonProductIndex : commonProductIndexes) {
            EntityReference bookingFileReference = commonProductIndex.getSource();
            if (bookingFileReferences.contains(bookingFileReference)) continue;
            bookingFileReferences.add((EntityReference<BookingFile>)bookingFileReference);
        }
        List<CommonProductFopIndex> commonProductFopIndexes = PersonRelatedBookingFileReferencesTargetsProvider.searchCommonProductFopIndexes(persons);
        for (CommonProductFopIndex commonProductFopIndex : commonProductFopIndexes) {
            EntityReference bookingFileReference = commonProductFopIndex.getSource();
            if (bookingFileReferences.contains(bookingFileReference)) continue;
            bookingFileReferences.add((EntityReference<BookingFile>)bookingFileReference);
        }
        return bookingFileReferences;
    }

    private static List<CommonProductIndex> searchCommonProductIndexes(List<EntityReference<Person>> persons) {
        List<SearchCriterion> criterions = persons.stream().map(organization -> SearchCriterion.or((SearchCriterion[])new SearchCriterion[]{SearchCriterion.eq((String)CommonProductIndex.Property.agent.name(), (Object)organization), SearchCriterion.eq((String)CommonProductIndex.Property.sellAgent.name(), (Object)organization), SearchCriterion.eq((String)CommonProductIndex.Property.clientFopAgent.name(), (Object)organization), SearchCriterion.contains((String)CommonProductIndex.Property.passengers.name(), (Object)organization)})).collect(Collectors.toList());
        SearchQuery query = new SearchQuery();
        query.getCriteria().getCriterions().add(SearchCriterion.or((SearchCriterion[])criterions.toArray(new SearchCriterion[criterions.size()])));
        return EntityStorage.get().search(CommonProductIndex.class, query).getData();
    }

    private static List<CommonProductFopIndex> searchCommonProductFopIndexes(List<EntityReference<Person>> persons) {
        List<SearchCriterion> criterions = persons.stream().map(organization -> SearchCriterion.or((SearchCriterion[])new SearchCriterion[]{SearchCriterion.eq((String)CommonProductFopIndex.Property.agent.name(), (Object)organization), SearchCriterion.eq((String)CommonProductFopIndex.Property.fopAgent.name(), (Object)organization)})).collect(Collectors.toList());
        SearchQuery query = new SearchQuery();
        query.getCriteria().getCriterions().add(SearchCriterion.or((SearchCriterion[])criterions.toArray(new SearchCriterion[criterions.size()])));
        return EntityStorage.get().search(CommonProductFopIndex.class, query).getData();
    }
}

