/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.model.ibus.replace;

import com.gridnine.xtrip.common.model.EntityReference;
import com.gridnine.xtrip.common.model.booking.BookingFile;
import com.gridnine.xtrip.common.model.booking.IBusBookingContextKeys;
import com.gridnine.xtrip.common.model.booking.Reservation;
import com.gridnine.xtrip.common.model.profile.Organization;
import com.gridnine.xtrip.common.model.replace.IBusReplaceContextKeys;
import com.gridnine.xtrip.common.model.replace.OrganizationWrapper;
import com.gridnine.xtrip.server.ibus.components.BaseProcessor;
import com.gridnine.xtrip.server.ibus.components.MessageContext;
import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;

public class ReservationOrganizationReplaceProcessor
extends BaseProcessor {
    private boolean updated;

    public void process(MessageContext context) throws Exception {
        List findWhatWrappers = (List)context.getMandatoryObject((Enum)IBusReplaceContextKeys.FIND_WHAT);
        List<EntityReference<Organization>> findWhat = findWhatWrappers.stream().map(OrganizationWrapper::getProfile).collect(Collectors.toList());
        EntityReference replaceWith = (EntityReference)context.getMandatoryObject((Enum)IBusReplaceContextKeys.REPLACE_WITH);
        Reservation reservation = (Reservation)context.getMandatoryObject((Enum)IBusBookingContextKeys.RESERVATION);
        Collection changedBookingFiles = (Collection)context.getMandatoryObject((Enum)IBusReplaceContextKeys.CHANGED_BOOKING_FILES);
        this.replace(reservation, findWhat, (EntityReference<Organization>)replaceWith, changedBookingFiles);
    }

    private void replace(Reservation reservation, List<EntityReference<Organization>> oldValues, EntityReference<Organization> newValue, Collection<BookingFile> changedBookingFiles) {
        for (EntityReference<Organization> oldValue : oldValues) {
            this.replace(reservation, oldValue, newValue);
        }
        if (this.updated) {
            changedBookingFiles.add(reservation.getBookingFile());
        }
    }

    private void replace(Reservation reservation, EntityReference<Organization> oldValue, EntityReference<Organization> newValue) {
        if (oldValue.equals((Object)reservation.getSubagency())) {
            reservation.setSubagency(newValue);
            this.updated = true;
        }
    }
}

