/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.model.ibus.replace;

import com.gridnine.xtrip.common.model.EntityReference;
import com.gridnine.xtrip.common.model.booking.IBusBookingContextKeys;
import com.gridnine.xtrip.common.model.booking.Reservation;
import com.gridnine.xtrip.common.model.profile.Person;
import com.gridnine.xtrip.common.model.replace.IBusReplaceContextKeys;
import com.gridnine.xtrip.common.model.replace.PersonWrapper;
import com.gridnine.xtrip.server.ibus.components.BaseProcessor;
import com.gridnine.xtrip.server.ibus.components.MessageContext;
import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;

public class ReservationPersonReplaceProcessor
extends BaseProcessor {
    private boolean updated;

    public void process(MessageContext context) throws Exception {
        List findWhatWrappers = (List)context.getMandatoryObject((Enum)IBusReplaceContextKeys.FIND_WHAT);
        List<EntityReference<Person>> findWhat = findWhatWrappers.stream().map(PersonWrapper::getProfile).collect(Collectors.toList());
        EntityReference replaceWith = (EntityReference)context.getMandatoryObject((Enum)IBusReplaceContextKeys.REPLACE_WITH);
        Reservation reservation = (Reservation)context.getMandatoryObject((Enum)IBusBookingContextKeys.RESERVATION);
        Collection changedBookingFiles = (Collection)context.getMandatoryObject((Enum)IBusReplaceContextKeys.CHANGED_BOOKING_FILES);
        this.replace(reservation, findWhat, (EntityReference<Person>)replaceWith);
        if (this.updated) {
            changedBookingFiles.add(reservation.getBookingFile());
        }
    }

    private void replace(Reservation reservation, List<EntityReference<Person>> oldValues, EntityReference<Person> newValue) {
        for (EntityReference<Person> oldValue : oldValues) {
            this.replace(reservation, oldValue, newValue);
        }
    }

    private void replace(Reservation reservation, EntityReference<Person> oldValue, EntityReference<Person> newValue) {
        if (oldValue.equals((Object)reservation.getBookingAgent())) {
            reservation.setBookingAgent(newValue);
            this.updated = true;
        }
    }
}

