/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.model.ibus.replace;

import com.gridnine.xtrip.common.model.EntityContainer;
import com.gridnine.xtrip.common.model.EntityReference;
import com.gridnine.xtrip.common.model.profile.Organization;
import com.gridnine.xtrip.common.model.profile.TripartiteContract;
import com.gridnine.xtrip.common.model.profile.TripartiteContractCustomerInfo;
import com.gridnine.xtrip.common.model.replace.IBusReplaceContextKeys;
import com.gridnine.xtrip.common.model.replace.OrganizationWrapper;
import com.gridnine.xtrip.server.ibus.components.BaseProcessor;
import com.gridnine.xtrip.server.ibus.components.MessageContext;
import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;

public class TripartiteContractOrganizationReplaceProcessor
extends BaseProcessor {
    private boolean updated;

    public void process(MessageContext context) throws Exception {
        List findWhatWrappers = (List)context.getMandatoryObject((Enum)IBusReplaceContextKeys.FIND_WHAT);
        List<EntityReference<Organization>> findWhat = findWhatWrappers.stream().map(OrganizationWrapper::getProfile).collect(Collectors.toList());
        EntityReference replaceWith = (EntityReference)context.getMandatoryObject((Enum)IBusReplaceContextKeys.REPLACE_WITH);
        EntityContainer tripartiteContractContainer = (EntityContainer)context.getMandatoryObject((Enum)IBusReplaceContextKeys.TRIPARTITE_CONTRACT_CONTAINER);
        Collection changedContracts = (Collection)context.getMandatoryObject((Enum)IBusReplaceContextKeys.CHANGED_TRIPARTITE_CONTRACTS);
        TripartiteContract tripartiteContract = (TripartiteContract)tripartiteContractContainer.getEntity();
        this.replace(tripartiteContract, findWhat, (EntityReference<Organization>)replaceWith);
        if (this.updated) {
            changedContracts.add(tripartiteContract);
        }
    }

    private void replace(TripartiteContract tripartiteContract, List<EntityReference<Organization>> oldValues, EntityReference<Organization> newValue) {
        for (EntityReference<Organization> oldValue : oldValues) {
            this.replace(tripartiteContract, oldValue, newValue);
        }
    }

    private void replace(TripartiteContract tripartiteContract, EntityReference<Organization> oldValue, EntityReference<Organization> newValue) {
        if (oldValue.equals((Object)tripartiteContract.getAgency())) {
            tripartiteContract.setAgency(newValue);
            this.updated = true;
        }
        for (TripartiteContractCustomerInfo tripartiteCustomers : tripartiteContract.getCustomers()) {
            if (!oldValue.equals((Object)tripartiteCustomers.getCustomer())) continue;
            tripartiteCustomers.setCustomer(newValue);
            this.updated = true;
        }
    }
}

