/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.model.ibus.replace;

import com.gridnine.xtrip.common.model.EntityReference;
import com.gridnine.xtrip.common.model.helpers.MessageHelper;
import com.gridnine.xtrip.common.model.l10n.Messages;
import com.gridnine.xtrip.common.model.replace.IBusReplaceContextKeys;
import com.gridnine.xtrip.common.model.replace.PersonWrapper;
import com.gridnine.xtrip.common.model.system.MessageType;
import com.gridnine.xtrip.server.ibus.components.BaseProcessor;
import com.gridnine.xtrip.server.ibus.components.MessageContext;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.stream.Collectors;

public class ValidatePersonReplaceProcessor
extends BaseProcessor {
    public void process(MessageContext context) throws Exception {
        EntityReference replaceWith;
        List findWhatWrappers = (List)context.getMandatoryObject((Enum)IBusReplaceContextKeys.FIND_WHAT);
        List findWhat = findWhatWrappers.stream().map(PersonWrapper::getProfile).collect(Collectors.toList());
        if (findWhat == null || findWhat.size() == 0) {
            context.addMessage(MessageHelper.createErrorMessage((String)Messages.ParameterFindWhat_IsNotDefined, (Object[])new Object[0]));
        }
        if ((replaceWith = (EntityReference)context.getObject((Enum)IBusReplaceContextKeys.REPLACE_WITH)) == null) {
            context.addMessage(MessageHelper.createErrorMessage((String)Messages.ParameterReplaceWith_IsNotDefined, (Object[])new Object[0]));
        }
        if (findWhat.contains(replaceWith)) {
            if (findWhat.size() > 1) {
                ArrayList newFindWhat = new ArrayList(new HashSet(findWhat));
                newFindWhat.remove(replaceWith);
                if (newFindWhat.size() > 0) {
                    findWhatWrappers.removeIf(wrapper -> wrapper.getProfile().equals((Object)replaceWith));
                    context.addMessage(MessageHelper.createMessage((String)Messages.RemovedParameterReplaceWithFromFindWhat, (Object[])new Object[0]));
                } else {
                    context.addMessage(MessageHelper.createErrorMessage((String)Messages.ParametersFindWhatAndReplaceWith_AreEqual, (Object[])new Object[0]));
                }
            } else {
                context.addMessage(MessageHelper.createErrorMessage((String)Messages.ParametersFindWhatAndReplaceWith_AreEqual, (Object[])new Object[0]));
            }
        }
        if (MessageHelper.hasMessages((Collection)context.getMessagesReadOnly(), (MessageType)MessageType.ERROR)) {
            throw new Exception("Validation failed");
        }
    }
}

