/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.model.ibus.replacedetails;

import com.gridnine.xtrip.common.model.EntityContainer;
import com.gridnine.xtrip.common.model.EntityReference;
import com.gridnine.xtrip.common.model.Xeption;
import com.gridnine.xtrip.common.model.dict.DictionaryReference;
import com.gridnine.xtrip.common.model.profile.BeneficiaryCode;
import com.gridnine.xtrip.common.model.profile.EmployeeCategory;
import com.gridnine.xtrip.common.model.profile.IbusReplaceDetailsContextKey;
import com.gridnine.xtrip.common.model.profile.Organization;
import com.gridnine.xtrip.common.model.profile.OrganizationReplaceDetailsType;
import com.gridnine.xtrip.common.model.profile.SabreProfileCommand2Osi;
import com.gridnine.xtrip.common.model.profile.SabreProfileCommand4SSR;
import com.gridnine.xtrip.common.model.system.Metadata;
import com.gridnine.xtrip.common.model.system.MetadataKey;
import com.gridnine.xtrip.common.model.system.MetadataKeyDescriptorReference;
import com.gridnine.xtrip.server.ibus.components.BaseProcessor;
import com.gridnine.xtrip.server.ibus.components.MessageContext;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import org.apache.commons.lang.ObjectUtils;

public class OrganizationReplaceValueProcessor
extends BaseProcessor {
    public void process(MessageContext ctx) throws Exception {
        EntityContainer organizationContainer = (EntityContainer)ctx.getMandatoryObject((Enum)IbusReplaceDetailsContextKey.ORGANIZATION_CONTAINER);
        Map.Entry value = (Map.Entry)ctx.getMandatoryObject((Enum)IbusReplaceDetailsContextKey.VALUE);
        this.replaceValue((Organization)organizationContainer.getEntity(), (OrganizationReplaceDetailsType)value.getKey(), value.getValue());
    }

    private void replaceValue(Organization organization, OrganizationReplaceDetailsType type, Object value) {
        switch (type) {
            case HOLDING: {
                EntityReference holding = (EntityReference)value;
                organization.setHolding(holding);
                break;
            }
            case PROFILE_GROUP: {
                Collection profileGroups = (Collection)value;
                MetadataKeyDescriptorReference key = new MetadataKeyDescriptorReference(MetadataKey.KEY_ORGANIZATION_PROFILE_GROUP.name());
                List metadataList = profileGroups.stream().filter(Objects::nonNull).distinct().map(ref -> {
                    Metadata metadata = new Metadata();
                    metadata.setKey((DictionaryReference)key);
                    metadata.setValue(ref);
                    return metadata;
                }).collect(Collectors.toList());
                for (Metadata oldMetadata : organization.getMetadata()) {
                    metadataList.removeIf(newMetadata -> ObjectUtils.equals((Object)newMetadata.getValue(), (Object)oldMetadata.getValue()));
                }
                organization.getMetadata().addAll(metadataList);
                break;
            }
            case EMPLOYEE_CATEGORIES: {
                Collection employeeCategories = (Collection)value;
                for (EmployeeCategory oldCategory : organization.getEmployeeCategories()) {
                    employeeCategories.removeIf(newCategory -> newCategory.getName().equals((Object)oldCategory.getName()));
                }
                organization.getEmployeeCategories().addAll(employeeCategories);
                break;
            }
            case OSI: {
                Collection osiLines = (Collection)value;
                for (SabreProfileCommand2Osi oldOsi : organization.getSabreAdditionalCommand2Lines()) {
                    osiLines.removeIf(newOsi -> newOsi.getLineType() == oldOsi.getLineType() && ObjectUtils.equals((Object)newOsi.getEntry1(), (Object)oldOsi.getEntry1()) && ObjectUtils.equals((Object)newOsi.getEntry2(), (Object)oldOsi.getEntry2()));
                }
                organization.getSabreAdditionalCommand2Lines().addAll(osiLines);
                break;
            }
            case SSR: {
                Collection ssrLines = (Collection)value;
                for (SabreProfileCommand4SSR oldSsr : organization.getSabreAdditionalCommand4Lines()) {
                    ssrLines.removeIf(newSsr -> newSsr.getLineType() == oldSsr.getLineType() && ObjectUtils.equals((Object)newSsr.getSsrCode(), (Object)oldSsr.getSsrCode()) && ObjectUtils.equals((Object)newSsr.getSsrInfo(), (Object)oldSsr.getSsrInfo()));
                }
                organization.getSabreAdditionalCommand4Lines().addAll(ssrLines);
                break;
            }
            case BENEFICIARY_CODE: {
                BeneficiaryCode beneficiaryCode = (BeneficiaryCode)value;
                organization.setBeneficiaryCode(beneficiaryCode);
                break;
            }
            default: {
                throw Xeption.forDeveloper((String)("unsupported type: " + type), (Object[])new Object[0]);
            }
        }
    }
}

