/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.model.ibus.replacedetails;

import com.gridnine.xtrip.common.model.EntityReference;
import com.gridnine.xtrip.common.model.Xeption;
import com.gridnine.xtrip.common.model.booking.BaseProduct;
import com.gridnine.xtrip.common.model.booking.BookingFile;
import com.gridnine.xtrip.common.model.booking.GeneralProductContractRelationData;
import com.gridnine.xtrip.common.model.booking.ProductReplaceDetailsType;
import com.gridnine.xtrip.common.model.booking.TchCreditCardAccompanyingDocumentType;
import com.gridnine.xtrip.common.model.booking.TicketType;
import com.gridnine.xtrip.common.model.booking.air.Product;
import com.gridnine.xtrip.common.model.booking.xtriphotels.HotelProduct;
import com.gridnine.xtrip.common.model.dict.ContractType;
import com.gridnine.xtrip.common.model.dict.DictionaryReference;
import com.gridnine.xtrip.common.model.dict.Hotel;
import com.gridnine.xtrip.common.model.dict.HotelTariffType;
import com.gridnine.xtrip.common.model.dict.MCOCategory;
import com.gridnine.xtrip.common.model.dict.TariffType;
import com.gridnine.xtrip.common.model.handlers.ProductHandler;
import com.gridnine.xtrip.common.model.helpers.AirProductHelper;
import com.gridnine.xtrip.common.model.helpers.GeneralProductHelper;
import com.gridnine.xtrip.common.model.profile.IbusReplaceDetailsContextKey;
import com.gridnine.xtrip.common.model.system.PaymentType;
import com.gridnine.xtrip.common.util.MiscUtil;
import com.gridnine.xtrip.server.ibus.components.BaseProcessor;
import com.gridnine.xtrip.server.ibus.components.MessageContext;
import java.time.LocalDateTime;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Objects;

public class ProductReplaceValueProcessor
extends BaseProcessor {
    public void process(MessageContext ctx) throws Exception {
        BaseProduct product = (BaseProduct)ctx.getMandatoryObject((Enum)IbusReplaceDetailsContextKey.PRODUCT);
        Map.Entry value = (Map.Entry)ctx.getMandatoryObject((Enum)IbusReplaceDetailsContextKey.VALUE);
        this.replaceValue(ctx, product, (ProductReplaceDetailsType)value.getKey(), value.getValue());
    }

    private void replaceValue(MessageContext ctx, BaseProduct product, ProductReplaceDetailsType type, Object value) throws Exception {
        ProductHandler handler = GeneralProductHelper.getHandler((BaseProduct)product);
        switch (type) {
            case AGENT: {
                EntityReference agent = (EntityReference)value;
                handler.setAgent(product, agent);
                break;
            }
            case BOOKING_AGENCY: {
                BookingFile bookingFile = this.getBookingFile(product);
                EntityReference agency = (EntityReference)value;
                bookingFile.setAgency(agency);
                break;
            }
            case AGENCY: {
                EntityReference agency = (EntityReference)value;
                handler.setAgency(product, agency);
                break;
            }
            case VALIDATOR: {
                String validatorCode = (String)value;
                handler.setValidatorCode(product, validatorCode);
                break;
            }
            case BLANK_OWNER: {
                EntityReference blankOwner = (EntityReference)value;
                handler.setBlankOwner(product, blankOwner);
                break;
            }
            case BLANK_TYPE: {
                DictionaryReference blankType = (DictionaryReference)value;
                handler.setBlankType(product, blankType);
                break;
            }
            case ISSUE_DATE: {
                Date issueDate = MiscUtil.toDate((LocalDateTime)((LocalDateTime)value));
                handler.setIssueDate(product, issueDate);
                break;
            }
            case TCH_ACCOMPAYING_DOCUMENT_TYPE: {
                TchCreditCardAccompanyingDocumentType documentType = (TchCreditCardAccompanyingDocumentType)value;
                AirProductHelper.getVendorFops((Product)((Product)product)).stream().filter(fop -> fop.getType() == PaymentType.CREDIT_CARD || fop.getType() == PaymentType.CREDIT_CARD_TCH).forEach(fop -> fop.setTchCCAccompanyingDocumentType(documentType));
                break;
            }
            case COMPLETED: {
                boolean completed = (Boolean)value;
                handler.setCompleted(product, completed);
                break;
            }
            case MCO_CATEGORY: {
                MCOCategory category = (MCOCategory)value;
                ((Product)product).setMcoCategory(category);
                break;
            }
            case CLIENT: {
                BookingFile bookingFile = this.getBookingFile(product);
                EntityReference client = (EntityReference)value;
                bookingFile.setCustomerProfile(client);
                break;
            }
            case PAYER: {
                EntityReference payer = (EntityReference)value;
                List relations = GeneralProductHelper.copyContractRelations((BaseProduct)product);
                GeneralProductContractRelationData relation = (GeneralProductContractRelationData)GeneralProductHelper.findContractRelation((List)relations, (ContractType)ContractType.CLIENT);
                if (relation == null) break;
                relation.getFops().forEach(fop -> fop.setPayer(payer));
                GeneralProductHelper.getHandler((BaseProduct)product).updateContractRelations(product, relations);
                break;
            }
            case BRANCH: {
                EntityReference branch = (EntityReference)value;
                handler.setBranch(product, branch);
                break;
            }
            case SUPPLIER: {
                EntityReference supplier = (EntityReference)value;
                handler.setSupplier(product, supplier);
                break;
            }
            case CHECKED: {
                boolean checked = (Boolean)value;
                handler.setChecked(product, checked);
                break;
            }
            case SUBAGENCY: {
                EntityReference subagency = (EntityReference)value;
                handler.setSubagency(product, subagency);
                break;
            }
            case SUBSIDIZED_TARIFF: {
                boolean subsidizedTariff = (Boolean)value;
                ((Product)product).setSubsidizedTariff(subsidizedTariff);
                break;
            }
            case TARIFF_TYPE_AIR: {
                TariffType tariffType = (TariffType)value;
                ((Product)product).setTariffType(tariffType);
                break;
            }
            case TARIFF_TYPE_HOTEL: {
                HotelTariffType tariffType = (HotelTariffType)value;
                ((HotelProduct)product).setTariffType(tariffType);
                break;
            }
            case TICKET_TYPE: {
                TicketType ticketType = (TicketType)value;
                handler.setTicketType(product, ticketType);
                break;
            }
            case SALES_POINT: {
                EntityReference salesPoint = (EntityReference)value;
                handler.setSalesPoint(product, salesPoint);
                break;
            }
            case VENDOR_FOP: {
                PaymentType paymentType = (PaymentType)value;
                handler.changeFopsPaymentTypes(product, paymentType, ContractType.VENDOR, false);
                break;
            }
            case SUBAGENT_FOP: {
                PaymentType paymentType = (PaymentType)value;
                handler.changeFopsPaymentTypes(product, paymentType, ContractType.SUBAGENCY, false);
                break;
            }
            case CLIENT_FOP: {
                PaymentType paymentType = (PaymentType)value;
                handler.changeFopsPaymentTypes(product, paymentType, ContractType.CLIENT, false);
                break;
            }
            case CLIENT_FEE_FOP: {
                PaymentType paymentType = (PaymentType)value;
                handler.changeFopsPaymentTypes(product, paymentType, ContractType.CLIENT, true);
                break;
            }
            case COMMENTS: {
                String comments = (String)value;
                handler.setComments(product, comments);
                break;
            }
            case CLIENT_CONTRACT: {
                EntityReference contract = (EntityReference)value;
                List relations = GeneralProductHelper.copyContractRelations((BaseProduct)product);
                GeneralProductContractRelationData relation = (GeneralProductContractRelationData)GeneralProductHelper.findContractRelation((List)relations, (ContractType)ContractType.CLIENT);
                if (contract == null || relation == null || contract.equals((Object)relation.getGeneralData().getContractData().getManualContract())) break;
                relation.getGeneralData().getContractData().setManualContract(contract);
                GeneralProductHelper.getHandler((BaseProduct)product).updateContractRelations(product, relations);
                ctx.putObject((Enum)IbusReplaceDetailsContextKey.UPDATE_CONTRACT_RULES, (Object)true);
                break;
            }
            case HOTEL: {
                Hotel hotel = (Hotel)value;
                if (!(product instanceof HotelProduct)) break;
                HotelProduct hotelProduct = (HotelProduct)product;
                hotelProduct.setHotelName(hotel.getName());
                hotelProduct.setHotelPropertyId(hotel.getCode() == null ? null : hotel.getCode());
                hotelProduct.setHotelCountry(hotel.getCountry());
                hotelProduct.setHotelLocation(hotel.getCity());
                hotelProduct.setHotelChainCode(hotel.getBrand() == null ? null : hotel.getBrand().toString());
                hotelProduct.setHotelAddress(hotel.getAddress() == null ? null : hotel.getAddress().toString());
                hotelProduct.setHotelPhone(hotel.getPhone());
                hotelProduct.setHotelFax(hotel.getFax());
                hotelProduct.setHotelStars(hotel.getStars());
                break;
            }
            case VENDOR_FOP_AGENT: {
                EntityReference agent = (EntityReference)value;
                handler.changeFopsAgent(product, agent, ContractType.VENDOR);
                break;
            }
            case SUBAGENCY_FOP_AGENT: {
                EntityReference agent = (EntityReference)value;
                handler.changeFopsAgent(product, agent, ContractType.SUBAGENCY);
                break;
            }
            case CLIENT_FOP_AGENT: {
                EntityReference agent = (EntityReference)value;
                handler.changeFopsAgent(product, agent, ContractType.CLIENT);
                break;
            }
            case CLIENT_SHIPMENTS_DATE: {
                Date date = MiscUtil.toDate((LocalDateTime)((LocalDateTime)value));
                handler.setClientShipmentsDate(product, date);
                break;
            }
            case SUBAGENT_SHIPMENTS_DATE: {
                Date date = MiscUtil.toDate((LocalDateTime)((LocalDateTime)value));
                handler.setSubagentShipmentsDate(product, date);
                break;
            }
            default: {
                throw Xeption.forDeveloper((String)("unsupported type: " + type), (Object[])new Object[0]);
            }
        }
    }

    private BookingFile getBookingFile(BaseProduct product) {
        Objects.requireNonNull(product.getReservation(), "reservation not found in product");
        Objects.requireNonNull(product.getReservation().getBookingFile(), "booking file not found in product");
        return product.getReservation().getBookingFile();
    }
}

