/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.model.index;

import com.gridnine.xtrip.common.model.EntityContainer;
import com.gridnine.xtrip.common.model.EntityReference;
import com.gridnine.xtrip.common.model.booking.BaseProduct;
import com.gridnine.xtrip.common.model.booking.BookingFile;
import com.gridnine.xtrip.common.model.booking.CommonProductFopIndex;
import com.gridnine.xtrip.common.model.booking.CommonProductFopIndexData;
import com.gridnine.xtrip.common.model.booking.FopType;
import com.gridnine.xtrip.common.model.booking.GeneralProductFop;
import com.gridnine.xtrip.common.model.booking.ProductStatus;
import com.gridnine.xtrip.common.model.booking.Reservation;
import com.gridnine.xtrip.common.model.booking.Traveller;
import com.gridnine.xtrip.common.model.booking.additionalservice.AdditionalServiceProduct;
import com.gridnine.xtrip.common.model.booking.commission.ProductType;
import com.gridnine.xtrip.common.model.dict.ContractType;
import com.gridnine.xtrip.common.model.dict.PreferenceKey;
import com.gridnine.xtrip.common.model.entity.EntityStorage;
import com.gridnine.xtrip.common.model.handlers.ProductStatusHandler;
import com.gridnine.xtrip.common.model.helpers.AdditionalServiceProductHelper;
import com.gridnine.xtrip.common.model.helpers.DictHelper;
import com.gridnine.xtrip.common.model.helpers.GeneralProductHelper;
import com.gridnine.xtrip.common.model.profile.Card;
import com.gridnine.xtrip.common.model.profile.Organization;
import com.gridnine.xtrip.common.model.system.CardVendor;
import com.gridnine.xtrip.common.util.CompositeNumber;
import com.gridnine.xtrip.common.util.TextUtil;
import com.gridnine.xtrip.server.db.storage.model.BaseIndexData;
import com.gridnine.xtrip.server.db.storage.model.DataAggregator;
import com.gridnine.xtrip.server.db.storage.model.IndexHandler;
import com.gridnine.xtrip.server.model.helpers.IndexBuilderHelper;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AdditionalServiceCommonProductFopIndexHandler
implements IndexHandler<BookingFile, CommonProductFopIndex> {
    protected Logger log = LoggerFactory.getLogger(this.getClass());

    public Class<? extends BaseIndexData<BookingFile, CommonProductFopIndex>> getDataClass() {
        return CommonProductFopIndexData.class;
    }

    public Class<CommonProductFopIndex> getIndexClass() {
        return CommonProductFopIndex.class;
    }

    public Class<BookingFile> getEntityType() {
        return BookingFile.class;
    }

    public void create(EntityContainer<BookingFile> bookingFileContainer, Collection<BaseIndexData<BookingFile, CommonProductFopIndex>> datas) {
        for (Reservation reservation : ((BookingFile)bookingFileContainer.getEntity()).getReservations()) {
            for (BaseProduct baseProduct : reservation.getProducts()) {
                if (!(baseProduct instanceof AdditionalServiceProduct)) continue;
                AdditionalServiceProduct product = (AdditionalServiceProduct)baseProduct;
                if (ProductStatusHandler.getAllVoidStatuses().contains(product.getStatus())) continue;
                this.updateData(datas, product);
            }
        }
    }

    protected void updateData(Collection<BaseIndexData<BookingFile, CommonProductFopIndex>> datas, AdditionalServiceProduct product) {
        CommonProductFopIndexData data;
        DataAggregator aggregator = new DataAggregator();
        for (GeneralProductFop fop : AdditionalServiceProductHelper.getVendorFops((AdditionalServiceProduct)product)) {
            data = new CommonProductFopIndexData();
            this.updateProductData(data, aggregator, product);
            data.setContractType(ContractType.VENDOR);
            this.updateFopData(data, aggregator, fop, product);
            data.setAggregatedData(aggregator.toString());
            aggregator.reset();
            datas.add((BaseIndexData<BookingFile, CommonProductFopIndex>)data);
        }
        for (GeneralProductFop fop : AdditionalServiceProductHelper.getSubagentFops((AdditionalServiceProduct)product, (boolean)false)) {
            data = new CommonProductFopIndexData();
            this.updateProductData(data, aggregator, product);
            data.setContractType(ContractType.SUBAGENCY);
            this.updateFopData(data, aggregator, fop, product);
            data.setAggregatedData(aggregator.toString());
            aggregator.reset();
            datas.add((BaseIndexData<BookingFile, CommonProductFopIndex>)data);
        }
        for (GeneralProductFop fop : AdditionalServiceProductHelper.getClientFops((AdditionalServiceProduct)product)) {
            data = new CommonProductFopIndexData();
            this.updateProductData(data, aggregator, product);
            data.setContractType(ContractType.CLIENT);
            this.updateFopData(data, aggregator, fop, product);
            data.setRefuse(Boolean.valueOf(fop.isRefused()));
            data.setAggregatedData(aggregator.toString());
            aggregator.reset();
            datas.add((BaseIndexData<BookingFile, CommonProductFopIndex>)data);
        }
    }

    protected void updateProductData(CommonProductFopIndexData data, DataAggregator aggregator, AdditionalServiceProduct product) {
        data.setProductUid(product.getUid());
        String bookingNumber = TextUtil.buildFullNumber((CompositeNumber)product.getReservation().getBookingFile());
        data.setBookingNumber(bookingNumber);
        aggregator.aggregate((Object)bookingNumber);
        data.setProductType(ProductType.ADDITIONAL_SERVICE);
        aggregator.aggregate((Enum)ProductType.ADDITIONAL_SERVICE);
        data.setClient(product.getReservation().getBookingFile().getCustomerProfile());
        aggregator.aggregate((Object)product.getReservation().getBookingFile().getCustomerProfile());
        EntityReference supplier = AdditionalServiceProductHelper.getSupplier((AdditionalServiceProduct)product);
        data.setSupplier(supplier);
        aggregator.aggregate((Object)supplier);
        EntityReference agency = AdditionalServiceProductHelper.getAgency((AdditionalServiceProduct)product);
        data.setAgency(agency);
        aggregator.aggregate((Object)agency);
        EntityReference subagency = AdditionalServiceProductHelper.getSubagency((AdditionalServiceProduct)product);
        data.setSubagency(subagency);
        aggregator.aggregate((Object)subagency);
        EntityContainer clientContainer = EntityStorage.get().resolve(product.getReservation().getBookingFile().getCustomerProfile());
        if (clientContainer != null) {
            data.setHolding(((Organization)clientContainer.getEntity()).getHolding());
            aggregator.aggregate((Object)((Organization)clientContainer.getEntity()).getHolding());
        }
        data.setSalesPoint(product.getSalesPoint());
        aggregator.aggregate((Object)product.getSalesPoint());
        data.setAgent(product.getAgent());
        aggregator.aggregate((Object)product.getAgent());
        data.setBranch(product.getBranch());
        aggregator.aggregate((Object)product.getBranch());
        IndexBuilderHelper.updateReservationGdsNameInfo(product.getReservation(), data, aggregator);
        data.setIssueDate(product.getIssueDate());
        data.setIssueDateTime(product.getIssueDate());
        data.setUnholdDate(null);
        data.setUnholdDateTime(null);
        ArrayList<String> systemNumbers = new ArrayList<String>();
        if (!TextUtil.isBlank((String)product.getSystemNumber())) {
            systemNumbers.add(product.getSystemNumber());
        }
        data.setSystemNumbers(systemNumbers);
        aggregator.aggregate(systemNumbers);
        List travellersNames = product.getTravellers().stream().map(Traveller::getName).collect(Collectors.toList());
        data.setTravellersNames(travellersNames);
        aggregator.aggregate(travellersNames);
    }

    protected void updateFopData(CommonProductFopIndexData data, DataAggregator aggregator, GeneralProductFop fop, AdditionalServiceProduct product) {
        data.setFopUid(fop.getUid());
        FopType fopType = GeneralProductHelper.getFopType((GeneralProductFop)fop);
        data.setFopType(fopType);
        aggregator.aggregate((Enum)fopType);
        data.setPaymentType(fop.getType());
        aggregator.aggregate((Enum)fop.getType());
        BigDecimal equivalentAmount = fop.getEquivalentAmount();
        if (equivalentAmount != null && (product.getStatus() == ProductStatus.REFUND || product.getStatus() == ProductStatus.EXCHANGE)) {
            equivalentAmount = equivalentAmount.negate();
        }
        data.setAmount(equivalentAmount);
        try {
            String currency = DictHelper.getPreferenceValue((PreferenceKey)PreferenceKey.EQUIVE_CURRENCY, (String)null);
            data.setCurrency(currency);
            aggregator.aggregate((Object)currency);
        }
        catch (Exception currency) {
            // empty catch block
        }
        CardVendor cardVendor = null;
        String cardNumber = null;
        String cardSecurityCode = null;
        if (fop.getCard() != null) {
            Card card = fop.getCard();
            cardVendor = card.getVendor();
            cardNumber = card.getNumber();
            cardSecurityCode = card.getSecurityCode();
        }
        data.setCardVendor(cardVendor);
        aggregator.aggregate((Enum)cardVendor);
        data.setCardNumber(cardNumber);
        aggregator.aggregate((Object)cardNumber);
        data.setCardSecurityCode(cardSecurityCode);
        aggregator.aggregate((Object)cardSecurityCode);
        data.setRelatedTicketNumber(fop.getRelatedTicketNumber());
        aggregator.aggregate((Object)fop.getRelatedTicketNumber());
        data.setFopAgent(fop.getAgent());
        aggregator.aggregate((Object)fop.getAgent());
        data.setFopDate(fop.getOperationDate());
        data.setHasComments(Boolean.valueOf(!TextUtil.isBlank((String)product.getReservation().getBookingFile().getNotes())));
    }
}

