/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.model.index;

import com.gridnine.xtrip.common.model.EntityContainer;
import com.gridnine.xtrip.common.model.EntityReference;
import com.gridnine.xtrip.common.model.booking.BaseProduct;
import com.gridnine.xtrip.common.model.booking.BookingFile;
import com.gridnine.xtrip.common.model.booking.CommonProductIndex;
import com.gridnine.xtrip.common.model.booking.CommonProductIndexData;
import com.gridnine.xtrip.common.model.booking.FopComponent;
import com.gridnine.xtrip.common.model.booking.GeneralProductFop;
import com.gridnine.xtrip.common.model.booking.OperationBatch;
import com.gridnine.xtrip.common.model.booking.ProductStatus;
import com.gridnine.xtrip.common.model.booking.Reservation;
import com.gridnine.xtrip.common.model.booking.TravelSubject;
import com.gridnine.xtrip.common.model.booking.Traveller;
import com.gridnine.xtrip.common.model.booking.ValidationMessage;
import com.gridnine.xtrip.common.model.booking.ValidationMessageCategory;
import com.gridnine.xtrip.common.model.booking.ValidationMessageSeverity;
import com.gridnine.xtrip.common.model.booking.additionalservice.AdditionalServiceProduct;
import com.gridnine.xtrip.common.model.booking.commission.ProductType;
import com.gridnine.xtrip.common.model.dict.ContractType;
import com.gridnine.xtrip.common.model.dict.ProfileGroupReference;
import com.gridnine.xtrip.common.model.entity.EntityStorage;
import com.gridnine.xtrip.common.model.finance.FinanceDocument;
import com.gridnine.xtrip.common.model.handlers.ProductStatusHandler;
import com.gridnine.xtrip.common.model.helpers.AdditionalServiceProductHelper;
import com.gridnine.xtrip.common.model.helpers.BookingHelper;
import com.gridnine.xtrip.common.model.helpers.GeneralProductHelper;
import com.gridnine.xtrip.common.model.helpers.SystemHelper;
import com.gridnine.xtrip.common.model.profile.Contract;
import com.gridnine.xtrip.common.model.profile.Organization;
import com.gridnine.xtrip.common.model.profile.Person;
import com.gridnine.xtrip.common.model.system.MetadataKey;
import com.gridnine.xtrip.common.model.system.PaymentType;
import com.gridnine.xtrip.common.model.system.VatAmount;
import com.gridnine.xtrip.common.util.CollectionUtil;
import com.gridnine.xtrip.common.util.CompositeNumber;
import com.gridnine.xtrip.common.util.MiscUtil;
import com.gridnine.xtrip.common.util.TextUtil;
import com.gridnine.xtrip.server.db.storage.model.BaseIndexData;
import com.gridnine.xtrip.server.db.storage.model.DataAggregator;
import com.gridnine.xtrip.server.db.storage.model.IndexHandler;
import com.gridnine.xtrip.server.model.handlers.ServerHandlersRegistry;
import com.gridnine.xtrip.server.model.handlers.index.CommonIndexHandler;
import com.gridnine.xtrip.server.model.index.BaseCommonProductIndexHandler;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.EnumSet;
import java.util.HashSet;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AdditionalServiceCommonProductIndexHandler
extends BaseCommonProductIndexHandler
implements IndexHandler<BookingFile, CommonProductIndex> {
    Logger log = LoggerFactory.getLogger(this.getClass());

    public Class<? extends BaseIndexData<BookingFile, CommonProductIndex>> getDataClass() {
        return CommonProductIndexData.class;
    }

    public Class<CommonProductIndex> getIndexClass() {
        return CommonProductIndex.class;
    }

    public Class<BookingFile> getEntityType() {
        return BookingFile.class;
    }

    public void create(EntityContainer<BookingFile> etc, Collection<BaseIndexData<BookingFile, CommonProductIndex>> indexes) {
        DataAggregator aggregator = new DataAggregator();
        for (Reservation reservation : ((BookingFile)etc.getEntity()).getReservations()) {
            for (BaseProduct baseProduct : reservation.getProducts()) {
                if (!(baseProduct instanceof AdditionalServiceProduct)) continue;
                aggregator.reset();
                try {
                    CommonProductIndexData data = new CommonProductIndexData();
                    List handlers = ServerHandlersRegistry.get().findCommonIndexHandlers(this.getIndexClass());
                    for (CommonIndexHandler<BaseProduct, BookingFile, CommonProductIndex> commonIndexHandler : handlers) {
                        commonIndexHandler.updateData((BaseIndexData<BookingFile, CommonProductIndex>)data, aggregator, etc, baseProduct);
                    }
                    this.updateData(data, aggregator, etc, (AdditionalServiceProduct)baseProduct);
                    data.setAggregatedData(aggregator.toString());
                    indexes.add((BaseIndexData<BookingFile, CommonProductIndex>)data);
                }
                catch (Exception e) {
                    this.log.error("unable to create index", (Throwable)e);
                }
            }
        }
    }

    protected void updateData(CommonProductIndexData data, DataAggregator aggregator, EntityContainer<BookingFile> etc, AdditionalServiceProduct product) {
        data.setNavigationKey(product.getUid());
        String bookingNumber = TextUtil.buildFullNumber((CompositeNumber)product.getReservation().getBookingFile());
        data.setBookingNumber(bookingNumber);
        aggregator.aggregate((Object)bookingNumber);
        data.setBookingCreateDate(product.getReservation().getBookingFile().getCreateDate());
        aggregator.aggregate(product.getReservation().getBookingFile().getCreateDate());
        data.setTimeLimit(product.getReservation().getTimeLimit());
        aggregator.aggregate(product.getReservation().getTimeLimit());
        String militaryClaimNumber = GeneralProductHelper.getMilitaryClaimNumber((BaseProduct)product);
        data.setMilitaryClaimNumber(militaryClaimNumber);
        aggregator.aggregate((Object)militaryClaimNumber);
        EntityReference agency = AdditionalServiceProductHelper.getAgency((AdditionalServiceProduct)product);
        data.setAgency(agency);
        aggregator.aggregate((Object)agency);
        EntityReference supplier = AdditionalServiceProductHelper.getSupplier((AdditionalServiceProduct)product);
        data.setSupplier(supplier);
        aggregator.aggregate((Object)supplier);
        data.setStatus(product.getStatus());
        aggregator.aggregate((Enum)product.getStatus());
        data.setTicketType(product.getTicketType());
        aggregator.aggregate((Enum)product.getTicketType());
        data.setAgent(product.getAgent());
        aggregator.aggregate((Object)product.getAgent());
        data.setBranch(product.getBranch());
        aggregator.aggregate((Object)product.getBranch());
        data.setIssueDate(product.getIssueDate());
        data.setIssueDateTime(product.getIssueDate());
        data.setLocalIssueDate(product.getLocalIssueDate());
        data.setUnholdDate(null);
        data.setUnholdDateTime(null);
        data.setAdditionalServiceCategory(product.getCategory());
        String systemNumber = product.getSystemNumber();
        ArrayList<String> systemNumbers = new ArrayList<String>();
        if (!TextUtil.isBlank((String)systemNumber)) {
            systemNumbers.add(systemNumber);
        }
        data.setSystemNumbers(systemNumbers);
        aggregator.aggregate(systemNumbers);
        data.setFirstSystemNumber((String)CollectionUtil.head(systemNumbers));
        String sortingNumber = product.getSystemNumber();
        data.setSncs(Collections.emptyList());
        data.setChecked(Boolean.valueOf(product.isChecked()));
        data.setCompleted(Boolean.valueOf(product.isCompleted()));
        data.setAgent(product.getAgent());
        aggregator.aggregate((Object)product.getAgent());
        EntityReference clientRelationMediator = GeneralProductHelper.getClientRelationMediator((BaseProduct)product);
        data.setMediator(clientRelationMediator);
        aggregator.aggregate((Object)clientRelationMediator);
        data.setClient(product.getReservation().getBookingFile().getCustomerProfile());
        aggregator.aggregate((Object)product.getReservation().getBookingFile().getCustomerProfile());
        try {
            EntityContainer client = EntityStorage.get().resolve(product.getReservation().getBookingFile().getCustomerProfile());
            if (client != null) {
                String code = SystemHelper.findMetadataAsString((Collection)((Organization)client.getEntity()).getMetadata(), (MetadataKey)MetadataKey.KEY_ACCOUNTING_SYSTEM_CODE);
                code = code != null ? code : ((Organization)client.getEntity()).getCode();
                data.setClientAccountingCode(code);
                aggregator.aggregate((Object)code);
                ArrayList<ProfileGroupReference> clientGroups = new ArrayList<ProfileGroupReference>();
                for (Object metadata : ((Organization)client.getEntity()).getMetadata()) {
                    if (metadata.getKey() == null || !metadata.getKey().getCode().equals(MetadataKey.KEY_ORGANIZATION_PROFILE_GROUP.name()) || metadata.getValue() == null) continue;
                    clientGroups.add((ProfileGroupReference)metadata.getValue());
                }
                data.setClientGroups(clientGroups);
                aggregator.aggregate(clientGroups);
            }
        }
        catch (Throwable e) {
            this.log.error("unable to load profile " + product.getReservation().getBookingFile().getCustomerProfile(), e);
        }
        EntityReference subagency = AdditionalServiceProductHelper.getSubagency((AdditionalServiceProduct)product);
        data.setSubagency(subagency);
        aggregator.aggregate((Object)subagency);
        EntityContainer clientContainer = EntityStorage.get().resolve(product.getReservation().getBookingFile().getCustomerProfile());
        if (clientContainer != null) {
            data.setHolding(((Organization)clientContainer.getEntity()).getHolding());
            aggregator.aggregate((Object)((Organization)clientContainer.getEntity()).getHolding());
        }
        data.setSalesPoint(product.getSalesPoint());
        aggregator.aggregate((Object)product.getSalesPoint());
        data.setEticket(Boolean.valueOf(false));
        Date refuseDate = null;
        List clientFops = AdditionalServiceProductHelper.getClientFops((AdditionalServiceProduct)product);
        for (GeneralProductFop fop2 : clientFops) {
            if (!fop2.isRefused() || fop2.getOperationDate() == null || refuseDate != null && !refuseDate.after(fop2.getOperationDate())) continue;
            refuseDate = fop2.getOperationDate();
        }
        if (refuseDate != null) {
            data.setCancellationDate(refuseDate);
            aggregator.aggregate(refuseDate);
        }
        List travellers = product.getTravellers();
        List travellersNames = travellers.stream().map(Traveller::getName).collect(Collectors.toList());
        data.setTravellersNames(travellersNames);
        Set passengers = travellers.stream().filter(traveller -> traveller.getPassenger() != null).map(Traveller::getPassenger).collect(Collectors.toSet());
        aggregator.aggregate(travellersNames);
        data.setPassengers(passengers);
        OperationBatch batch = null;
        if (product.getStatus() != null) {
            switch (product.getStatus()) {
                case BOOKING: 
                case VOID: 
                case VOID_BOOKING: {
                    batch = OperationBatch.VOID;
                    break;
                }
                case REFUND: {
                    batch = OperationBatch.REFUND;
                    sortingNumber = product.getSystemNumber() + "3";
                    break;
                }
                case SELL: {
                    batch = OperationBatch.SELL;
                    break;
                }
                case EXCHANGE: {
                    batch = OperationBatch.EXCHANGE;
                    break;
                }
            }
        }
        data.setOperationBatch(batch);
        aggregator.aggregate((Object)sortingNumber);
        data.setSortingTicketNumber(sortingNumber);
        aggregator.aggregate((Enum)batch);
        data.setWorkflowStatus(product.getReservation().getBookingFile().getWorkflowStatus());
        aggregator.aggregate((Enum)product.getReservation().getBookingFile().getWorkflowStatus());
        data.setReservationStatus(product.getReservation().getStatus());
        aggregator.aggregate((Enum)product.getReservation().getStatus());
        data.setTravelSubject(TravelSubject.ADDITIONAL_SERVICE);
        aggregator.aggregate((Enum)TravelSubject.ADDITIONAL_SERVICE);
        data.setProductType(ProductType.ADDITIONAL_SERVICE);
        aggregator.aggregate((Enum)ProductType.ADDITIONAL_SERVICE);
        if (!ProductStatusHandler.getAllVoidStatuses().contains(product.getStatus())) {
            boolean refund = product.getStatus() == ProductStatus.REFUND || product.getStatus() == ProductStatus.EXCHANGE;
            boolean exchange = product.getStatus() == ProductStatus.EXCHANGE;
            data.setValid(Boolean.valueOf(true));
            data.setHasOtherErrors(Boolean.valueOf(false));
            data.setHasStockControlErrors(Boolean.valueOf(false));
            data.setHasRulesErrors(Boolean.valueOf(false));
            data.setHasShipmentErrors(Boolean.valueOf(false));
            data.setHasErrors(Boolean.valueOf(false));
            for (ValidationMessage message : product.getValidationMessages()) {
                if (message.getSeverity() == ValidationMessageSeverity.WARNING) {
                    data.setHasWarnings(Boolean.valueOf(true));
                }
                if (message.getSeverity() == ValidationMessageSeverity.USER_ERROR) {
                    data.setHasUserErrors(Boolean.valueOf(true));
                    data.setHasErrors(Boolean.valueOf(true));
                }
                if (message.getSeverity() == ValidationMessageSeverity.SHIPMENT_ERROR) {
                    data.setHasShipmentErrors(Boolean.valueOf(true));
                }
                if (message.getSeverity() != ValidationMessageSeverity.ERROR) continue;
                data.setHasErrors(Boolean.valueOf(true));
                if (message.getCategory() == ValidationMessageCategory.OTHER) {
                    data.setValid(Boolean.valueOf(false));
                    data.setHasOtherErrors(Boolean.valueOf(true));
                }
                if (message.getCategory() == ValidationMessageCategory.STOCK_CONTROL) {
                    data.setHasStockControlErrors(Boolean.valueOf(true));
                }
                if (message.getCategory() != ValidationMessageCategory.RULES) continue;
                data.setHasRulesErrors(Boolean.valueOf(true));
            }
            VatAmount price = BookingHelper.calculateProductPrice((BaseProduct)product, (ContractType)ContractType.CLIENT);
            BigDecimal totalSum = price.getTotal();
            data.setTotalSum(totalSum);
            aggregator.aggregate((Object)totalSum);
            data.setVatRate(price.getVat());
            data.setVatValue(price.getVatAmount());
            try {
                data.setVendorCommissionValue(BookingHelper.getCommissionValue((BigDecimal)GeneralProductHelper.calculateCommissionsEquivalentValue((Collection)GeneralProductHelper.filterCommissions((Collection)AdditionalServiceProductHelper.getUnmodifiableCommissions((AdditionalServiceProduct)product, (ContractType)ContractType.VENDOR), (Set)GeneralProductHelper.commissionCommissionPropertyTypes, (Set)GeneralProductHelper.standardCommissionTypes, null)), (boolean)refund));
                data.setVendorBonusValue(BookingHelper.getCommissionValue((BigDecimal)GeneralProductHelper.calculateCommissionsEquivalentValue((Collection)GeneralProductHelper.filterCommissions((Collection)AdditionalServiceProductHelper.getUnmodifiableCommissions((AdditionalServiceProduct)product, (ContractType)ContractType.VENDOR), (Set)GeneralProductHelper.commissionCommissionPropertyTypes, (Set)GeneralProductHelper.bonusCommissionTypes, null)), (boolean)refund));
                data.setVendorFeeValue(BookingHelper.getCommissionValue((BigDecimal)GeneralProductHelper.calculateCommissionsEquivalentValue((Collection)GeneralProductHelper.filterCommissions((Collection)AdditionalServiceProductHelper.getUnmodifiableCommissions((AdditionalServiceProduct)product, (ContractType)ContractType.VENDOR), (Set)GeneralProductHelper.feePropertyTypes, null, null)), (boolean)refund));
                data.setVendorCommissionRate(GeneralProductHelper.calculateCommissionsRateAsDouble((Collection)GeneralProductHelper.filterCommissions((Collection)AdditionalServiceProductHelper.getUnmodifiableCommissions((AdditionalServiceProduct)product, (ContractType)ContractType.VENDOR), (Set)GeneralProductHelper.commissionCommissionPropertyTypes, (Set)GeneralProductHelper.standardCommissionTypes, null), (boolean)true));
                data.setVendorBonusRate(GeneralProductHelper.calculateCommissionsRateAsDouble((Collection)GeneralProductHelper.filterCommissions((Collection)AdditionalServiceProductHelper.getUnmodifiableCommissions((AdditionalServiceProduct)product, (ContractType)ContractType.VENDOR), (Set)GeneralProductHelper.commissionCommissionPropertyTypes, (Set)GeneralProductHelper.bonusCommissionTypes, null), (boolean)true));
                data.setVendorFeeRate(GeneralProductHelper.calculateCommissionsRateAsDouble((Collection)GeneralProductHelper.filterCommissions((Collection)AdditionalServiceProductHelper.getUnmodifiableCommissions((AdditionalServiceProduct)product, (ContractType)ContractType.VENDOR), (Set)GeneralProductHelper.feePropertyTypes, null, null), (boolean)true));
                data.setSubagencyCommissionValue(BookingHelper.getCommissionValue((BigDecimal)GeneralProductHelper.calculateCommissionsEquivalentValue((Collection)GeneralProductHelper.filterCommissions((Collection)AdditionalServiceProductHelper.getUnmodifiableCommissions((AdditionalServiceProduct)product, (ContractType)ContractType.SUBAGENCY), (Set)GeneralProductHelper.commissionCommissionPropertyTypes, (Set)GeneralProductHelper.standardCommissionTypes, null)), (boolean)refund));
                data.setSubagencyBonusValue(BookingHelper.getCommissionValue((BigDecimal)GeneralProductHelper.calculateCommissionsEquivalentValue((Collection)GeneralProductHelper.filterCommissions((Collection)AdditionalServiceProductHelper.getUnmodifiableCommissions((AdditionalServiceProduct)product, (ContractType)ContractType.SUBAGENCY), (Set)GeneralProductHelper.commissionCommissionPropertyTypes, (Set)GeneralProductHelper.bonusCommissionTypes, null)), (boolean)refund));
                data.setSubagencyFeeValue(BookingHelper.getCommissionValue((BigDecimal)GeneralProductHelper.calculateCommissionsEquivalentValue((Collection)GeneralProductHelper.filterCommissions((Collection)AdditionalServiceProductHelper.getUnmodifiableCommissions((AdditionalServiceProduct)product, (ContractType)ContractType.SUBAGENCY), (Set)GeneralProductHelper.feePropertyTypes, null, null)), (boolean)refund));
                data.setSubagencyHiddenFeeValue(BookingHelper.getCommissionValue((BigDecimal)GeneralProductHelper.calculateCommissionsEquivalentValue((Collection)GeneralProductHelper.filterCommissions((Collection)AdditionalServiceProductHelper.getUnmodifiableCommissions((AdditionalServiceProduct)product, (ContractType)ContractType.SUBAGENCY), (Set)GeneralProductHelper.feePropertyTypes, null, (Set)GeneralProductHelper.hiddenCommissionCategories)), (boolean)refund));
                data.setSubagencyCommissionRate(GeneralProductHelper.calculateCommissionsRateAsDouble((Collection)GeneralProductHelper.filterCommissions((Collection)AdditionalServiceProductHelper.getUnmodifiableCommissions((AdditionalServiceProduct)product, (ContractType)ContractType.SUBAGENCY), (Set)GeneralProductHelper.commissionCommissionPropertyTypes, (Set)GeneralProductHelper.standardCommissionTypes, null), (boolean)true));
                data.setSubagencyBonusRate(GeneralProductHelper.calculateCommissionsRateAsDouble((Collection)GeneralProductHelper.filterCommissions((Collection)AdditionalServiceProductHelper.getUnmodifiableCommissions((AdditionalServiceProduct)product, (ContractType)ContractType.SUBAGENCY), (Set)GeneralProductHelper.commissionCommissionPropertyTypes, (Set)GeneralProductHelper.bonusCommissionTypes, null), (boolean)true));
                data.setSubagencyFeeRate(GeneralProductHelper.calculateCommissionsRateAsDouble((Collection)GeneralProductHelper.filterCommissions((Collection)AdditionalServiceProductHelper.getUnmodifiableCommissions((AdditionalServiceProduct)product, (ContractType)ContractType.SUBAGENCY), (Set)GeneralProductHelper.feePropertyTypes, null, null), (boolean)true));
                data.setClientCommissionValue(BookingHelper.getCommissionValue((BigDecimal)GeneralProductHelper.calculateCommissionsEquivalentValue((Collection)GeneralProductHelper.filterCommissions((Collection)AdditionalServiceProductHelper.getUnmodifiableCommissions((AdditionalServiceProduct)product, (ContractType)ContractType.CLIENT), (Set)GeneralProductHelper.commissionCommissionPropertyTypes, (Set)GeneralProductHelper.standardCommissionTypes, null)), (boolean)refund));
                data.setClientBonusValue(BookingHelper.getCommissionValue((BigDecimal)GeneralProductHelper.calculateCommissionsEquivalentValue((Collection)GeneralProductHelper.filterCommissions((Collection)AdditionalServiceProductHelper.getUnmodifiableCommissions((AdditionalServiceProduct)product, (ContractType)ContractType.CLIENT), (Set)GeneralProductHelper.commissionCommissionPropertyTypes, (Set)GeneralProductHelper.bonusCommissionTypes, null)), (boolean)refund));
                data.setClientFeeValue(BookingHelper.getCommissionValue((BigDecimal)GeneralProductHelper.calculateCommissionsEquivalentValue((Collection)GeneralProductHelper.filterCommissions((Collection)AdditionalServiceProductHelper.getUnmodifiableCommissions((AdditionalServiceProduct)product, (ContractType)ContractType.CLIENT), (Set)GeneralProductHelper.feePropertyTypes, null, null)), (boolean)refund));
                data.setClientServiceFeeValue(BookingHelper.getCommissionValue((BigDecimal)GeneralProductHelper.calculateCommissionsEquivalentValue((Collection)GeneralProductHelper.filterCommissions((Collection)AdditionalServiceProductHelper.getUnmodifiableCommissions((AdditionalServiceProduct)product, (ContractType)ContractType.CLIENT), (Set)GeneralProductHelper.serviceFeePropertyTypes, null, null)), (boolean)refund));
                data.setClientPaymentFeeValue(BookingHelper.getCommissionValue((BigDecimal)GeneralProductHelper.calculateCommissionsEquivalentValue((Collection)GeneralProductHelper.filterCommissions((Collection)AdditionalServiceProductHelper.getUnmodifiableCommissions((AdditionalServiceProduct)product, (ContractType)ContractType.CLIENT), (Set)GeneralProductHelper.paymentFeePropertyTypes, null, null)), (boolean)refund));
                data.setClientCommissionRate(GeneralProductHelper.calculateCommissionsRateAsDouble((Collection)GeneralProductHelper.filterCommissions((Collection)AdditionalServiceProductHelper.getUnmodifiableCommissions((AdditionalServiceProduct)product, (ContractType)ContractType.CLIENT), (Set)GeneralProductHelper.commissionCommissionPropertyTypes, (Set)GeneralProductHelper.standardCommissionTypes, null), (boolean)true));
                data.setClientBonusRate(GeneralProductHelper.calculateCommissionsRateAsDouble((Collection)GeneralProductHelper.filterCommissions((Collection)AdditionalServiceProductHelper.getUnmodifiableCommissions((AdditionalServiceProduct)product, (ContractType)ContractType.CLIENT), (Set)GeneralProductHelper.commissionCommissionPropertyTypes, (Set)GeneralProductHelper.bonusCommissionTypes, null), (boolean)true));
                data.setClientFeeRate(GeneralProductHelper.calculateCommissionsRateAsDouble((Collection)GeneralProductHelper.filterCommissions((Collection)AdditionalServiceProductHelper.getUnmodifiableCommissions((AdditionalServiceProduct)product, (ContractType)ContractType.CLIENT), (Set)GeneralProductHelper.feePropertyTypes, null, null), (boolean)true));
            }
            catch (Exception e) {
                this.log.error("failed calculating commissions ", (Throwable)e);
            }
            Date date = null;
            EntityReference agent = null;
            boolean hasClientDebt = false;
            HashSet<PaymentType> clientFopTypes = new HashSet<PaymentType>();
            HashSet<PaymentType> clientFeesFopTypes = new HashSet<PaymentType>();
            Object clientFOPAmount = null;
            BigDecimal clientFOPAddAmount = null;
            BigDecimal clientFOPTotalAddAmount = null;
            EnumSet<PaymentType> addPaymentTypes = EnumSet.allOf(PaymentType.class);
            addPaymentTypes.remove(PaymentType.TICKET);
            addPaymentTypes.remove(PaymentType.VOUCHER);
            addPaymentTypes.remove(PaymentType.MTD);
            addPaymentTypes.remove(PaymentType.MTD_AGENCY);
            addPaymentTypes.remove(PaymentType.CREDIT);
            addPaymentTypes.remove(PaymentType.CREDIT_CARD);
            for (GeneralProductFop fop3 : clientFops) {
                if (fop3.getEquivalentAmount() != null) {
                    BigDecimal fopAmount = fop3.getEquivalentAmount();
                    Object object = clientFOPAmount = clientFOPAmount != null ? ((BigDecimal)clientFOPAmount).add(fopAmount) : fopAmount;
                }
                if (!exchange && fop3.getEquivalentAmount() != null && addPaymentTypes.contains(fop3.getType()) && GeneralProductHelper.productFopTypes.contains(GeneralProductHelper.getFopType((GeneralProductFop)fop3))) {
                    BigDecimal bigDecimal = clientFOPAddAmount = clientFOPAddAmount != null ? clientFOPAddAmount.add(fop3.getEquivalentAmount()) : fop3.getEquivalentAmount();
                }
                if (!exchange && fop3.getEquivalentAmount() != null && addPaymentTypes.contains(fop3.getType()) && !GeneralProductHelper.discountFopTypes.contains(GeneralProductHelper.getFopType((GeneralProductFop)fop3))) {
                    BigDecimal bigDecimal = clientFOPTotalAddAmount = clientFOPTotalAddAmount != null ? clientFOPTotalAddAmount.add(fop3.getEquivalentAmount()) : fop3.getEquivalentAmount();
                }
                if (fop3.getType() != null) {
                    if (GeneralProductHelper.isServiceFop((GeneralProductFop)fop3)) {
                        clientFopTypes.add(fop3.getType());
                    } else {
                        clientFeesFopTypes.add(fop3.getType());
                    }
                }
                if (fop3.getOperationDate() == null) {
                    hasClientDebt = true;
                    continue;
                }
                if (date != null && !date.before(fop3.getOperationDate())) continue;
                date = fop3.getOperationDate();
                agent = fop3.getAgent();
            }
            data.setClientFopAmount(clientFOPAmount);
            aggregator.aggregate(clientFOPAmount);
            if (refund && clientFOPAddAmount != null) {
                clientFOPAddAmount = clientFOPAddAmount.negate();
            }
            data.setClientFopAddAmount(clientFOPAddAmount);
            aggregator.aggregate((Object)clientFOPAddAmount);
            if (refund && clientFOPTotalAddAmount != null) {
                clientFOPTotalAddAmount = clientFOPTotalAddAmount.negate();
            }
            data.setClientFopTotalAddAmount(clientFOPTotalAddAmount);
            aggregator.aggregate((Object)clientFOPTotalAddAmount);
            data.setClientFopTypes(clientFopTypes);
            aggregator.aggregate(clientFopTypes);
            data.setClientFeesFopTypes(clientFeesFopTypes);
            aggregator.aggregate(clientFeesFopTypes);
            data.setDateOfClientPayment(date);
            aggregator.aggregate(date);
            data.setClientFopAgent(agent);
            aggregator.aggregate((Object)agent);
            data.setHasClientDebt(Boolean.valueOf(hasClientDebt));
            data.setPayers((Collection)GeneralProductHelper.getClientFops((BaseProduct)product).stream().filter(fop -> fop.getPayer() != null).map(GeneralProductFop::getPayer).collect(Collectors.toSet()));
            data.setSubagencyContractTotalSum(BookingHelper.calculateProductPrice((BaseProduct)product, (ContractType)ContractType.SUBAGENCY).getTotal());
        } else {
            data.setValid(Boolean.valueOf(true));
            data.setHasOtherErrors(Boolean.valueOf(false));
        }
        Date date = null;
        HashSet<PaymentType> vendorFopTypes = new HashSet<PaymentType>();
        BigDecimal vendorFOPAmount = null;
        for (GeneralProductFop fop4 : AdditionalServiceProductHelper.getVendorFops((AdditionalServiceProduct)product)) {
            if (fop4.getEquivalentAmount() != null) {
                BigDecimal fopAmount = fop4.getEquivalentAmount();
                BigDecimal bigDecimal = vendorFOPAmount = vendorFOPAmount != null ? vendorFOPAmount.add(fopAmount) : fopAmount;
            }
            if (fop4.getType() != null) {
                vendorFopTypes.add(fop4.getType());
            }
            if (fop4.getOperationDate() == null || date != null && !date.before(fop4.getOperationDate())) continue;
            date = fop4.getOperationDate();
        }
        data.setVendorFopAmount(vendorFOPAmount);
        aggregator.aggregate(vendorFOPAmount);
        data.setDateOfVendorPayment(date);
        aggregator.aggregate(date);
        data.setVendorFopTypes(vendorFopTypes);
        aggregator.aggregate(vendorFopTypes);
        HashSet<PaymentType> subagentFopTypes = new HashSet<PaymentType>();
        HashSet<PaymentType> subagentFeesFopTypes = new HashSet<PaymentType>();
        List subagentFops = AdditionalServiceProductHelper.getSubagentFops((AdditionalServiceProduct)product, (boolean)false);
        if (subagentFops != null) {
            for (GeneralProductFop fop5 : subagentFops) {
                if (fop5.getType() == null) continue;
                if (GeneralProductHelper.isServiceFop((GeneralProductFop)fop5)) {
                    subagentFopTypes.add(fop5.getType());
                    continue;
                }
                subagentFeesFopTypes.add(fop5.getType());
            }
        }
        data.setSubagentFopTypes(subagentFopTypes);
        data.setSubagentFeesFopTypes(subagentFeesFopTypes);
        Set shipments = product.getFopDetalizations().values().stream().flatMap(item -> item.getComponents().stream()).filter(item -> item.getShipment() != null).map(FopComponent::getShipment).collect(Collectors.toSet());
        data.setShipments(shipments);
        aggregator.aggregate(shipments);
        data.setShipmentsDate(product.getShipmentsDate());
        data.setShipmentsDateSubagent(product.getShipmentsDateSubagent());
        data.setFopComponentsAllUsed(Boolean.valueOf(product.getFopDetalizations().values().stream().flatMap(item -> item.getComponents().stream()).allMatch(item -> item.getShipment() != null)));
        EntityReference clientPrepaymentDocument = null;
        EntityReference subagentPrepaymentDocument = null;
        for (EntityReference prepaymentDocumentReference : product.getPrepaymentDocuments()) {
            EntityContainer contract;
            EntityContainer prepaymentDocument = EntityStorage.get().resolve(prepaymentDocumentReference);
            if (prepaymentDocument == null || (contract = EntityStorage.get().resolve(((FinanceDocument)prepaymentDocument.getEntity()).getContract())) == null) continue;
            if (((Contract)contract.getEntity()).getContractType() == ContractType.CLIENT) {
                clientPrepaymentDocument = prepaymentDocumentReference;
                continue;
            }
            if (((Contract)contract.getEntity()).getContractType() != ContractType.SUBAGENCY) continue;
            subagentPrepaymentDocument = prepaymentDocumentReference;
        }
        data.setClientPrepaymentDocument(clientPrepaymentDocument);
        data.setSubagentPrepaymentDocument(subagentPrepaymentDocument);
        aggregator.aggregate(clientPrepaymentDocument);
        aggregator.aggregate(subagentPrepaymentDocument);
        Set receipts = product.getFopDetalizations().values().stream().flatMap(fopDetalization -> fopDetalization.getComponents().stream()).map(FopComponent::getReceipt).collect(Collectors.toSet());
        data.setReceipts(receipts);
        Set travellersGroups = GeneralProductHelper.getHandler((BaseProduct)product).getTravellers((BaseProduct)product).stream().map(item -> EntityStorage.get().resolve(item.getPassenger())).filter(item -> item != null).flatMap(item -> ((Person)item.getEntity()).getMetadata().stream()).filter(item -> item.getKey() != null && item.getValue() != null && MiscUtil.equals((Object)item.getKey().getCode(), (Object)MetadataKey.KEY_PERSON_PROFILE_GROUP.name())).map(item -> (ProfileGroupReference)item.getValue()).collect(Collectors.toSet());
        data.setTravellersGroups(travellersGroups);
        aggregator.aggregate(travellersGroups);
        Set agentsGroups = Optional.ofNullable(EntityStorage.get().resolve(GeneralProductHelper.getHandler((BaseProduct)product).findIssuingAgent((BaseProduct)product))).map(item -> ((Person)item.getEntity()).getMetadata()).orElse(Collections.emptyList()).stream().filter(item -> item.getKey() != null && item.getValue() != null && MiscUtil.equals((Object)item.getKey().getCode(), (Object)MetadataKey.KEY_PERSON_PROFILE_GROUP.name())).map(item -> (ProfileGroupReference)item.getValue()).collect(Collectors.toSet());
        data.setAgentsGroups(agentsGroups);
        aggregator.aggregate(agentsGroups);
        data.setAggregator(aggregator);
        this.updateStatisticalData(data, product.getStatisticalData(), (EntityReference<Organization>)product.getReservation().getBookingFile().getCustomerProfile());
        data.setAggregator(null);
    }
}

