/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.model.index;

import com.gridnine.xtrip.common.model.EntityContainer;
import com.gridnine.xtrip.common.model.EntityReference;
import com.gridnine.xtrip.common.model.booking.BaseProduct;
import com.gridnine.xtrip.common.model.booking.BookingFile;
import com.gridnine.xtrip.common.model.booking.ProductStatus;
import com.gridnine.xtrip.common.model.booking.Reservation;
import com.gridnine.xtrip.common.model.booking.Traveller;
import com.gridnine.xtrip.common.model.booking.ValidationMessage;
import com.gridnine.xtrip.common.model.booking.ValidationMessageCategory;
import com.gridnine.xtrip.common.model.booking.ValidationMessageSeverity;
import com.gridnine.xtrip.common.model.booking.additionalservice.AdditionalServiceCategory;
import com.gridnine.xtrip.common.model.booking.additionalservice.AdditionalServiceProduct;
import com.gridnine.xtrip.common.model.booking.additionalservice.AdditionalServiceProductIndex;
import com.gridnine.xtrip.common.model.booking.additionalservice.AdditionalServiceProductIndexData;
import com.gridnine.xtrip.common.model.helpers.AdditionalServiceProductHelper;
import com.gridnine.xtrip.server.db.storage.model.BaseIndexData;
import com.gridnine.xtrip.server.db.storage.model.DataAggregator;
import com.gridnine.xtrip.server.db.storage.model.IndexHandler;
import com.gridnine.xtrip.server.model.helpers.IndexBuilderHelper;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AdditionalServiceProductIndexHandler
implements IndexHandler<BookingFile, AdditionalServiceProductIndex> {
    Logger log = LoggerFactory.getLogger(this.getClass());

    public Class<? extends BaseIndexData<BookingFile, AdditionalServiceProductIndex>> getDataClass() {
        return AdditionalServiceProductIndexData.class;
    }

    public Class<AdditionalServiceProductIndex> getIndexClass() {
        return AdditionalServiceProductIndex.class;
    }

    public Class<BookingFile> getEntityType() {
        return BookingFile.class;
    }

    public void create(EntityContainer<BookingFile> etc, Collection<BaseIndexData<BookingFile, AdditionalServiceProductIndex>> indexes) {
        for (Reservation reservation : ((BookingFile)etc.getEntity()).getReservations()) {
            DataAggregator aggregator = new DataAggregator();
            for (BaseProduct baseProduct : reservation.getProducts()) {
                if (!(baseProduct instanceof AdditionalServiceProduct)) continue;
                AdditionalServiceProduct AdditionalService2 = (AdditionalServiceProduct)baseProduct;
                AdditionalServiceProductIndexData data = new AdditionalServiceProductIndexData();
                this.updateData(data, aggregator, AdditionalService2);
                data.setAggregatedData(aggregator.toString());
                indexes.add((BaseIndexData<BookingFile, AdditionalServiceProductIndex>)data);
                aggregator.reset();
            }
        }
    }

    private void updateData(AdditionalServiceProductIndexData data, DataAggregator aggregator, AdditionalServiceProduct product) {
        List travellers;
        data.setNavigationKey(product.getUid());
        ProductStatus status = product.getStatus();
        data.setStatus(status);
        Date issueDate = product.getIssueDate();
        data.setIssueDate(issueDate);
        String systemNumber = product.getSystemNumber();
        data.setSystemNumber(systemNumber);
        AdditionalServiceCategory category = product.getCategory();
        data.setCategory(category);
        EntityReference supplier = AdditionalServiceProductHelper.getSupplier((AdditionalServiceProduct)product);
        data.setSupplier(supplier);
        EntityReference subagency = AdditionalServiceProductHelper.getSubagency((AdditionalServiceProduct)product);
        data.setSubagency(subagency);
        EntityReference agency = AdditionalServiceProductHelper.getAgency((AdditionalServiceProduct)product);
        data.setAgency(agency);
        EntityReference salesPoint = product.getSalesPoint();
        data.setSalesPoint(salesPoint);
        EntityReference agent = product.getAgent();
        data.setAgent(agent);
        EntityReference branch = product.getBranch();
        data.setBranch(branch);
        EntityReference customerProfile = product.getReservation().getBookingFile().getCustomerProfile();
        if (customerProfile != null) {
            data.setClient(customerProfile);
            aggregator.aggregate((Object)customerProfile.getCaption());
        }
        if ((travellers = product.getTravellers()) != null) {
            List travellersNames = product.getTravellers().stream().map(Traveller::getName).collect(Collectors.toList());
            data.setTravellersNames(travellersNames);
            aggregator.aggregate(travellersNames);
        }
        aggregator.aggregate((Object)systemNumber);
        boolean inFinanceDocuments = IndexBuilderHelper.isInFinanceDocuments((BaseProduct)product);
        data.setInFinanceDocuments(Boolean.valueOf(inFinanceDocuments));
        data.setTicketType(product.getTicketType());
        data.setChecked(Boolean.valueOf(product.isChecked()));
        data.setCompleted(Boolean.valueOf(product.isCompleted()));
        data.setHasOtherErrors(Boolean.valueOf(false));
        data.setHasErrors(Boolean.valueOf(false));
        for (ValidationMessage message : product.getValidationMessages()) {
            if (message.getSeverity() == ValidationMessageSeverity.USER_ERROR) {
                data.setHasErrors(Boolean.valueOf(true));
            }
            if (message.getSeverity() != ValidationMessageSeverity.ERROR) continue;
            data.setHasErrors(Boolean.valueOf(true));
            if (message.getCategory() != ValidationMessageCategory.OTHER) continue;
            data.setHasOtherErrors(Boolean.valueOf(true));
        }
    }
}

