/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.model.index;

import com.gridnine.xtrip.common.model.EntityContainer;
import com.gridnine.xtrip.common.model.EntityReference;
import com.gridnine.xtrip.common.model.booking.AeroexpressTicket;
import com.gridnine.xtrip.common.model.booking.AeroexpressTicketIndex;
import com.gridnine.xtrip.common.model.booking.AeroexpressTicketIndexData;
import com.gridnine.xtrip.common.model.booking.BaseProduct;
import com.gridnine.xtrip.common.model.booking.BookingFile;
import com.gridnine.xtrip.common.model.booking.GeneralProductFop;
import com.gridnine.xtrip.common.model.booking.ProductStatus;
import com.gridnine.xtrip.common.model.booking.Reservation;
import com.gridnine.xtrip.common.model.booking.StatisticalData;
import com.gridnine.xtrip.common.model.booking.TicketType;
import com.gridnine.xtrip.common.model.booking.ValidationMessageCategory;
import com.gridnine.xtrip.common.model.booking.ValidationMessageSeverity;
import com.gridnine.xtrip.common.model.dict.ContractType;
import com.gridnine.xtrip.common.model.dict.GdsName;
import com.gridnine.xtrip.common.model.entity.EntityStorage;
import com.gridnine.xtrip.common.model.helpers.AeroexpressTicketHelper;
import com.gridnine.xtrip.common.model.helpers.BookingHelper;
import com.gridnine.xtrip.common.model.helpers.CommonReservationGdsNameInfoHelper;
import com.gridnine.xtrip.common.model.helpers.GeneralProductHelper;
import com.gridnine.xtrip.common.model.helpers.ProfileHelper;
import com.gridnine.xtrip.common.model.helpers.StatisticsHelper;
import com.gridnine.xtrip.common.model.profile.CostCode;
import com.gridnine.xtrip.common.model.profile.Organization;
import com.gridnine.xtrip.common.model.system.PaymentType;
import com.gridnine.xtrip.common.util.CompositeNumber;
import com.gridnine.xtrip.common.util.TextUtil;
import com.gridnine.xtrip.server.db.storage.model.BaseIndexData;
import com.gridnine.xtrip.server.db.storage.model.DataAggregator;
import com.gridnine.xtrip.server.db.storage.model.IndexHandler;
import com.gridnine.xtrip.server.model.helpers.IndexBuilderHelper;
import java.math.BigDecimal;
import java.util.Collection;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AeroexpressTicketIndexHandler
implements IndexHandler<BookingFile, AeroexpressTicketIndex> {
    Logger log = LoggerFactory.getLogger(this.getClass());

    public Class<? extends BaseIndexData<BookingFile, AeroexpressTicketIndex>> getDataClass() {
        return AeroexpressTicketIndexData.class;
    }

    public Class<AeroexpressTicketIndex> getIndexClass() {
        return AeroexpressTicketIndex.class;
    }

    public Class<BookingFile> getEntityType() {
        return BookingFile.class;
    }

    public void create(EntityContainer<BookingFile> etc, Collection<BaseIndexData<BookingFile, AeroexpressTicketIndex>> indexes) {
        for (Reservation reservation : ((BookingFile)etc.getEntity()).getReservations()) {
            DataAggregator aggregator = new DataAggregator();
            for (BaseProduct product : reservation.getProducts()) {
                if (!(product instanceof AeroexpressTicket)) continue;
                AeroexpressTicketIndexData data = new AeroexpressTicketIndexData();
                aggregator.reset();
                try {
                    AeroexpressTicket airProduct = (AeroexpressTicket)product;
                    this.updateData(data, aggregator, airProduct);
                    data.setAggregatedData(aggregator.toString());
                }
                catch (Exception e) {
                    this.log.error("unable to create index", (Throwable)e);
                    continue;
                }
                indexes.add((BaseIndexData<BookingFile, AeroexpressTicketIndex>)data);
            }
        }
    }

    protected void updateData(AeroexpressTicketIndexData data, DataAggregator aggregator, AeroexpressTicket product) throws Exception {
        String bookingNumber = TextUtil.buildFullNumber((CompositeNumber)product.getReservation().getBookingFile());
        data.setClassOfService(product.getClassOfService());
        data.setBookingNumber(bookingNumber);
        aggregator.aggregate((Object)bookingNumber);
        data.setAgency(AeroexpressTicketHelper.getAgency((AeroexpressTicket)product));
        aggregator.aggregate((Object)AeroexpressTicketHelper.getAgency((AeroexpressTicket)product));
        data.setAgent(product.getAgent());
        aggregator.aggregate((Object)product.getAgent());
        data.setBlankOwner(product.getBlankOwner());
        aggregator.aggregate((Object)product.getBlankOwner());
        data.setBlankType(product.getBlankType());
        aggregator.aggregate((Object)product.getBlankType());
        data.setCancellationDate(GeneralProductHelper.getFirstRefuseDate((List)AeroexpressTicketHelper.getClientFops((AeroexpressTicket)product)));
        data.setDepartureDate(product.getDepartureDate());
        aggregator.aggregate(product.getDepartureDate());
        data.setChecked(Boolean.valueOf(product.isChecked()));
        data.setCompleted(Boolean.valueOf(product.isCompleted()));
        data.setClient(product.getReservation().getBookingFile().getCustomerProfile());
        aggregator.aggregate((Object)product.getReservation().getBookingFile().getCustomerProfile());
        String accountingCode = ProfileHelper.findAccountingCode((EntityReference)product.getReservation().getBookingFile().getCustomerProfile());
        data.setClientAccountingCode(accountingCode);
        aggregator.aggregate((Object)accountingCode);
        boolean refund = product.getStatus() == ProductStatus.REFUND || product.getStatus() == ProductStatus.EXCHANGE;
        data.setNavigationKey(product.getUid());
        List<GdsName> gdsNames = IndexBuilderHelper.getGdsNames(product.getReservation());
        data.setGdsNames(gdsNames);
        aggregator.aggregate(gdsNames);
        List<String> recordLocators = IndexBuilderHelper.getRecordLocators(product.getReservation());
        data.setRecordLocators(recordLocators);
        aggregator.aggregate(recordLocators);
        data.setDisplayedRecordLocator(CommonReservationGdsNameInfoHelper.getDisplayedRecordLocator((Reservation)product.getReservation()));
        data.setRulesGdsName(product.getReservation().getGdsNameInfo().getRulesGdsName());
        ProductStatus status = product.getStatus();
        data.setStatus(status);
        aggregator.aggregate((Enum)status);
        Date issueDate = product.getIssueDate();
        data.setIssueDate(issueDate);
        aggregator.aggregate(issueDate);
        data.setIssueDateTime(issueDate);
        data.setTicketNumber(product.getSystemNumber());
        aggregator.aggregate((Object)product.getSystemNumber());
        data.setProviderSystemNumber(product.getProviderSystemNumber());
        aggregator.aggregate((Object)product.getProviderSystemNumber());
        TicketType ticketType = product.getTicketType() != null ? product.getTicketType() : TicketType.OWN;
        data.setTicketType(ticketType);
        aggregator.aggregate((Enum)ticketType);
        data.setScn(product.getScn());
        aggregator.aggregate((Object)product.getScn());
        data.setPcc(product.getPcc());
        aggregator.aggregate((Object)product.getPcc());
        EntityReference subagency = AeroexpressTicketHelper.getSubagency((AeroexpressTicket)product);
        data.setSubagency(subagency);
        aggregator.aggregate((Object)subagency);
        EntityContainer clientContainer = EntityStorage.get().resolve(product.getReservation().getBookingFile().getCustomerProfile());
        if (clientContainer != null) {
            data.setHolding(((Organization)clientContainer.getEntity()).getHolding());
            aggregator.aggregate((Object)((Organization)clientContainer.getEntity()).getHolding());
        }
        data.setSalesPoint(product.getSalesPoint());
        aggregator.aggregate((Object)product.getSalesPoint());
        data.setSupplier(AeroexpressTicketHelper.getSupplier((AeroexpressTicket)product));
        aggregator.aggregate((Object)AeroexpressTicketHelper.getSupplier((AeroexpressTicket)product));
        data.setProvider(product.getProvider());
        aggregator.aggregate((Object)product.getProvider());
        data.setEticket(Boolean.valueOf(product.isEticket()));
        if (product.getTraveller() != null) {
            data.setTravellerName(product.getTraveller().getName());
            aggregator.aggregate((Object)product.getTraveller().getName());
        }
        data.setHasStockControlErrors(Boolean.TRUE);
        for (Object message : product.getValidationMessages()) {
            if (message.getSeverity() != ValidationMessageSeverity.ERROR) continue;
            data.setHasErrors(Boolean.TRUE);
            if (message.getCategory() == ValidationMessageCategory.OTHER) {
                data.setHasOtherErrors(Boolean.TRUE);
            }
            if (message.getCategory() == ValidationMessageCategory.STOCK_CONTROL) {
                data.setHasStockControlErrors(Boolean.TRUE);
            }
            if (message.getCategory() != ValidationMessageCategory.RULES) continue;
            data.setHasRulesErrors(Boolean.TRUE);
        }
        Date date = null;
        for (GeneralProductFop fop : AeroexpressTicketHelper.getVendorFops((AeroexpressTicket)product)) {
            if (fop.getEquivalentAmount() == null || fop.getOperationDate() == null || date != null && !date.before(fop.getOperationDate())) continue;
            date = fop.getOperationDate();
        }
        data.setDateOfVendorPayment(date);
        if (status != ProductStatus.VOID) {
            BigDecimal equivalentFare = product.getEquivalentFare();
            if (equivalentFare == null) {
                equivalentFare = BigDecimal.ZERO;
            }
            if (refund) {
                equivalentFare = equivalentFare.negate();
            }
            data.setEquivalentFare(equivalentFare);
            aggregator.aggregate((Object)equivalentFare);
            data.setPassengerType(product.getPassengerType());
            aggregator.aggregate((Object)product.getPassengerType());
            BigDecimal total = equivalentFare;
            if (product.getPenalty() != null) {
                total = total.add(product.getPenalty());
            }
            data.setTotalSum(total);
            if (refund && product.getPreviousProduct() != null) {
                data.setSellAgent(product.getPreviousProduct().getAgent());
                aggregator.aggregate((Object)product.getPreviousProduct().getAgent());
            }
            data.setPenalty(product.getPenalty());
            String route = AeroexpressTicketHelper.getLocalizedRouteLine((AeroexpressTicket)product);
            data.setRouteLine(route);
            aggregator.aggregate((Object)route);
            data.setVendorCommissionValue(BookingHelper.getCommissionValue((BigDecimal)GeneralProductHelper.calculateCommissionsEquivalentValue((Collection)GeneralProductHelper.filterCommissions((Collection)AeroexpressTicketHelper.getUnmodifiableCommissions((AeroexpressTicket)product, (ContractType)ContractType.VENDOR), (Set)GeneralProductHelper.commissionCommissionPropertyTypes, (Set)GeneralProductHelper.standardCommissionTypes, null)), (boolean)refund));
            data.setVendorBonusValue(BookingHelper.getCommissionValue((BigDecimal)GeneralProductHelper.calculateCommissionsEquivalentValue((Collection)GeneralProductHelper.filterCommissions((Collection)AeroexpressTicketHelper.getUnmodifiableCommissions((AeroexpressTicket)product, (ContractType)ContractType.VENDOR), (Set)GeneralProductHelper.commissionCommissionPropertyTypes, (Set)GeneralProductHelper.bonusCommissionTypes, null)), (boolean)refund));
            data.setVendorFeeValue(BookingHelper.getCommissionValue((BigDecimal)GeneralProductHelper.calculateCommissionsEquivalentValue((Collection)GeneralProductHelper.filterCommissions((Collection)AeroexpressTicketHelper.getUnmodifiableCommissions((AeroexpressTicket)product, (ContractType)ContractType.VENDOR), (Set)GeneralProductHelper.feePropertyTypes, null, null)), (boolean)refund));
            data.setVendorCommissionRate(GeneralProductHelper.calculateCommissionsRateAsDouble((Collection)GeneralProductHelper.filterCommissions((Collection)AeroexpressTicketHelper.getUnmodifiableCommissions((AeroexpressTicket)product, (ContractType)ContractType.VENDOR), (Set)GeneralProductHelper.commissionCommissionPropertyTypes, (Set)GeneralProductHelper.standardCommissionTypes, null), (boolean)true));
            data.setVendorBonusRate(GeneralProductHelper.calculateCommissionsRateAsDouble((Collection)GeneralProductHelper.filterCommissions((Collection)AeroexpressTicketHelper.getUnmodifiableCommissions((AeroexpressTicket)product, (ContractType)ContractType.VENDOR), (Set)GeneralProductHelper.commissionCommissionPropertyTypes, (Set)GeneralProductHelper.bonusCommissionTypes, null), (boolean)true));
            data.setVendorFeeRate(GeneralProductHelper.calculateCommissionsRateAsDouble((Collection)GeneralProductHelper.filterCommissions((Collection)AeroexpressTicketHelper.getUnmodifiableCommissions((AeroexpressTicket)product, (ContractType)ContractType.VENDOR), (Set)GeneralProductHelper.feePropertyTypes, null, null), (boolean)true));
            data.setSubagencyCommissionValue(BookingHelper.getCommissionValue((BigDecimal)GeneralProductHelper.calculateCommissionsEquivalentValue((Collection)GeneralProductHelper.filterCommissions((Collection)AeroexpressTicketHelper.getUnmodifiableCommissions((AeroexpressTicket)product, (ContractType)ContractType.SUBAGENCY), (Set)GeneralProductHelper.commissionCommissionPropertyTypes, (Set)GeneralProductHelper.standardCommissionTypes, null)), (boolean)refund));
            data.setSubagencyBonusValue(BookingHelper.getCommissionValue((BigDecimal)GeneralProductHelper.calculateCommissionsEquivalentValue((Collection)GeneralProductHelper.filterCommissions((Collection)AeroexpressTicketHelper.getUnmodifiableCommissions((AeroexpressTicket)product, (ContractType)ContractType.SUBAGENCY), (Set)GeneralProductHelper.commissionCommissionPropertyTypes, (Set)GeneralProductHelper.bonusCommissionTypes, null)), (boolean)refund));
            data.setSubagencyFeeValue(BookingHelper.getCommissionValue((BigDecimal)GeneralProductHelper.calculateCommissionsEquivalentValue((Collection)GeneralProductHelper.filterCommissions((Collection)AeroexpressTicketHelper.getUnmodifiableCommissions((AeroexpressTicket)product, (ContractType)ContractType.SUBAGENCY), (Set)GeneralProductHelper.feePropertyTypes, null, null)), (boolean)refund));
            data.setSubagencyCommissionRate(GeneralProductHelper.calculateCommissionsRateAsDouble((Collection)GeneralProductHelper.filterCommissions((Collection)AeroexpressTicketHelper.getUnmodifiableCommissions((AeroexpressTicket)product, (ContractType)ContractType.SUBAGENCY), (Set)GeneralProductHelper.commissionCommissionPropertyTypes, (Set)GeneralProductHelper.standardCommissionTypes, null), (boolean)true));
            data.setSubagencyBonusRate(GeneralProductHelper.calculateCommissionsRateAsDouble((Collection)GeneralProductHelper.filterCommissions((Collection)AeroexpressTicketHelper.getUnmodifiableCommissions((AeroexpressTicket)product, (ContractType)ContractType.SUBAGENCY), (Set)GeneralProductHelper.commissionCommissionPropertyTypes, (Set)GeneralProductHelper.bonusCommissionTypes, null), (boolean)true));
            data.setSubagencyFeeRate(GeneralProductHelper.calculateCommissionsRateAsDouble((Collection)GeneralProductHelper.filterCommissions((Collection)AeroexpressTicketHelper.getUnmodifiableCommissions((AeroexpressTicket)product, (ContractType)ContractType.SUBAGENCY), (Set)GeneralProductHelper.feePropertyTypes, null, null), (boolean)true));
            data.setClientCommissionValue(BookingHelper.getCommissionValue((BigDecimal)GeneralProductHelper.calculateCommissionsEquivalentValue((Collection)GeneralProductHelper.filterCommissions((Collection)AeroexpressTicketHelper.getUnmodifiableCommissions((AeroexpressTicket)product, (ContractType)ContractType.CLIENT), (Set)GeneralProductHelper.commissionCommissionPropertyTypes, (Set)GeneralProductHelper.standardCommissionTypes, null)), (boolean)refund));
            data.setClientBonusValue(BookingHelper.getCommissionValue((BigDecimal)GeneralProductHelper.calculateCommissionsEquivalentValue((Collection)GeneralProductHelper.filterCommissions((Collection)AeroexpressTicketHelper.getUnmodifiableCommissions((AeroexpressTicket)product, (ContractType)ContractType.CLIENT), (Set)GeneralProductHelper.commissionCommissionPropertyTypes, (Set)GeneralProductHelper.bonusCommissionTypes, null)), (boolean)refund));
            data.setClientFeeValue(BookingHelper.getCommissionValue((BigDecimal)GeneralProductHelper.calculateCommissionsEquivalentValue((Collection)GeneralProductHelper.filterCommissions((Collection)AeroexpressTicketHelper.getUnmodifiableCommissions((AeroexpressTicket)product, (ContractType)ContractType.CLIENT), (Set)GeneralProductHelper.feePropertyTypes, null, null)), (boolean)refund));
            data.setClientCommissionRate(GeneralProductHelper.calculateCommissionsRateAsDouble((Collection)GeneralProductHelper.filterCommissions((Collection)AeroexpressTicketHelper.getUnmodifiableCommissions((AeroexpressTicket)product, (ContractType)ContractType.CLIENT), (Set)GeneralProductHelper.commissionCommissionPropertyTypes, (Set)GeneralProductHelper.standardCommissionTypes, null), (boolean)true));
            data.setClientBonusRate(GeneralProductHelper.calculateCommissionsRateAsDouble((Collection)GeneralProductHelper.filterCommissions((Collection)AeroexpressTicketHelper.getUnmodifiableCommissions((AeroexpressTicket)product, (ContractType)ContractType.CLIENT), (Set)GeneralProductHelper.commissionCommissionPropertyTypes, (Set)GeneralProductHelper.bonusCommissionTypes, null), (boolean)true));
            data.setClientFeeRate(GeneralProductHelper.calculateCommissionsRateAsDouble((Collection)GeneralProductHelper.filterCommissions((Collection)AeroexpressTicketHelper.getUnmodifiableCommissions((AeroexpressTicket)product, (ContractType)ContractType.CLIENT), (Set)GeneralProductHelper.feePropertyTypes, null, null), (boolean)true));
            Date date2 = null;
            EntityReference agent = null;
            boolean hasClientDebt = false;
            HashSet<PaymentType> clientFopTypes = new HashSet<PaymentType>();
            HashSet<PaymentType> clientFeesFopTypes = new HashSet<PaymentType>();
            BigDecimal clientFOPAmount = BigDecimal.ZERO;
            for (GeneralProductFop fop : AeroexpressTicketHelper.getClientFops((AeroexpressTicket)product)) {
                if (fop.getEquivalentAmount() == null) continue;
                clientFOPAmount = clientFOPAmount.add(fop.getEquivalentAmount());
                if (fop.getType() != null) {
                    if (GeneralProductHelper.isServiceFop((GeneralProductFop)fop)) {
                        clientFopTypes.add(fop.getType());
                    } else {
                        clientFeesFopTypes.add(fop.getType());
                    }
                }
                if (fop.getOperationDate() == null) {
                    hasClientDebt = true;
                    continue;
                }
                if (date2 != null && !date2.before(fop.getOperationDate())) continue;
                date2 = fop.getOperationDate();
                agent = fop.getAgent();
            }
            data.setClientFopAmount(refund ? clientFOPAmount.negate() : clientFOPAmount);
            data.setClientFopTypes(clientFopTypes);
            data.setClientFeesFopTypes(clientFeesFopTypes);
            data.setDateOfClientPayment(date2);
            aggregator.aggregate(date2);
            data.setClientFopAgent(agent);
            aggregator.aggregate(agent);
            data.setHasClientDebt(Boolean.valueOf(hasClientDebt));
            HashSet<PaymentType> vendorFopTypes = new HashSet<PaymentType>();
            BigDecimal vendorFOPAmount = BigDecimal.ZERO;
            for (GeneralProductFop fop : AeroexpressTicketHelper.getVendorFops((AeroexpressTicket)product)) {
                if (fop.getEquivalentAmount() == null) continue;
                vendorFOPAmount = vendorFOPAmount.add(fop.getEquivalentAmount());
                if (fop.getType() == null) continue;
                vendorFopTypes.add(fop.getType());
            }
            data.setVendorFopAmount(refund ? vendorFOPAmount.negate() : vendorFOPAmount);
            data.setVendorFopTypes(vendorFopTypes);
            HashSet<PaymentType> subagentFopTypes = new HashSet<PaymentType>();
            HashSet<PaymentType> subagentFeesFopTypes = new HashSet<PaymentType>();
            List subagentFops = AeroexpressTicketHelper.getSubagentFops((AeroexpressTicket)product, (boolean)false);
            if (subagentFops != null) {
                for (GeneralProductFop fop : subagentFops) {
                    if (fop.getType() == null) continue;
                    if (GeneralProductHelper.isServiceFop((GeneralProductFop)fop)) {
                        subagentFopTypes.add(fop.getType());
                        continue;
                    }
                    subagentFeesFopTypes.add(fop.getType());
                }
            }
            data.setSubagentFopTypes(subagentFopTypes);
            data.setSubagentFeesFopTypes(subagentFeesFopTypes);
            String notes = product.getReservation().getBookingFile().getNotes();
            data.setHasNotes(Boolean.valueOf(notes != null && !notes.trim().isEmpty()));
            data.setAgentPenaltyForProduct(BookingHelper.calculateAgentPenaltyForProduct((BaseProduct)product));
            data.setAgentPenaltyForCommissions(null);
            data.setAgentPenaltyForFees(BookingHelper.calculateAgentPenaltyForFees((BaseProduct)product));
        }
        boolean inFinanceDocuments = IndexBuilderHelper.isInFinanceDocuments((BaseProduct)product);
        data.setInFinanceDocuments(Boolean.valueOf(inFinanceDocuments));
        boolean inDelivery = IndexBuilderHelper.isInDelivery((BaseProduct)product);
        data.setInDelivery(Boolean.valueOf(inDelivery));
        data.setGdsError(Boolean.valueOf(product.isGdsError()));
        List costCodes = StatisticsHelper.findCostCenterCostCodes((StatisticalData)product.getStatisticalData(), (EntityReference)product.getReservation().getBookingFile().getCustomerProfile());
        if (!costCodes.isEmpty()) {
            String value = IndexBuilderHelper.getCostCodesJoinValue(costCodes, CostCode::getValue);
            String localValue = IndexBuilderHelper.getCostCodesJoinValue(costCodes, CostCode::getLocalValue);
            String englishValue = IndexBuilderHelper.getCostCodesJoinValue(costCodes, CostCode::getEnglishValue);
            data.setCostCenter(value);
            data.setCostCenterLocalValue(localValue);
            data.setCostCenterEnglishValue(englishValue);
            aggregator.aggregate((Object)value);
            aggregator.aggregate((Object)localValue);
            aggregator.aggregate((Object)englishValue);
            data.setCostCenterList(IndexBuilderHelper.getCostCodeValues(costCodes, CostCode::getValue));
            data.setCostCenterLocalValueList(IndexBuilderHelper.getCostCodeValues(costCodes, CostCode::getLocalValue));
            data.setCostCenterEnglishValueList(IndexBuilderHelper.getCostCodeValues(costCodes, CostCode::getEnglishValue));
        }
        if (product.getStatus() == ProductStatus.REFUND && product.getPreviousProduct() != null && product.getPreviousProduct().getStatus() == ProductStatus.SELL) {
            data.setSaleDate(product.getPreviousProduct().getIssueDate());
        }
        if (product.getStatus() == ProductStatus.SELL && product.getNextProduct() != null && product.getNextProduct().getStatus() == ProductStatus.REFUND) {
            data.setRefundDate(product.getNextProduct().getIssueDate());
        }
        data.setVersion(Integer.valueOf(1));
        String comments = TextUtil.getFieldOrTrimToLength((String)product.getComments(), (int)255);
        data.setComments(comments);
        aggregator.aggregate((Object)comments);
    }
}

