/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.model.index;

import com.gridnine.xtrip.common.model.EntityContainer;
import com.gridnine.xtrip.common.model.EntityReference;
import com.gridnine.xtrip.common.model.booking.BaseProduct;
import com.gridnine.xtrip.common.model.booking.BookingFile;
import com.gridnine.xtrip.common.model.booking.CommonProductIndex;
import com.gridnine.xtrip.common.model.booking.CommonProductIndexData;
import com.gridnine.xtrip.common.model.booking.FopComponent;
import com.gridnine.xtrip.common.model.booking.OperationBatch;
import com.gridnine.xtrip.common.model.booking.ProductStatus;
import com.gridnine.xtrip.common.model.booking.Reservation;
import com.gridnine.xtrip.common.model.booking.TravelSubject;
import com.gridnine.xtrip.common.model.booking.agencymemo.AgencyMemoProduct;
import com.gridnine.xtrip.common.model.booking.agencymemo.AgencyMemoProductEntryType;
import com.gridnine.xtrip.common.model.booking.agencymemo.AgencyMemoProductRelatedProductGroup;
import com.gridnine.xtrip.common.model.booking.agencymemo.AgencyMemoProductType;
import com.gridnine.xtrip.common.model.booking.commission.ProductType;
import com.gridnine.xtrip.common.model.dict.Airline;
import com.gridnine.xtrip.common.model.dict.CommunicationType;
import com.gridnine.xtrip.common.model.dict.ContractType;
import com.gridnine.xtrip.common.model.dict.DictionaryCache;
import com.gridnine.xtrip.common.model.dict.ProfileGroupReference;
import com.gridnine.xtrip.common.model.entity.EntityStorage;
import com.gridnine.xtrip.common.model.finance.FinanceDocument;
import com.gridnine.xtrip.common.model.helpers.AgencyMemoProductHelper;
import com.gridnine.xtrip.common.model.helpers.BookingHelper;
import com.gridnine.xtrip.common.model.helpers.GeneralProductHelper;
import com.gridnine.xtrip.common.model.profile.Communication;
import com.gridnine.xtrip.common.model.profile.Contract;
import com.gridnine.xtrip.common.model.profile.Organization;
import com.gridnine.xtrip.common.model.profile.Person;
import com.gridnine.xtrip.common.model.system.MetadataKey;
import com.gridnine.xtrip.common.util.CollectionUtil;
import com.gridnine.xtrip.common.util.CompositeNumber;
import com.gridnine.xtrip.common.util.MiscUtil;
import com.gridnine.xtrip.common.util.TextUtil;
import com.gridnine.xtrip.server.db.storage.model.BaseIndexData;
import com.gridnine.xtrip.server.db.storage.model.DataAggregator;
import com.gridnine.xtrip.server.db.storage.model.IndexHandler;
import com.gridnine.xtrip.server.model.handlers.ServerHandlersRegistry;
import com.gridnine.xtrip.server.model.handlers.index.CommonIndexHandler;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AgencyMemoCommonProductIndexHandler
implements IndexHandler<BookingFile, CommonProductIndex> {
    Logger log = LoggerFactory.getLogger(this.getClass());

    public Class<? extends BaseIndexData<BookingFile, CommonProductIndex>> getDataClass() {
        return CommonProductIndexData.class;
    }

    public Class<CommonProductIndex> getIndexClass() {
        return CommonProductIndex.class;
    }

    public Class<BookingFile> getEntityType() {
        return BookingFile.class;
    }

    public void create(EntityContainer<BookingFile> etc, Collection<BaseIndexData<BookingFile, CommonProductIndex>> indexes) {
        DataAggregator aggregator = new DataAggregator();
        for (Reservation reservation : ((BookingFile)etc.getEntity()).getReservations()) {
            for (BaseProduct baseProduct : reservation.getProducts()) {
                if (!(baseProduct instanceof AgencyMemoProduct)) continue;
                AgencyMemoProduct product = (AgencyMemoProduct)baseProduct;
                if (product.getRelatedProductGroups().size() > 0) {
                    for (AgencyMemoProductRelatedProductGroup relatedProductGroup : product.getRelatedProductGroups()) {
                        aggregator.reset();
                        try {
                            CommonProductIndexData data = new CommonProductIndexData();
                            List list = ServerHandlersRegistry.get().findCommonIndexHandlers(this.getIndexClass());
                            for (CommonIndexHandler<AgencyMemoProduct, BookingFile, CommonProductIndex> commonIndexHandler : list) {
                                commonIndexHandler.updateData((BaseIndexData<BookingFile, CommonProductIndex>)data, aggregator, etc, product);
                            }
                            this.updateProductData(data, aggregator, etc, product);
                            this.updateRelatedProductGroupData(data, aggregator, etc, relatedProductGroup, product);
                            data.setAggregatedData(aggregator.toString());
                            indexes.add((BaseIndexData<BookingFile, CommonProductIndex>)data);
                        }
                        catch (Exception e) {
                            this.log.error("unable to create index", (Throwable)e);
                        }
                    }
                    continue;
                }
                aggregator.reset();
                try {
                    CommonProductIndexData data = new CommonProductIndexData();
                    List handlers = ServerHandlersRegistry.get().findCommonIndexHandlers(this.getIndexClass());
                    for (CommonIndexHandler<AgencyMemoProduct, BookingFile, CommonProductIndex> commonIndexHandler : handlers) {
                        commonIndexHandler.updateData((BaseIndexData<BookingFile, CommonProductIndex>)data, aggregator, etc, product);
                    }
                    this.updateProductData(data, aggregator, etc, product);
                    data.setAggregatedData(aggregator.toString());
                    indexes.add((BaseIndexData<BookingFile, CommonProductIndex>)data);
                }
                catch (Exception e) {
                    this.log.error("unable to create index", (Throwable)e);
                }
            }
        }
    }

    protected void updateProductData(CommonProductIndexData data, DataAggregator aggregator, EntityContainer<BookingFile> etc, AgencyMemoProduct product) {
        data.setNavigationKey(product.getUid());
        data.setReservationType(product.getReservation().getType());
        data.setReservationStatus(product.getReservation().getStatus());
        aggregator.aggregate((Enum)product.getReservation().getStatus());
        data.setStatus(ProductStatus.SELL);
        aggregator.aggregate((Enum)ProductStatus.SELL);
        data.setTicketType(product.getTicketType());
        aggregator.aggregate((Enum)product.getTicketType());
        data.setBookingNumber(TextUtil.buildFullNumber((CompositeNumber)product.getReservation().getBookingFile()));
        aggregator.aggregate((Object)TextUtil.buildFullNumber((CompositeNumber)product.getReservation().getBookingFile()));
        data.setBookingCreateDate(product.getReservation().getBookingFile().getCreateDate());
        aggregator.aggregate(product.getReservation().getBookingFile().getCreateDate());
        data.setTimeLimit(product.getReservation().getTimeLimit());
        aggregator.aggregate(product.getReservation().getTimeLimit());
        data.setProductType(ProductType.AGENCY_MEMO_PRODUCT);
        data.setDescription(ProductType.AGENCY_MEMO_PRODUCT.toString());
        data.setTravelSubject(TravelSubject.OTHER);
        EntityReference clientRelationMediator = GeneralProductHelper.getClientRelationMediator((BaseProduct)product);
        data.setMediator(clientRelationMediator);
        aggregator.aggregate((Object)clientRelationMediator);
        if (product.getReservation().getBookingFile().getCustomerProfile() != null) {
            data.setClient(product.getReservation().getBookingFile().getCustomerProfile());
            aggregator.aggregate((Object)product.getReservation().getBookingFile().getCustomerProfile());
            try {
                EntityContainer clientContainer = EntityStorage.get().resolve(product.getReservation().getBookingFile().getCustomerProfile());
                if (clientContainer != null) {
                    Organization client = (Organization)clientContainer.getEntity();
                    ArrayList<ProfileGroupReference> clientGroups = new ArrayList<ProfileGroupReference>();
                    for (Object metadata : client.getMetadata()) {
                        if (metadata.getKey() == null || !metadata.getKey().getCode().equals(MetadataKey.KEY_ORGANIZATION_PROFILE_GROUP.name()) || metadata.getValue() == null) continue;
                        clientGroups.add((ProfileGroupReference)metadata.getValue());
                    }
                    data.setClientGroups(clientGroups);
                    aggregator.aggregate(clientGroups);
                }
            }
            catch (Throwable e) {
                this.log.error("unable to resolve client", e);
            }
        }
        data.setBlankOwner(product.getBlankOwner());
        aggregator.aggregate((Object)product.getBlankOwner());
        if (product.getBlankOwner() != null) {
            try {
                EntityContainer blankOwnerContainer = EntityStorage.get().resolve(product.getBlankOwner());
                if (blankOwnerContainer != null) {
                    Organization blankOwner = (Organization)blankOwnerContainer.getEntity();
                    Airline airline = (Airline)DictionaryCache.get().resolveReference(blankOwner.getAirline());
                    if (airline != null) {
                        data.setBlankOwnerAirlineNumber(airline.getAirlineNumber());
                    }
                    data.setBlankOwnerCode(blankOwner.getCode());
                    data.setProviderCode(blankOwner.getCode());
                    aggregator.aggregate((Object)blankOwner.getCode());
                }
            }
            catch (Exception e) {
                this.log.error("unable to resolve blank owner", (Throwable)e);
            }
            data.setProviderName(product.getBlankOwner().toString());
        }
        data.setAgency(product.getAgency());
        aggregator.aggregate((Object)product.getAgency());
        List subagentFops = GeneralProductHelper.getSubagentFops((BaseProduct)product);
        if (!subagentFops.isEmpty()) {
            data.setSubagency(product.getAgency());
        }
        data.setSupplier(product.getSupplier());
        aggregator.aggregate((Object)product.getSupplier());
        data.setIssueDate(product.getTargetReportDate());
        data.setIssueDateTime(product.getTargetReportDate());
        data.setLocalIssueDate(product.getLocalIssueDate());
        data.setUnholdDate(null);
        data.setUnholdDateTime(null);
        ArrayList<String> systemNumbers = new ArrayList<String>();
        if (!TextUtil.isBlank((String)product.getSystemNumber())) {
            systemNumbers.add(product.getSystemNumber());
        }
        data.setSystemNumbers(systemNumbers);
        aggregator.aggregate(systemNumbers);
        data.setFirstSystemNumber((String)CollectionUtil.head(systemNumbers));
        data.setSystemNumberPrefix(product.getAirlineCode());
        aggregator.aggregate((Object)product.getAirlineCode());
        data.setChecked(Boolean.valueOf(product.isChecked()));
        data.setCompleted(Boolean.valueOf(product.isCompleted()));
        String notes = product.getReservation().getBookingFile().getNotes();
        data.setHasNotes(Boolean.valueOf(notes != null && !notes.trim().isEmpty()));
        StringBuilder email = new StringBuilder();
        if (product.getReservation().getBookingFile() != null && product.getReservation().getBookingFile().getCustomer() != null) {
            for (Communication c : product.getReservation().getBookingFile().getCustomer().getCommunications()) {
                if (c == null || !CommunicationType.EMAIL.equals((Object)c.getType()) || TextUtil.isBlank((String)c.getSense())) continue;
                email = email.append(email.length() > 0 ? ", " + c.getSense() : c.getSense());
            }
        }
        if (!TextUtil.isBlank((String)email.toString())) {
            data.setEmail(TextUtil.adjustStringToLimit((String)email.toString(), (String)", ", (int)255));
            aggregator.aggregate((Object)email.toString());
        }
        Set shipments = product.getFopDetalizations().values().stream().flatMap(item -> item.getComponents().stream()).map(FopComponent::getShipment).filter(Objects::nonNull).collect(Collectors.toSet());
        data.setShipments(shipments);
        aggregator.aggregate(shipments);
        data.setShipmentsDate(product.getShipmentsDate());
        data.setShipmentsDateSubagent(product.getShipmentsDateSubagent());
        data.setFopComponentsAllUsed(Boolean.valueOf(product.getFopDetalizations().values().stream().flatMap(item -> item.getComponents().stream()).allMatch(item -> item.getShipment() != null)));
        String comments = TextUtil.getFieldOrTrimToLength((String)product.getComments(), (int)255);
        data.setComments(comments);
        aggregator.aggregate((Object)comments);
        EntityReference clientPrepaymentDocument = null;
        EntityReference subagentPrepaymentDocument = null;
        for (EntityReference prepaymentDocumentReference : product.getPrepaymentDocuments()) {
            EntityContainer contract;
            EntityContainer prepaymentDocument = EntityStorage.get().resolve(prepaymentDocumentReference);
            if (prepaymentDocument == null || (contract = EntityStorage.get().resolve(((FinanceDocument)prepaymentDocument.getEntity()).getContract())) == null) continue;
            if (((Contract)contract.getEntity()).getContractType() == ContractType.CLIENT) {
                clientPrepaymentDocument = prepaymentDocumentReference;
                continue;
            }
            if (((Contract)contract.getEntity()).getContractType() != ContractType.SUBAGENCY) continue;
            subagentPrepaymentDocument = prepaymentDocumentReference;
        }
        data.setClientPrepaymentDocument(clientPrepaymentDocument);
        data.setSubagentPrepaymentDocument(subagentPrepaymentDocument);
        aggregator.aggregate(clientPrepaymentDocument);
        aggregator.aggregate(subagentPrepaymentDocument);
        Set receipts = product.getFopDetalizations().values().stream().flatMap(fopDetalization -> fopDetalization.getComponents().stream()).map(FopComponent::getReceipt).collect(Collectors.toSet());
        data.setReceipts(receipts);
        OperationBatch batch = BookingHelper.getOperationBatch((BaseProduct)product);
        data.setOperationBatch(batch);
        aggregator.aggregate((Enum)batch);
        AgencyMemoProductType type = product.getType();
        HashSet<AgencyMemoProductEntryType> totalEntryTypes = new HashSet<AgencyMemoProductEntryType>(Arrays.asList(AgencyMemoProductEntryType.values()));
        totalEntryTypes.remove(AgencyMemoProductEntryType.COMMISSION);
        totalEntryTypes.remove(AgencyMemoProductEntryType.FEE);
        totalEntryTypes.remove(AgencyMemoProductEntryType.BONUS);
        BigDecimal totalSum = AgencyMemoProductHelper.calculateItemGroupsEquivalentAmount((Collection)AgencyMemoProductHelper.filterItemGroups((Collection)product.getItemGroups(), totalEntryTypes));
        BigDecimal equivalentFare = AgencyMemoProductHelper.calculateItemGroupsEquivalentAmount((Collection)AgencyMemoProductHelper.filterItemGroups((Collection)product.getItemGroups(), (Set)AgencyMemoProductHelper.tariffEntryTypes));
        BigDecimal taxesSum = AgencyMemoProductHelper.calculateItemGroupsEquivalentAmount((Collection)AgencyMemoProductHelper.filterItemGroups((Collection)product.getItemGroups(), (Set)AgencyMemoProductHelper.taxEntryTypes));
        BigDecimal penalty = AgencyMemoProductHelper.calculateItemGroupsEquivalentAmount((Collection)AgencyMemoProductHelper.filterItemGroups((Collection)product.getItemGroups(), (Set)AgencyMemoProductHelper.penaltyEntryTypes));
        BigDecimal contractPenaltyValue = AgencyMemoProductHelper.calculateItemGroupsEquivalentAmount((Collection)AgencyMemoProductHelper.filterItemGroups((Collection)product.getItemGroups(), (Set)AgencyMemoProductHelper.contractPenaltyEntryTypes));
        BigDecimal commissionValue = MiscUtil.negate((BigDecimal)AgencyMemoProductHelper.calculateItemGroupsEquivalentAmount((Collection)AgencyMemoProductHelper.filterItemGroups((Collection)product.getItemGroups(), (Set)AgencyMemoProductHelper.commissionEntryTypes)));
        BigDecimal feeValue = AgencyMemoProductHelper.calculateItemGroupsEquivalentAmount((Collection)AgencyMemoProductHelper.filterItemGroups((Collection)product.getItemGroups(), (Set)AgencyMemoProductHelper.feeEntryTypes));
        if (type != AgencyMemoProductType.ADM) {
            totalSum = MiscUtil.negate((BigDecimal)totalSum);
            equivalentFare = MiscUtil.negate((BigDecimal)equivalentFare);
            taxesSum = MiscUtil.negate((BigDecimal)taxesSum);
            penalty = MiscUtil.negate((BigDecimal)penalty);
            contractPenaltyValue = MiscUtil.negate((BigDecimal)contractPenaltyValue);
            commissionValue = MiscUtil.negate((BigDecimal)commissionValue);
            feeValue = MiscUtil.negate((BigDecimal)feeValue);
        }
        ContractType contractType = ContractType.CLIENT;
        EntityContainer contractContainer = EntityStorage.get().resolve((EntityReference)product.getContract());
        if (contractContainer != null && ((Contract)contractContainer.getEntity()).getContractType() != null) {
            contractType = ((Contract)contractContainer.getEntity()).getContractType();
        }
        if (contractType == ContractType.VENDOR) {
            data.setVendorCommissionValue(commissionValue);
            data.setVendorFeeValue(feeValue);
            data.setVendorContractPenaltyValue(contractPenaltyValue);
        } else if (contractType == ContractType.SUBAGENCY) {
            data.setSubagencyCommissionValue(commissionValue);
            data.setSubagencyFeeValue(feeValue);
            data.setSubagencyContractPenaltyValue(contractPenaltyValue);
            data.setSubagency(product.getAgency());
            data.setSubagencyContractFare(equivalentFare);
            data.setSubagencyContractPenalty(penalty);
            data.setSubagencyContractTaxesForBlankSum(BigDecimal.ZERO);
            data.setSubagencyContractOtherTaxesSum(taxesSum);
            data.setSubagencyContractTotalSum(totalSum);
        } else if (contractType == ContractType.CLIENT) {
            data.setClientCommissionValue(commissionValue);
            data.setClientFeeValue(feeValue);
            data.setClientContractPenaltyValue(contractPenaltyValue);
        }
        data.setTotalSum(totalSum);
        data.setEquivalentFare(equivalentFare);
        data.setOtherTaxesSum(taxesSum);
        data.setPenalty(penalty);
        data.setSubagencyCommissionRate(GeneralProductHelper.calculateCommissionsRateAsDouble((Collection)GeneralProductHelper.filterCommissions((Collection)GeneralProductHelper.getUnmodifiableCommissions((BaseProduct)product, (ContractType)ContractType.SUBAGENCY), (Set)GeneralProductHelper.commissionCommissionPropertyTypes, (Set)GeneralProductHelper.standardCommissionTypes, null), (boolean)true));
        Set travellersGroups = GeneralProductHelper.getHandler((BaseProduct)product).getTravellers((BaseProduct)product).stream().map(item -> EntityStorage.get().resolve(item.getPassenger())).filter(item -> item != null).flatMap(item -> ((Person)item.getEntity()).getMetadata().stream()).filter(item -> item.getKey() != null && item.getValue() != null && MiscUtil.equals((Object)item.getKey().getCode(), (Object)MetadataKey.KEY_PERSON_PROFILE_GROUP.name())).map(item -> (ProfileGroupReference)item.getValue()).collect(Collectors.toSet());
        data.setTravellersGroups(travellersGroups);
        aggregator.aggregate(travellersGroups);
        Set agentsGroups = Optional.ofNullable(EntityStorage.get().resolve(GeneralProductHelper.getHandler((BaseProduct)product).findIssuingAgent((BaseProduct)product))).map(item -> ((Person)item.getEntity()).getMetadata()).orElse(Collections.emptyList()).stream().filter(item -> item.getKey() != null && item.getValue() != null && MiscUtil.equals((Object)item.getKey().getCode(), (Object)MetadataKey.KEY_PERSON_PROFILE_GROUP.name())).map(item -> (ProfileGroupReference)item.getValue()).collect(Collectors.toSet());
        data.setAgentsGroups(agentsGroups);
        aggregator.aggregate(agentsGroups);
    }

    private void updateRelatedProductGroupData(CommonProductIndexData data, DataAggregator aggregator, EntityContainer<BookingFile> etc, AgencyMemoProductRelatedProductGroup relatedProductGroup, AgencyMemoProduct product) {
        AgencyMemoProductType type;
        data.setRelatedTicketNo(relatedProductGroup.getRelatedProductNumber());
        aggregator.aggregate((Object)relatedProductGroup.getRelatedProductNumber());
        data.setClient(relatedProductGroup.getClient());
        aggregator.aggregate((Object)relatedProductGroup.getClient());
        EntityReference clientRelationMediator = GeneralProductHelper.getClientRelationMediator((BaseProduct)product);
        data.setMediator(clientRelationMediator);
        aggregator.aggregate((Object)clientRelationMediator);
        data.setSubagency(relatedProductGroup.getSubagency());
        aggregator.aggregate((Object)relatedProductGroup.getSubagency());
        data.setSalesPoint(relatedProductGroup.getSalesPoint());
        aggregator.aggregate((Object)relatedProductGroup.getSalesPoint());
        data.setAgent(relatedProductGroup.getAgent());
        aggregator.aggregate((Object)relatedProductGroup.getAgent());
        HashSet<AgencyMemoProductEntryType> totalEntryTypes = new HashSet<AgencyMemoProductEntryType>(Arrays.asList(AgencyMemoProductEntryType.values()));
        totalEntryTypes.remove(AgencyMemoProductEntryType.COMMISSION);
        totalEntryTypes.remove(AgencyMemoProductEntryType.FEE);
        totalEntryTypes.remove(AgencyMemoProductEntryType.BONUS);
        BigDecimal totalSum = AgencyMemoProductHelper.calculateEntriesEquivalentAmount((Collection)AgencyMemoProductHelper.filterEntries((Collection)relatedProductGroup.getEntries(), totalEntryTypes, null, null));
        BigDecimal equivalentFare = AgencyMemoProductHelper.calculateEntriesEquivalentAmount((Collection)AgencyMemoProductHelper.filterEntries((Collection)relatedProductGroup.getEntries(), (Set)AgencyMemoProductHelper.tariffEntryTypes, null, null));
        BigDecimal taxesSum = AgencyMemoProductHelper.calculateEntriesEquivalentAmount((Collection)AgencyMemoProductHelper.filterEntries((Collection)relatedProductGroup.getEntries(), (Set)AgencyMemoProductHelper.taxEntryTypes, null, null));
        BigDecimal penalty = AgencyMemoProductHelper.calculateEntriesEquivalentAmount((Collection)AgencyMemoProductHelper.filterEntries((Collection)relatedProductGroup.getEntries(), (Set)AgencyMemoProductHelper.penaltyEntryTypes, null, null));
        BigDecimal commissionValue = MiscUtil.negate((BigDecimal)AgencyMemoProductHelper.calculateEntriesEquivalentAmount((Collection)AgencyMemoProductHelper.filterEntries((Collection)relatedProductGroup.getEntries(), (Set)AgencyMemoProductHelper.commissionEntryTypes, null, null)));
        BigDecimal bonusValue = MiscUtil.negate((BigDecimal)AgencyMemoProductHelper.calculateEntriesEquivalentAmount((Collection)AgencyMemoProductHelper.filterEntries((Collection)relatedProductGroup.getEntries(), (Set)AgencyMemoProductHelper.bonusEntryTypes, null, null)));
        BigDecimal feeValue = AgencyMemoProductHelper.calculateEntriesEquivalentAmount((Collection)AgencyMemoProductHelper.filterEntries((Collection)relatedProductGroup.getEntries(), (Set)AgencyMemoProductHelper.feeEntryTypes, null, null));
        BigDecimal contractPenaltyValue = AgencyMemoProductHelper.calculateEntriesEquivalentAmount((Collection)AgencyMemoProductHelper.filterEntries((Collection)relatedProductGroup.getEntries(), (Set)AgencyMemoProductHelper.contractPenaltyEntryTypes, null, null));
        ContractType contractType = ContractType.CLIENT;
        EntityContainer contractContainer = EntityStorage.get().resolve((EntityReference)product.getContract());
        if (contractContainer != null && ((Contract)contractContainer.getEntity()).getContractType() != null) {
            contractType = ((Contract)contractContainer.getEntity()).getContractType();
        }
        if ((type = product.getType()) != AgencyMemoProductType.ADM) {
            totalSum = MiscUtil.negate((BigDecimal)totalSum);
            equivalentFare = MiscUtil.negate((BigDecimal)equivalentFare);
            taxesSum = MiscUtil.negate((BigDecimal)taxesSum);
            penalty = MiscUtil.negate((BigDecimal)penalty);
            commissionValue = MiscUtil.negate((BigDecimal)commissionValue);
            bonusValue = MiscUtil.negate((BigDecimal)bonusValue);
            feeValue = MiscUtil.negate((BigDecimal)feeValue);
            contractPenaltyValue = MiscUtil.negate((BigDecimal)contractPenaltyValue);
        }
        data.setTotalSum(totalSum);
        data.setEquivalentFare(equivalentFare);
        data.setTaxesSum(taxesSum);
        data.setOtherTaxesSum(taxesSum);
        data.setPenalty(penalty);
        if (contractType == ContractType.VENDOR) {
            data.setVendorCommissionValue(commissionValue);
            data.setVendorBonusValue(bonusValue);
            data.setVendorFeeValue(feeValue);
            data.setVendorContractPenaltyValue(contractPenaltyValue);
        } else if (contractType == ContractType.SUBAGENCY) {
            data.setSubagencyCommissionValue(commissionValue);
            data.setSubagencyBonusValue(bonusValue);
            data.setSubagencyFeeValue(feeValue);
            data.setSubagencyContractPenaltyValue(contractPenaltyValue);
            data.setSubagencyContractFare(equivalentFare);
            data.setSubagencyContractPenalty(penalty);
            data.setSubagencyContractTaxesForBlankSum(BigDecimal.ZERO);
            data.setSubagencyContractOtherTaxesSum(taxesSum);
            data.setSubagencyContractTotalSum(totalSum);
        } else if (contractType == ContractType.CLIENT) {
            data.setClientCommissionValue(commissionValue);
            data.setClientBonusValue(bonusValue);
            data.setClientFeeValue(feeValue);
            data.setClientServiceFeeValue(feeValue);
            data.setClientContractPenaltyValue(contractPenaltyValue);
        }
    }
}

