/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.model.index;

import com.gridnine.xtrip.common.model.EntityContainer;
import com.gridnine.xtrip.common.model.EntityReference;
import com.gridnine.xtrip.common.model.booking.BaseProduct;
import com.gridnine.xtrip.common.model.booking.BookingFile;
import com.gridnine.xtrip.common.model.booking.Reservation;
import com.gridnine.xtrip.common.model.booking.StatisticalData;
import com.gridnine.xtrip.common.model.booking.ValidationMessage;
import com.gridnine.xtrip.common.model.booking.ValidationMessageCategory;
import com.gridnine.xtrip.common.model.booking.ValidationMessageSeverity;
import com.gridnine.xtrip.common.model.booking.agencymemo.AgencyMemoProduct;
import com.gridnine.xtrip.common.model.booking.agencymemo.AgencyMemoProductIndex;
import com.gridnine.xtrip.common.model.booking.agencymemo.AgencyMemoProductIndexData;
import com.gridnine.xtrip.common.model.dict.ContractType;
import com.gridnine.xtrip.common.model.entity.EntityStorage;
import com.gridnine.xtrip.common.model.helpers.AgencyMemoProductHelper;
import com.gridnine.xtrip.common.model.helpers.StatisticsHelper;
import com.gridnine.xtrip.common.model.profile.Contract;
import com.gridnine.xtrip.common.model.profile.CostCode;
import com.gridnine.xtrip.common.util.CompositeNumber;
import com.gridnine.xtrip.common.util.TextUtil;
import com.gridnine.xtrip.server.db.storage.model.BaseIndexData;
import com.gridnine.xtrip.server.db.storage.model.DataAggregator;
import com.gridnine.xtrip.server.db.storage.model.IndexHandler;
import com.gridnine.xtrip.server.model.helpers.IndexBuilderHelper;
import java.math.BigDecimal;
import java.util.Collection;
import java.util.List;

public class AgencyMemoProductIndexHandler
implements IndexHandler<BookingFile, AgencyMemoProductIndex> {
    public Class<? extends BaseIndexData<BookingFile, AgencyMemoProductIndex>> getDataClass() {
        return AgencyMemoProductIndexData.class;
    }

    public Class<AgencyMemoProductIndex> getIndexClass() {
        return AgencyMemoProductIndex.class;
    }

    public Class<BookingFile> getEntityType() {
        return BookingFile.class;
    }

    public void create(EntityContainer<BookingFile> etc, Collection<BaseIndexData<BookingFile, AgencyMemoProductIndex>> indexes) {
        for (Reservation reservation : ((BookingFile)etc.getEntity()).getReservations()) {
            DataAggregator aggregator = new DataAggregator();
            for (BaseProduct baseProduct : reservation.getProducts()) {
                if (!(baseProduct instanceof AgencyMemoProduct)) continue;
                AgencyMemoProduct product = (AgencyMemoProduct)baseProduct;
                AgencyMemoProductIndexData data = new AgencyMemoProductIndexData();
                this.updateFromProduct(data, aggregator, product);
                data.setAggregatedData(aggregator.toString());
                indexes.add((BaseIndexData<BookingFile, AgencyMemoProductIndex>)data);
                aggregator.reset();
            }
        }
    }

    private void updateFromProduct(AgencyMemoProductIndexData data, DataAggregator aggregator, AgencyMemoProduct product) {
        data.setNavigationKey(product.getUid());
        data.setTicketType(product.getTicketType());
        String bookingNumber = TextUtil.buildFullNumber((CompositeNumber)product.getReservation().getBookingFile());
        data.setBookingNumber(bookingNumber);
        data.setBlankOwner(product.getBlankOwner());
        data.setSupplier(product.getSupplier());
        data.setAgency(product.getAgency());
        data.setAirlineCode(product.getAirlineCode());
        data.setSystemNumber(product.getSystemNumber());
        data.setType(product.getType());
        data.setIssueDate(product.getIssueDate());
        data.setAcceptDate(product.getAcceptDate());
        data.setSourceReportDate(product.getSourceReportDate());
        data.setTargetReportDate(product.getTargetReportDate());
        data.setChecked(Boolean.valueOf(product.isChecked()));
        data.setCompleted(Boolean.valueOf(product.isCompleted()));
        data.setIncludeToReport(Boolean.valueOf(product.isIncludeToReport()));
        boolean hasOtherErrors = false;
        for (ValidationMessage message : product.getValidationMessages()) {
            if (message.getSeverity() != ValidationMessageSeverity.ERROR) continue;
            data.setHasErrors(Boolean.valueOf(true));
            if (message.getCategory() != ValidationMessageCategory.OTHER) continue;
            hasOtherErrors = true;
        }
        data.setHasOtherErrors(Boolean.valueOf(hasOtherErrors));
        ContractType type = ContractType.CLIENT;
        EntityContainer contractContainer = EntityStorage.get().resolve((EntityReference)product.getContract());
        if (contractContainer != null && ((Contract)contractContainer.getEntity()).getContractType() != null) {
            type = ((Contract)contractContainer.getEntity()).getContractType();
        }
        BigDecimal equivalentAmount = AgencyMemoProductHelper.calculateItemGroupsEquivalentAmount((Collection)AgencyMemoProductHelper.filterItemGroups((Collection)product.getItemGroups(), null));
        if (type == ContractType.VENDOR) {
            data.setVendorEquivalentAmount(equivalentAmount);
        } else if (type == ContractType.SUBAGENCY) {
            data.setSubagentEquivalentAmount(equivalentAmount);
        } else if (type == ContractType.CLIENT) {
            data.setClientEquivalentAmount(equivalentAmount);
        }
        List costCodes = StatisticsHelper.findCostCenterCostCodes((StatisticalData)product.getStatisticalData(), (EntityReference)product.getReservation().getBookingFile().getCustomerProfile());
        if (!costCodes.isEmpty()) {
            String value = IndexBuilderHelper.getCostCodesJoinValue(costCodes, CostCode::getValue);
            String localValue = IndexBuilderHelper.getCostCodesJoinValue(costCodes, CostCode::getLocalValue);
            String englishValue = IndexBuilderHelper.getCostCodesJoinValue(costCodes, CostCode::getEnglishValue);
            data.setCostCenter(value);
            data.setCostCenterLocalValue(localValue);
            data.setCostCenterEnglishValue(englishValue);
            aggregator.aggregate((Object)value);
            aggregator.aggregate((Object)localValue);
            aggregator.aggregate((Object)englishValue);
            data.setCostCenterList(IndexBuilderHelper.getCostCodeValues(costCodes, CostCode::getValue));
            data.setCostCenterLocalValueList(IndexBuilderHelper.getCostCodeValues(costCodes, CostCode::getLocalValue));
            data.setCostCenterEnglishValueList(IndexBuilderHelper.getCostCodeValues(costCodes, CostCode::getEnglishValue));
        }
        aggregator.aggregate((Enum)product.getTicketType());
        aggregator.aggregate((Object)bookingNumber);
        aggregator.aggregate((Object)product.getBlankOwner());
        aggregator.aggregate((Object)product.getSupplier());
        aggregator.aggregate((Object)product.getAgency());
        aggregator.aggregate((Object)product.getSystemNumber());
        aggregator.aggregate((Enum)product.getType());
        String comments = TextUtil.getFieldOrTrimToLength((String)product.getComments(), (int)255);
        data.setComments(comments);
        aggregator.aggregate((Object)comments);
    }
}

