/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.model.index;

import com.gridnine.xtrip.common.model.EntityContainer;
import com.gridnine.xtrip.common.model.EntityReference;
import com.gridnine.xtrip.common.model.booking.BaseProduct;
import com.gridnine.xtrip.common.model.booking.BookingFile;
import com.gridnine.xtrip.common.model.booking.Reservation;
import com.gridnine.xtrip.common.model.booking.agencymemo.AgencyMemoProduct;
import com.gridnine.xtrip.common.model.booking.agencymemo.AgencyMemoProductEntryType;
import com.gridnine.xtrip.common.model.booking.agencymemo.AgencyMemoProductItemGroup;
import com.gridnine.xtrip.common.model.booking.agencymemo.AgencyMemoProductItemGroupIndex;
import com.gridnine.xtrip.common.model.booking.agencymemo.AgencyMemoProductItemGroupIndexData;
import com.gridnine.xtrip.common.model.dict.ContractType;
import com.gridnine.xtrip.common.model.entity.EntityStorage;
import com.gridnine.xtrip.common.model.helpers.AgencyMemoProductHelper;
import com.gridnine.xtrip.common.model.profile.Contract;
import com.gridnine.xtrip.server.db.storage.model.BaseIndexData;
import com.gridnine.xtrip.server.db.storage.model.DataAggregator;
import com.gridnine.xtrip.server.db.storage.model.IndexHandler;
import java.math.BigDecimal;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

public class AgencyMemoProductItemGroupIndexHandler
implements IndexHandler<BookingFile, AgencyMemoProductItemGroupIndex> {
    public Class<? extends BaseIndexData<BookingFile, AgencyMemoProductItemGroupIndex>> getDataClass() {
        return AgencyMemoProductItemGroupIndexData.class;
    }

    public Class<AgencyMemoProductItemGroupIndex> getIndexClass() {
        return AgencyMemoProductItemGroupIndex.class;
    }

    public Class<BookingFile> getEntityType() {
        return BookingFile.class;
    }

    public void create(EntityContainer<BookingFile> etc, Collection<BaseIndexData<BookingFile, AgencyMemoProductItemGroupIndex>> indexes) {
        for (Reservation reservation : ((BookingFile)etc.getEntity()).getReservations()) {
            for (BaseProduct baseProduct : reservation.getProducts()) {
                if (!(baseProduct instanceof AgencyMemoProduct)) continue;
                AgencyMemoProduct product = (AgencyMemoProduct)baseProduct;
                this.updateData(product, indexes);
            }
        }
    }

    private void updateData(AgencyMemoProduct product, Collection<BaseIndexData<BookingFile, AgencyMemoProductItemGroupIndex>> indexes) {
        Map<AgencyMemoProductEntryType, List<AgencyMemoProductItemGroup>> itemGroupDatas = product.getItemGroups().stream().collect(Collectors.groupingBy(item -> item.getType()));
        DataAggregator aggregator = new DataAggregator();
        for (Map.Entry<AgencyMemoProductEntryType, List<AgencyMemoProductItemGroup>> entry : itemGroupDatas.entrySet()) {
            AgencyMemoProductEntryType type = entry.getKey();
            List<AgencyMemoProductItemGroup> entries = entry.getValue();
            AgencyMemoProductItemGroupIndexData data = new AgencyMemoProductItemGroupIndexData();
            data.setType(type);
            this.updateProductData(data, aggregator, product);
            this.updateItemGroupData(data, entries, product);
            data.setAggregatedData(aggregator.toString());
            indexes.add((BaseIndexData<BookingFile, AgencyMemoProductItemGroupIndex>)data);
            aggregator.reset();
        }
    }

    private void updateProductData(AgencyMemoProductItemGroupIndexData data, DataAggregator aggregator, AgencyMemoProduct product) {
        data.setNavigationKey(product.getUid());
        data.setBlankOwner(product.getBlankOwner());
        data.setSupplier(product.getSupplier());
        data.setAgency(product.getAgency());
        data.setAirlineCode(product.getAirlineCode());
        data.setSystemNumber(product.getSystemNumber());
        data.setAgencyMemoType(product.getType());
        data.setIssueDate(product.getIssueDate());
        data.setAcceptDate(product.getAcceptDate());
        data.setSourceReportDate(product.getSourceReportDate());
        data.setTargetReportDate(product.getTargetReportDate());
        aggregator.aggregate((Object)product.getBlankOwner());
        aggregator.aggregate((Object)product.getSupplier());
        aggregator.aggregate((Object)product.getAgency());
        aggregator.aggregate((Object)product.getSystemNumber());
        aggregator.aggregate((Enum)product.getType());
    }

    private void updateItemGroupData(AgencyMemoProductItemGroupIndexData data, List<AgencyMemoProductItemGroup> entries, AgencyMemoProduct product) {
        ContractType contractType = ContractType.CLIENT;
        EntityContainer contractContainer = EntityStorage.get().resolve((EntityReference)product.getContract());
        if (contractContainer != null && ((Contract)contractContainer.getEntity()).getContractType() != null) {
            contractType = ((Contract)contractContainer.getEntity()).getContractType();
        }
        BigDecimal equivalentAmount = AgencyMemoProductHelper.calculateItemGroupsEquivalentAmount(entries);
        if (contractType == ContractType.VENDOR) {
            data.setVendorEquivalentAmount(equivalentAmount);
        } else if (contractType == ContractType.SUBAGENCY) {
            data.setSubagentEquivalentAmount(equivalentAmount);
        } else if (contractType == ContractType.CLIENT) {
            data.setClientEquivalentAmount(equivalentAmount);
        }
    }
}

