/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.model.index;

import com.gridnine.xtrip.common.model.EntityContainer;
import com.gridnine.xtrip.common.model.EntityReference;
import com.gridnine.xtrip.common.model.booking.BaseProduct;
import com.gridnine.xtrip.common.model.booking.BookingFile;
import com.gridnine.xtrip.common.model.booking.CommonProductFopIndex;
import com.gridnine.xtrip.common.model.booking.CommonProductFopIndexData;
import com.gridnine.xtrip.common.model.booking.FopType;
import com.gridnine.xtrip.common.model.booking.MCOFees;
import com.gridnine.xtrip.common.model.booking.ProductStatus;
import com.gridnine.xtrip.common.model.booking.Reservation;
import com.gridnine.xtrip.common.model.booking.air.AirProductContractRelationData;
import com.gridnine.xtrip.common.model.booking.air.Product;
import com.gridnine.xtrip.common.model.booking.air.ProductFop;
import com.gridnine.xtrip.common.model.booking.air.Segment;
import com.gridnine.xtrip.common.model.booking.air.SegmentTariff;
import com.gridnine.xtrip.common.model.booking.commission.ProductType;
import com.gridnine.xtrip.common.model.dict.ContractType;
import com.gridnine.xtrip.common.model.entity.EntityStorage;
import com.gridnine.xtrip.common.model.handlers.ProductStatusHandler;
import com.gridnine.xtrip.common.model.helpers.AirProductHelper;
import com.gridnine.xtrip.common.model.helpers.GeneralProductHelper;
import com.gridnine.xtrip.common.model.helpers.MCOFeesHelper;
import com.gridnine.xtrip.common.model.profile.Card;
import com.gridnine.xtrip.common.model.profile.Organization;
import com.gridnine.xtrip.common.model.system.CardVendor;
import com.gridnine.xtrip.common.util.CompositeNumber;
import com.gridnine.xtrip.common.util.FormattedNumberUtil;
import com.gridnine.xtrip.common.util.TextUtil;
import com.gridnine.xtrip.server.db.storage.model.BaseIndexData;
import com.gridnine.xtrip.server.db.storage.model.DataAggregator;
import com.gridnine.xtrip.server.db.storage.model.IndexHandler;
import com.gridnine.xtrip.server.model.helpers.IndexBuilderHelper;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AirCommonProductFopIndexHandler
implements IndexHandler<BookingFile, CommonProductFopIndex> {
    protected Logger log = LoggerFactory.getLogger(this.getClass());

    public Class<? extends BaseIndexData<BookingFile, CommonProductFopIndex>> getDataClass() {
        return CommonProductFopIndexData.class;
    }

    public Class<CommonProductFopIndex> getIndexClass() {
        return CommonProductFopIndex.class;
    }

    public Class<BookingFile> getEntityType() {
        return BookingFile.class;
    }

    public void create(EntityContainer<BookingFile> bookingFileContainer, Collection<BaseIndexData<BookingFile, CommonProductFopIndex>> datas) {
        for (Reservation reservation : ((BookingFile)bookingFileContainer.getEntity()).getReservations()) {
            for (BaseProduct baseProduct : reservation.getProducts()) {
                if (!(baseProduct instanceof Product)) continue;
                Product product = (Product)baseProduct;
                if (ProductStatusHandler.getAllVoidStatuses().contains(product.getStatus())) continue;
                this.updateData(datas, product);
            }
        }
    }

    protected void updateData(Collection<BaseIndexData<BookingFile, CommonProductFopIndex>> datas, Product product) {
        DataAggregator aggregator = new DataAggregator();
        for (AirProductContractRelationData contractRelation : AirProductHelper.getContractRelations((Product)product)) {
            ContractType ctype = GeneralProductHelper.getContractType((EntityReference)contractRelation.getDescription());
            for (ProductFop fop : contractRelation.getFops()) {
                CommonProductFopIndexData data = new CommonProductFopIndexData();
                this.updateProductData(data, aggregator, product);
                data.setContractType(ctype);
                this.updateFopData(data, aggregator, fop, product);
                if (ctype == ContractType.CLIENT) {
                    data.setRefuse(Boolean.valueOf(fop.isRefused()));
                    StringBuilder mcoFeesNumbers = new StringBuilder();
                    BigDecimal mcoFeesSum = BigDecimal.ZERO;
                    if (!AirProductHelper.isServiceFop((ProductFop)fop)) {
                        for (Reservation res : product.getReservation().getBookingFile().getReservations()) {
                            for (BaseProduct bp : res.getProducts()) {
                                MCOFees mcoFees;
                                if (!(bp instanceof MCOFees) || !MCOFeesHelper.getRelatedProductUids((MCOFees)(mcoFees = (MCOFees)bp)).contains(product.getUid()) || mcoFees.getTotal() == null) continue;
                                mcoFeesSum = mcoFeesSum.add(mcoFees.getTotal());
                                mcoFeesNumbers.append(mcoFeesNumbers.length() > 0 ? ", " + mcoFees.getScn() : mcoFees.getScn());
                            }
                        }
                        data.setMcoFeesNumbers(mcoFeesNumbers.toString());
                        data.setMcoFeesSum(mcoFeesSum);
                    }
                }
                data.setAggregatedData(aggregator.toString());
                aggregator.reset();
                datas.add((BaseIndexData<BookingFile, CommonProductFopIndex>)data);
            }
        }
    }

    protected void updateProductData(CommonProductFopIndexData data, DataAggregator aggregator, Product product) {
        data.setProductUid(product.getUid());
        String bookingNumber = TextUtil.buildFullNumber((CompositeNumber)product.getReservation().getBookingFile());
        data.setBookingNumber(bookingNumber);
        aggregator.aggregate((Object)bookingNumber);
        ProductType productType = AirProductHelper.getProductType((Product)product);
        data.setProductType(productType);
        aggregator.aggregate((Enum)productType);
        data.setClient(product.getReservation().getBookingFile().getCustomerProfile());
        aggregator.aggregate((Object)product.getReservation().getBookingFile().getCustomerProfile());
        data.setBlankOwner(product.getBlankOwnerRef());
        aggregator.aggregate((Object)product.getBlankOwnerRef());
        data.setSupplier(AirProductHelper.getSupplier((Product)product));
        aggregator.aggregate((Object)AirProductHelper.getSupplier((Product)product));
        data.setAgency(AirProductHelper.getAgency((Product)product));
        aggregator.aggregate((Object)AirProductHelper.getAgency((Product)product));
        data.setSubagency(AirProductHelper.getSubagency((Product)product));
        aggregator.aggregate((Object)AirProductHelper.getSubagency((Product)product));
        EntityContainer clientContainer = EntityStorage.get().resolve(product.getReservation().getBookingFile().getCustomerProfile());
        if (clientContainer != null) {
            data.setHolding(((Organization)clientContainer.getEntity()).getHolding());
            aggregator.aggregate((Object)((Organization)clientContainer.getEntity()).getHolding());
        }
        data.setBranch(product.getBranch());
        aggregator.aggregate((Object)product.getBranch());
        data.setSalesPoint(product.getSalesPoint());
        aggregator.aggregate((Object)product.getSalesPoint());
        data.setAgent(product.getCashier());
        aggregator.aggregate((Object)product.getCashier());
        data.setTicketType(product.getTicketType());
        aggregator.aggregate((Enum)product.getTicketType());
        IndexBuilderHelper.updateReservationGdsNameInfo(product.getReservation(), data, aggregator);
        data.setIssueDate(product.getIssueDate());
        data.setIssueDateTime(product.getIssueDate());
        data.setUnholdDate(null);
        data.setUnholdDateTime(null);
        data.setStatus(product.getStatus());
        aggregator.aggregate((Enum)product.getStatus());
        data.setBlankOwnerAirlineNumber(product.getBlankOwnerNumber());
        aggregator.aggregate((Object)product.getBlankOwnerNumber());
        try {
            EntityContainer ctr = EntityStorage.get().resolve(product.getBlankOwnerRef());
            if (ctr != null) {
                data.setBlankOwnerCode(((Organization)ctr.getEntity()).getCode());
                aggregator.aggregate((Object)((Organization)ctr.getEntity()).getCode());
            }
        }
        catch (Exception e) {
            this.log.error("unable to resolve blank owner", (Throwable)e);
        }
        data.setSystemNumberPrefix(product.getCarrierNumber());
        aggregator.aggregate((Object)product.getCarrierNumber());
        String systemNumber = product.getSystemNumber();
        ArrayList<String> systemNumbers = new ArrayList<String>();
        if (!TextUtil.isBlank((String)systemNumber)) {
            systemNumbers.add(systemNumber);
            for (int i = 0; i < product.getConjCount(); ++i) {
                try {
                    systemNumbers.add(FormattedNumberUtil.add((String)systemNumber, (long)(i + 1)));
                    continue;
                }
                catch (Exception e) {
                    this.log.error("unable to parse ticket number " + systemNumber, (Throwable)e);
                }
            }
        }
        data.setSystemNumbers(systemNumbers);
        aggregator.aggregate(systemNumbers);
        String routeLine = AirProductHelper.getLocalizedRouteLine((Product)product);
        routeLine = !TextUtil.isBlank((String)routeLine) && routeLine.length() > 255 ? "???" : routeLine;
        data.setRouteLine(routeLine);
        aggregator.aggregate((Object)routeLine);
        HashSet<String> travellersNames = new HashSet<String>();
        if (product.getTraveller() != null && product.getTraveller().getName() != null) {
            travellersNames.add(product.getTraveller().getName());
        }
        data.setTravellersNames(travellersNames);
        aggregator.aggregate(travellersNames);
        if (product.getSegmentTariffs().size() > 0) {
            Segment lastTravelSegment;
            SegmentTariff firstTravelSegmentTariff = (SegmentTariff)product.getSegmentTariffs().get(0);
            SegmentTariff lastTravelSegmentTariff = (SegmentTariff)product.getSegmentTariffs().get(product.getSegmentTariffs().size() - 1);
            Segment firstTravelSegment = firstTravelSegmentTariff.getSegments().size() > 0 ? (Segment)firstTravelSegmentTariff.getSegments().get(0) : null;
            Segment segment = lastTravelSegment = lastTravelSegmentTariff.getSegments().size() > 0 ? (Segment)lastTravelSegmentTariff.getSegments().get(lastTravelSegmentTariff.getSegments().size() - 1) : null;
            if (firstTravelSegment != null) {
                data.setFirstTravelDate(firstTravelSegment.getStartDate());
                aggregator.aggregate(firstTravelSegment.getStartDate());
            }
            if (lastTravelSegment != null) {
                data.setLastTravelDate(lastTravelSegment.getStartDate());
                aggregator.aggregate(lastTravelSegment.getStartDate());
            }
        }
        data.setServiceLocationType(product.getServiceLocationType());
        aggregator.aggregate((Enum)product.getServiceLocationType());
    }

    protected void updateFopData(CommonProductFopIndexData data, DataAggregator aggregator, ProductFop fop, Product product) {
        BigDecimal amount;
        data.setFopUid(fop.getUid());
        FopType fopType = AirProductHelper.getFopType((ProductFop)fop);
        data.setFopType(fopType);
        aggregator.aggregate((Enum)fopType);
        data.setPaymentType(fop.getType());
        aggregator.aggregate((Enum)fop.getType());
        BigDecimal bigDecimal = amount = fop.getAmount() != null ? fop.getAmount().getValue() : null;
        if (amount != null && (product.getStatus() == ProductStatus.REFUND || product.getStatus() == ProductStatus.EXCHANGE)) {
            amount = amount.negate();
        }
        data.setAmount(amount);
        if (fop.getAmount() != null) {
            data.setCurrency(fop.getAmount().getCurrency());
            aggregator.aggregate((Object)fop.getAmount().getCurrency());
        }
        CardVendor cardVendor = null;
        String cardNumber = null;
        String cardSecurityCode = null;
        if (fop.getCard() != null) {
            Card card = fop.getCard();
            cardVendor = card.getVendor();
            cardNumber = card.getNumber();
            cardSecurityCode = card.getSecurityCode();
        }
        data.setCardVendor(cardVendor);
        aggregator.aggregate((Enum)cardVendor);
        data.setCardNumber(cardNumber);
        aggregator.aggregate((Object)cardNumber);
        data.setCardSecurityCode(cardSecurityCode);
        aggregator.aggregate((Object)cardSecurityCode);
        data.setPassengerStatus(fop.getPassengerStatus());
        aggregator.aggregate((Enum)fop.getPassengerStatus());
        data.setRelatedTicketNumber(fop.getRelatedTicketNumber());
        aggregator.aggregate((Object)fop.getRelatedTicketNumber());
        data.setFopAgent(fop.getAgent());
        aggregator.aggregate((Object)fop.getAgent());
        data.setFopDate(fop.getOperationDate());
        data.setPayer(fop.getPayer());
        aggregator.aggregate((Object)fop.getPayer());
        data.setHasComments(Boolean.valueOf(!TextUtil.isBlank((String)product.getReservation().getBookingFile().getNotes())));
    }
}

