/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.model.index;

import com.gridnine.xtrip.common.model.EntityContainer;
import com.gridnine.xtrip.common.model.EntityReference;
import com.gridnine.xtrip.common.model.booking.BaseProduct;
import com.gridnine.xtrip.common.model.booking.BookingFile;
import com.gridnine.xtrip.common.model.booking.CommonProductIndex;
import com.gridnine.xtrip.common.model.booking.CommonProductIndexData;
import com.gridnine.xtrip.common.model.booking.FopComponent;
import com.gridnine.xtrip.common.model.booking.OperationBatch;
import com.gridnine.xtrip.common.model.booking.ProductStatus;
import com.gridnine.xtrip.common.model.booking.Reservation;
import com.gridnine.xtrip.common.model.booking.ServiceLocationType;
import com.gridnine.xtrip.common.model.booking.SimpleTax;
import com.gridnine.xtrip.common.model.booking.TicketType;
import com.gridnine.xtrip.common.model.booking.TravelSubject;
import com.gridnine.xtrip.common.model.booking.Traveller;
import com.gridnine.xtrip.common.model.booking.ValidationMessage;
import com.gridnine.xtrip.common.model.booking.ValidationMessageCategory;
import com.gridnine.xtrip.common.model.booking.ValidationMessageSeverity;
import com.gridnine.xtrip.common.model.booking.air.AirProductContractRelationData;
import com.gridnine.xtrip.common.model.booking.air.Product;
import com.gridnine.xtrip.common.model.booking.air.ProductFop;
import com.gridnine.xtrip.common.model.booking.air.Segment;
import com.gridnine.xtrip.common.model.booking.air.SegmentTariff;
import com.gridnine.xtrip.common.model.booking.commission.ProductType;
import com.gridnine.xtrip.common.model.booking.misc.ProductVoiding;
import com.gridnine.xtrip.common.model.dict.Airline;
import com.gridnine.xtrip.common.model.dict.CodeSystem;
import com.gridnine.xtrip.common.model.dict.CommunicationType;
import com.gridnine.xtrip.common.model.dict.ContractType;
import com.gridnine.xtrip.common.model.dict.DictionaryCache;
import com.gridnine.xtrip.common.model.dict.DictionaryReference;
import com.gridnine.xtrip.common.model.dict.MCOCategory;
import com.gridnine.xtrip.common.model.dict.ProductCategory;
import com.gridnine.xtrip.common.model.dict.ProfileGroupReference;
import com.gridnine.xtrip.common.model.entity.EntityStorage;
import com.gridnine.xtrip.common.model.finance.FinanceDocument;
import com.gridnine.xtrip.common.model.handlers.HandlersRegistry;
import com.gridnine.xtrip.common.model.handlers.ProductHandler;
import com.gridnine.xtrip.common.model.handlers.ProductStatusHandler;
import com.gridnine.xtrip.common.model.helpers.AirProductHelper;
import com.gridnine.xtrip.common.model.helpers.AirProductTaxHelper;
import com.gridnine.xtrip.common.model.helpers.BookingHelper;
import com.gridnine.xtrip.common.model.helpers.BookingStreamHelper;
import com.gridnine.xtrip.common.model.helpers.DictHelper;
import com.gridnine.xtrip.common.model.helpers.GeneralProductHelper;
import com.gridnine.xtrip.common.model.helpers.SystemHelper;
import com.gridnine.xtrip.common.model.profile.Communication;
import com.gridnine.xtrip.common.model.profile.Contract;
import com.gridnine.xtrip.common.model.profile.Organization;
import com.gridnine.xtrip.common.model.profile.Person;
import com.gridnine.xtrip.common.model.profile.PersonMetadata;
import com.gridnine.xtrip.common.model.system.CardVendor;
import com.gridnine.xtrip.common.model.system.MetadataKey;
import com.gridnine.xtrip.common.model.system.PaymentType;
import com.gridnine.xtrip.common.model.system.VatAmount;
import com.gridnine.xtrip.common.util.CollectionUtil;
import com.gridnine.xtrip.common.util.CompositeNumber;
import com.gridnine.xtrip.common.util.FormattedNumberUtil;
import com.gridnine.xtrip.common.util.MiscUtil;
import com.gridnine.xtrip.common.util.TextUtil;
import com.gridnine.xtrip.server.db.storage.model.BaseIndexData;
import com.gridnine.xtrip.server.db.storage.model.DataAggregator;
import com.gridnine.xtrip.server.db.storage.model.IndexHandler;
import com.gridnine.xtrip.server.model.handlers.ServerHandlersRegistry;
import com.gridnine.xtrip.server.model.handlers.index.CommonIndexHandler;
import com.gridnine.xtrip.server.model.helpers.IndexBuilderHelper;
import com.gridnine.xtrip.server.model.index.BaseCommonProductIndexHandler;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.EnumSet;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AirCommonProductIndexHandler
extends BaseCommonProductIndexHandler
implements IndexHandler<BookingFile, CommonProductIndex> {
    Logger log = LoggerFactory.getLogger(this.getClass());

    public Class<? extends BaseIndexData<BookingFile, CommonProductIndex>> getDataClass() {
        return CommonProductIndexData.class;
    }

    public Class<CommonProductIndex> getIndexClass() {
        return CommonProductIndex.class;
    }

    public Class<BookingFile> getEntityType() {
        return BookingFile.class;
    }

    public void create(EntityContainer<BookingFile> etc, Collection<BaseIndexData<BookingFile, CommonProductIndex>> indexes) {
        DataAggregator aggregator = new DataAggregator();
        for (Reservation reservation : ((BookingFile)etc.getEntity()).getReservations()) {
            for (BaseProduct baseProduct : reservation.getProducts()) {
                if (!(baseProduct instanceof Product)) continue;
                aggregator.reset();
                try {
                    CommonProductIndexData data = new CommonProductIndexData();
                    List handlers = ServerHandlersRegistry.get().findCommonIndexHandlers(this.getIndexClass());
                    for (CommonIndexHandler<BaseProduct, BookingFile, CommonProductIndex> commonIndexHandler : handlers) {
                        commonIndexHandler.updateData((BaseIndexData<BookingFile, CommonProductIndex>)data, aggregator, etc, baseProduct);
                    }
                    this.updateData(data, aggregator, etc, (Product)baseProduct);
                    data.setAggregatedData(aggregator.toString());
                    indexes.add((BaseIndexData<BookingFile, CommonProductIndex>)data);
                }
                catch (Exception e) {
                    this.log.error("unable to create index", (Throwable)e);
                }
            }
        }
    }

    protected void updateData(CommonProductIndexData data, DataAggregator aggregator, EntityContainer<BookingFile> etc, Product product) {
        BigDecimal equivalentFare;
        EntityReference subagencyRef;
        ProductHandler handler = HandlersRegistry.get().findProductHandler(Product.class);
        data.setNavigationKey(product.getUid());
        data.setNextProductUid(product.getNextProduct() == null ? null : product.getNextProduct().getUid());
        data.setReservationType(product.getReservation().getType());
        data.setBookingNumber(TextUtil.buildFullNumber((CompositeNumber)product.getReservation().getBookingFile()));
        aggregator.aggregate((Object)TextUtil.buildFullNumber((CompositeNumber)product.getReservation().getBookingFile()));
        data.setBookingCreateDate(product.getReservation().getBookingFile().getCreateDate());
        aggregator.aggregate(product.getReservation().getBookingFile().getCreateDate());
        data.setTimeLimit(product.getReservation().getTimeLimit());
        aggregator.aggregate(product.getReservation().getTimeLimit());
        data.setBlankOwnerAirlineNumber(product.getBlankOwnerNumber());
        aggregator.aggregate((Object)product.getBlankOwnerNumber());
        data.setBlankOwner(product.getBlankOwnerRef());
        aggregator.aggregate((Object)product.getBlankOwnerRef());
        String militaryClaimNumber = GeneralProductHelper.getMilitaryClaimNumber((BaseProduct)product);
        data.setMilitaryClaimNumber(militaryClaimNumber);
        aggregator.aggregate((Object)militaryClaimNumber);
        DictionaryReference airline = null;
        try {
            EntityContainer ctr = EntityStorage.get().resolve(product.getBlankOwnerRef());
            if (ctr != null) {
                data.setBlankOwnerCode(((Organization)ctr.getEntity()).getCode());
                airline = ((Organization)ctr.getEntity()).getAirline();
            }
        }
        catch (Exception e) {
            this.log.error("unable to resolve blank owner", (Throwable)e);
        }
        data.setAgency(AirProductHelper.getAgency((Product)product));
        aggregator.aggregate((Object)AirProductHelper.getAgency((Product)product));
        data.setSupplier(AirProductHelper.getSupplier((Product)product));
        aggregator.aggregate((Object)AirProductHelper.getSupplier((Product)product));
        data.setStatus(product.getStatus());
        aggregator.aggregate((Enum)product.getStatus());
        data.setIssueDate(product.getIssueDate());
        data.setIssueDateTime(product.getIssueDate());
        data.setLocalIssueDate(product.getLocalIssueDate());
        data.setUnholdDate(null);
        data.setUnholdDateTime(null);
        ServiceLocationType serviceLocationType = AirProductHelper.getServiceLocationType((Product)product);
        data.setServiceLocationType(serviceLocationType);
        aggregator.aggregate((Enum)serviceLocationType);
        String systemNumber = product.getSystemNumber();
        ArrayList<String> systemNumbers = new ArrayList<String>();
        if (!TextUtil.isBlank((String)systemNumber)) {
            systemNumbers.add(systemNumber);
            for (int n = 0; n < product.getConjCount(); ++n) {
                try {
                    systemNumbers.add(FormattedNumberUtil.add((String)systemNumber, (long)(n + 1)));
                    continue;
                }
                catch (Exception e) {
                    this.log.error("unable to parse ticket number " + systemNumber, (Throwable)e);
                }
            }
        }
        data.setSystemNumbers(systemNumbers);
        aggregator.aggregate(systemNumbers);
        data.setFirstSystemNumber((String)CollectionUtil.head(systemNumbers));
        data.setSystemNumberPrefix(product.getCarrierNumber());
        aggregator.aggregate((Object)product.getCarrierNumber());
        TicketType ticketType = product.getTicketType() != null ? product.getTicketType() : TicketType.OWN;
        data.setTicketType(ticketType);
        aggregator.aggregate((Enum)ticketType);
        String ticketNumber = null;
        ticketNumber = systemNumbers.isEmpty() ? (product.getStatus() == ProductStatus.VOID ? this.buildFullNumber(product.getScns()) : null) : this.buildFullNumber(systemNumbers);
        data.setSncs((Collection)product.getScns());
        aggregator.aggregate((Iterable)product.getScns());
        data.setChecked(Boolean.valueOf(product.isChecked()));
        data.setCompleted(Boolean.valueOf(product.isCompleted()));
        data.setAgent(product.getCashier());
        data.setBookingAgent(product.getReservation().getBookingAgent());
        aggregator.aggregate((Object)product.getCashier());
        EntityReference clientRelationMediator = GeneralProductHelper.getClientRelationMediator((BaseProduct)product);
        data.setMediator(clientRelationMediator);
        aggregator.aggregate((Object)clientRelationMediator);
        data.setClient(product.getReservation().getBookingFile().getCustomerProfile());
        aggregator.aggregate((Object)product.getReservation().getBookingFile().getCustomerProfile());
        if (!product.getSegmentTariffs().isEmpty()) {
            SegmentTariff lastSegmentTariff;
            List segments;
            SegmentTariff firstSegmentTariff = (SegmentTariff)product.getSegmentTariffs().get(0);
            if (!firstSegmentTariff.getSegments().isEmpty()) {
                data.setFirstDepartureDate(((Segment)firstSegmentTariff.getSegments().get(0)).getStartDate());
            }
            if (!(segments = (lastSegmentTariff = (SegmentTariff)product.getSegmentTariffs().get(product.getSegmentTariffs().size() - 1)).getSegments()).isEmpty()) {
                data.setLastArrivalDate(((Segment)segments.get(segments.size() - 1)).getEndDate());
            }
        }
        if ((subagencyRef = AirProductHelper.getSubagency((Product)product)) != null) {
            try {
                EntityContainer subagency = EntityStorage.get().resolve(subagencyRef);
                ArrayList<ProfileGroupReference> subagencyGroups = new ArrayList<ProfileGroupReference>();
                if (subagency != null) {
                    for (Object metadata : ((Organization)subagency.getEntity()).getMetadata()) {
                        if (metadata.getKey() == null || !metadata.getKey().getCode().equals(MetadataKey.KEY_ORGANIZATION_PROFILE_GROUP.name()) || metadata.getValue() == null) continue;
                        subagencyGroups.add((ProfileGroupReference)metadata.getValue());
                    }
                }
                data.setSubagencyGroups(subagencyGroups);
                aggregator.aggregate(subagencyGroups);
            }
            catch (Throwable e) {
                this.log.error("unable to load profile " + subagencyRef, e);
            }
        }
        try {
            EntityContainer client = EntityStorage.get().resolve(product.getReservation().getBookingFile().getCustomerProfile());
            if (client != null) {
                String code = SystemHelper.findMetadataAsString((Collection)((Organization)client.getEntity()).getMetadata(), (MetadataKey)MetadataKey.KEY_ACCOUNTING_SYSTEM_CODE);
                code = code != null ? code : ((Organization)client.getEntity()).getCode();
                data.setClientAccountingCode(code);
                aggregator.aggregate((Object)code);
                ArrayList<ProfileGroupReference> clientGroups = new ArrayList<ProfileGroupReference>();
                for (Object metadata : ((Organization)client.getEntity()).getMetadata()) {
                    if (metadata.getKey() == null || !metadata.getKey().getCode().equals(MetadataKey.KEY_ORGANIZATION_PROFILE_GROUP.name()) || metadata.getValue() == null) continue;
                    clientGroups.add((ProfileGroupReference)metadata.getValue());
                }
                data.setClientGroups(clientGroups);
                aggregator.aggregate(clientGroups);
            }
        }
        catch (Throwable e) {
            this.log.error("unable to load profile " + product.getReservation().getBookingFile().getCustomerProfile(), e);
        }
        String validatorCode = product.getValidatorCode();
        data.setValidatorCode(validatorCode);
        aggregator.aggregate((Object)validatorCode);
        data.setSubagency(AirProductHelper.getSubagency((Product)product));
        aggregator.aggregate((Object)AirProductHelper.getSubagency((Product)product));
        data.setBranch(product.getBranch());
        aggregator.aggregate((Object)product.getBranch());
        EntityContainer clientContainer = EntityStorage.get().resolve(product.getReservation().getBookingFile().getCustomerProfile());
        if (clientContainer != null) {
            data.setHolding(((Organization)clientContainer.getEntity()).getHolding());
            aggregator.aggregate((Object)((Organization)clientContainer.getEntity()).getHolding());
        }
        data.setSalesPoint(product.getSalesPoint());
        aggregator.aggregate((Object)product.getSalesPoint());
        data.setBlankType(product.getBlankType());
        aggregator.aggregate((Object)product.getBlankType());
        if (product.getCarrier() != null) {
            data.setCarrier(product.getCarrier());
            data.setProviderName(product.getCarrier().toString());
            aggregator.aggregate((Object)product.getCarrier());
            Airline carrier = (Airline)DictionaryCache.get().resolveReference(product.getCarrier());
            if (carrier != null) {
                String code = (String)carrier.getCodeVariants().get(CodeSystem.IATA.name());
                if (code == null) {
                    code = carrier.getCodeVariants().isEmpty() ? carrier.getCode() : (String)carrier.getCodeVariants().values().iterator().next();
                }
                data.setProviderCode(code);
                aggregator.aggregate((Object)code);
            } else {
                data.setProviderCode(product.getCarrier().getCode());
                aggregator.aggregate((Object)product.getCarrier().getCode());
            }
        }
        data.setEticket(Boolean.valueOf(product.isEticket()));
        Date refuseDate = null;
        AirProductContractRelationData clientContractRelation = AirProductHelper.getClientContractRelation((Product)product);
        for (ProductFop fop2 : clientContractRelation.getFops()) {
            if (!fop2.isRefused() || fop2.getOperationDate() == null || refuseDate != null && !refuseDate.after(fop2.getOperationDate())) continue;
            refuseDate = fop2.getOperationDate();
        }
        if (refuseDate != null) {
            data.setCancellationDate(refuseDate);
            aggregator.aggregate(refuseDate);
        }
        if ((equivalentFare = AirProductHelper.getEquivalentFare((Product)product)) == null) {
            equivalentFare = BigDecimal.ZERO;
        }
        aggregator.aggregate((Object)equivalentFare);
        HashSet<String> passportNumbers = new HashSet<String>();
        HashSet<String> travellersNames = new HashSet<String>();
        HashSet<EntityReference> passengers = new HashSet<EntityReference>();
        Traveller traveller = product.getTraveller();
        if (traveller != null) {
            if (traveller.getPassport() != null && traveller.getPassport().getNumber() != null) {
                passportNumbers.add(traveller.getPassport().getNumber());
            }
            if (traveller.getName() != null) {
                travellersNames.add(traveller.getName());
            }
            if (traveller.getPassenger() != null) {
                passengers.add(traveller.getPassenger());
            }
        }
        data.setTravellersPassportsNumbers(passportNumbers);
        data.setTravellersNames(travellersNames);
        data.setPassengers(passengers);
        aggregator.aggregate(passportNumbers);
        aggregator.aggregate(travellersNames);
        OperationBatch batch = BookingHelper.getOperationBatch((BaseProduct)product);
        String sortingNumber = BookingHelper.getSortingTicketNumber((BaseProduct)product);
        if (sortingNumber == null) {
            sortingNumber = ticketNumber;
        }
        data.setOperationBatch(batch);
        aggregator.aggregate((Object)sortingNumber);
        data.setSortingTicketNumber(sortingNumber);
        aggregator.aggregate((Enum)batch);
        data.setWorkflowStatus(product.getReservation().getBookingFile().getWorkflowStatus());
        data.setReservationStatus(product.getReservation().getStatus());
        aggregator.aggregate((Enum)product.getReservation().getStatus());
        aggregator.aggregate((Enum)product.getReservation().getBookingFile().getWorkflowStatus());
        data.setTravelSubject(TravelSubject.AIR);
        ProductType productType = AirProductHelper.getProductType((Product)product);
        aggregator.aggregate((Enum)productType);
        data.setProductType(productType);
        data.setDescription(TravelSubject.AIR.toString());
        String routeLine = handler.getLocalizedRouteLine((BaseProduct)product);
        routeLine = !TextUtil.isBlank((String)routeLine) && routeLine.length() > 255 ? "???" : routeLine;
        data.setRouteLine(routeLine);
        aggregator.aggregate((Object)routeLine);
        String routeLineCodes = AirProductHelper.getRouteLine((Product)product, null, (boolean)true, (CodeSystem)CodeSystem.IATA);
        data.setRouteLineCodes(routeLineCodes);
        aggregator.aggregate((Object)routeLineCodes);
        Date firstTravelDate = AirProductHelper.getFirstDepartureDate((Product)product);
        data.setFirstTravelDate(firstTravelDate);
        aggregator.aggregate(firstTravelDate);
        Date lastTravelDate = AirProductHelper.getLastDepartureDate((Product)product);
        data.setLastTravelDate(lastTravelDate);
        aggregator.aggregate(lastTravelDate);
        if (!ProductStatusHandler.getAllVoidStatuses().contains(product.getStatus())) {
            boolean exchange;
            boolean refund = product.getStatus() == ProductStatus.REFUND || product.getStatus() == ProductStatus.EXCHANGE;
            boolean bl = exchange = product.getStatus() == ProductStatus.EXCHANGE;
            if (refund && product.getPreviousProduct() != null) {
                EntityReference sellAgent = product.getPreviousProduct().getCashier();
                data.setSellAgent(sellAgent);
                aggregator.aggregate((Object)sellAgent);
            }
            for (Object related : product.getRelatedProducts()) {
                String relatedTicketNo = related.getSystemNumber();
                if (TextUtil.isBlank((String)relatedTicketNo)) continue;
                aggregator.aggregate((Object)relatedTicketNo);
                data.setRelatedTicketNo(relatedTicketNo);
                break;
            }
            data.setIncludeVat(Boolean.valueOf(AirProductHelper.isHasVat((Product)product)));
            BigDecimal penalty = product.getPenalty();
            if (penalty == null) {
                penalty = BigDecimal.ZERO;
            }
            aggregator.aggregate((Object)equivalentFare);
            aggregator.aggregate((Object)penalty);
            data.setPenalty(penalty);
            data.setEquivalentFare(refund ? equivalentFare.negate() : equivalentFare);
            data.setEquivalentFareCurrency(product.getGdsCurrency());
            if (product.getProductCategory() == ProductCategory.MCO && product.getMcoCategory() == MCOCategory.PENALTY) {
                data.setEquivalentFare(BigDecimal.ZERO);
                data.setPenalty(equivalentFare);
            }
            data.setValid(Boolean.valueOf(true));
            data.setHasWarnings(Boolean.valueOf(false));
            data.setHasOtherErrors(Boolean.valueOf(false));
            data.setHasStockControlErrors(Boolean.valueOf(false));
            data.setHasRulesErrors(Boolean.valueOf(false));
            data.setHasShipmentErrors(Boolean.valueOf(false));
            data.setHasErrors(Boolean.valueOf(false));
            for (ValidationMessage message : product.getValidationMessages()) {
                if (message.getSeverity() == ValidationMessageSeverity.WARNING) {
                    data.setHasWarnings(Boolean.valueOf(true));
                }
                if (message.getSeverity() == ValidationMessageSeverity.USER_ERROR) {
                    data.setHasUserErrors(Boolean.valueOf(true));
                    data.setHasErrors(Boolean.valueOf(true));
                }
                if (message.getSeverity() == ValidationMessageSeverity.SHIPMENT_ERROR) {
                    data.setHasShipmentErrors(Boolean.valueOf(true));
                }
                if (message.getSeverity() != ValidationMessageSeverity.ERROR) continue;
                data.setHasErrors(Boolean.valueOf(true));
                if (message.getCategory() == ValidationMessageCategory.OTHER) {
                    data.setValid(Boolean.valueOf(false));
                    data.setHasOtherErrors(Boolean.valueOf(true));
                }
                if (message.getCategory() == ValidationMessageCategory.STOCK_CONTROL) {
                    data.setHasStockControlErrors(Boolean.valueOf(true));
                }
                if (message.getCategory() != ValidationMessageCategory.RULES) continue;
                data.setHasRulesErrors(Boolean.valueOf(true));
            }
            BigDecimal taxesSum = AirProductTaxHelper.getEquivalentTaxesAmount((Product)product);
            aggregator.aggregate((Object)taxesSum);
            data.setTaxesSum(refund ? taxesSum.negate() : taxesSum);
            BigDecimal taxesForBlankSum = AirProductTaxHelper.getTaxesForBlankEquivalentAmount((Product)product);
            BigDecimal otherTaxesSum = taxesSum.subtract(taxesForBlankSum);
            data.setTaxesForBlankSum((BigDecimal)(refund ? taxesForBlankSum.negate() : taxesForBlankSum));
            data.setOtherTaxesSum(refund ? otherTaxesSum.negate() : otherTaxesSum);
            CardVendor creditCardVendor = AirProductHelper.getCreditCardVendor((Collection)clientContractRelation.getFops());
            data.setClientCardVendor(creditCardVendor);
            aggregator.aggregate((Enum)creditCardVendor);
            AirProductContractRelationData vendorContractRelation = AirProductHelper.getVendorContractRelation((Product)product);
            AirProductContractRelationData subagentContractRelation = AirProductHelper.getSubagentContractRelation((Product)product, (boolean)false);
            creditCardVendor = AirProductHelper.getCreditCardVendor((Collection)vendorContractRelation.getFops());
            data.setSupplierCardVendor(creditCardVendor);
            aggregator.aggregate((Enum)creditCardVendor);
            VatAmount price = BookingHelper.calculateProductPrice((BaseProduct)product, (ContractType)ContractType.VENDOR);
            BigDecimal totalSum = price.getTotal();
            data.setTotalSum(totalSum);
            aggregator.aggregate((Object)totalSum);
            if (product.getTotalVendorEquivalentVatAmount() == null) {
                data.setVatRate(price.getVat());
                data.setVatValue(price.getVatAmount());
            } else if (product.getTotalVendorEquivalentVatAmount().compareTo(BigDecimal.ZERO) == 0) {
                data.setVatRate(Double.valueOf(0.0));
                data.setVatValue(BigDecimal.ZERO);
            } else {
                data.setVatRate(Double.valueOf(MiscUtil.guarded((BigDecimal)DictHelper.getDefaultVat((Date)product.getIssueDate())).doubleValue()));
                data.setVatValue(totalSum.compareTo(BigDecimal.ZERO) >= 0 ? product.getTotalVendorEquivalentVatAmount() : product.getTotalVendorEquivalentVatAmount().negate());
            }
            try {
                BigDecimal fee2;
                BigDecimal vendorCommissionsBaseValue;
                BigDecimal vendorCommissionsValue;
                Double vendorCommissionRate;
                BigDecimal vendorCommissionsRate;
                if (AirProductHelper.isBSPTicket((Product)product)) {
                    Double bspCommissionRate = product.getBspCommissionRate();
                    if (refund && bspCommissionRate != null) {
                        bspCommissionRate = BigDecimal.valueOf(-1.0 * bspCommissionRate).doubleValue();
                    }
                    data.setBspCommissionRate(bspCommissionRate);
                    data.setBspCommissionValue(BookingHelper.getCommissionValue((BigDecimal)(product.getBspCommissionValue() != null ? product.getBspCommissionValue().getValue() : null), (boolean)refund));
                    if (product.getBlankOwnerRef() != null && product.getBlankOwnerRef().equals((Object)AirProductHelper.getSupplier((Product)product))) {
                        Double vendorBspCommissionRate;
                        BigDecimal vendorBSPCommissionsRate = AirProductHelper.calculateCommissionsRate((Collection)GeneralProductHelper.filterCommissions((Collection)AirProductHelper.getUnmodifiableCommissions((Product)product, (ContractType)ContractType.VENDOR), (Set)GeneralProductHelper.commissionCommissionPropertyTypes, (Set)GeneralProductHelper.bspCommissionTypes, null), (boolean)true);
                        BigDecimal vendorBSPCommissionsValue = AirProductHelper.calculateCommissionsEquivalentValue((Collection)GeneralProductHelper.filterCommissions((Collection)AirProductHelper.getUnmodifiableCommissions((Product)product, (ContractType)ContractType.VENDOR), (Set)GeneralProductHelper.commissionCommissionPropertyTypes, (Set)GeneralProductHelper.bspCommissionTypes, null));
                        Double d = vendorBspCommissionRate = vendorBSPCommissionsRate != null ? Double.valueOf(vendorBSPCommissionsRate.doubleValue()) : null;
                        if (refund && vendorBspCommissionRate != null) {
                            vendorBspCommissionRate = BigDecimal.valueOf(-1.0 * vendorBspCommissionRate).doubleValue();
                        }
                        data.setVendorCommissionRate(vendorBspCommissionRate);
                        vendorBSPCommissionsValue = BookingHelper.getCommissionValue((BigDecimal)vendorBSPCommissionsValue, (boolean)refund);
                        data.setVendorCommissionValue(vendorBSPCommissionsValue);
                    } else {
                        Double vendorCommissionRate2;
                        BigDecimal vendorCommissionsRate2 = AirProductHelper.calculateCommissionsRate((Collection)GeneralProductHelper.filterCommissions((Collection)AirProductHelper.getUnmodifiableCommissions((Product)product, (ContractType)ContractType.VENDOR), (Set)GeneralProductHelper.commissionCommissionPropertyTypes, (Set)GeneralProductHelper.standardCommissionTypes, null), (boolean)true);
                        Double d = vendorCommissionRate2 = vendorCommissionsRate2 != null ? Double.valueOf(vendorCommissionsRate2.doubleValue()) : null;
                        if (refund && vendorCommissionRate2 != null) {
                            vendorCommissionRate2 = BigDecimal.valueOf(-1.0 * vendorCommissionRate2).doubleValue();
                        }
                        BigDecimal vendorCommissionsValue2 = BookingHelper.getCommissionValue((BigDecimal)AirProductHelper.calculateCommissionsEquivalentValue((Collection)GeneralProductHelper.filterCommissions((Collection)AirProductHelper.getUnmodifiableCommissions((Product)product, (ContractType)ContractType.VENDOR), (Set)GeneralProductHelper.commissionCommissionPropertyTypes, (Set)GeneralProductHelper.standardCommissionTypes, null)), (boolean)refund);
                        BigDecimal vendorCommissionsBaseValue2 = BookingHelper.getCommissionValue((BigDecimal)AirProductHelper.calculateCommissionsBaseValue((Collection)GeneralProductHelper.filterCommissions((Collection)AirProductHelper.getUnmodifiableCommissions((Product)product, (ContractType)ContractType.VENDOR), (Set)GeneralProductHelper.commissionCommissionPropertyTypes, (Set)GeneralProductHelper.standardCommissionTypes, null)), (boolean)refund);
                        data.setVendorCommissionRate(vendorCommissionRate2);
                        data.setVendorCommissionValue(vendorCommissionsValue2);
                    }
                } else if (product.getBlankOwnerRef() != null && product.getBlankOwnerRef().equals((Object)AirProductHelper.getSupplier((Product)product))) {
                    vendorCommissionsRate = AirProductHelper.calculateCommissionsRate((Collection)GeneralProductHelper.filterCommissions((Collection)AirProductHelper.getUnmodifiableCommissions((Product)product, (ContractType)ContractType.VENDOR), (Set)GeneralProductHelper.commissionCommissionPropertyTypes, null, null), (boolean)true);
                    Double d = vendorCommissionRate = vendorCommissionsRate != null ? Double.valueOf(vendorCommissionsRate.doubleValue()) : null;
                    if (refund && vendorCommissionRate != null) {
                        vendorCommissionRate = BigDecimal.valueOf(-1.0 * vendorCommissionRate).doubleValue();
                    }
                    vendorCommissionsValue = BookingHelper.getCommissionValue((BigDecimal)AirProductHelper.calculateCommissionsEquivalentValue((Collection)GeneralProductHelper.filterCommissions((Collection)AirProductHelper.getUnmodifiableCommissions((Product)product, (ContractType)ContractType.VENDOR), (Set)GeneralProductHelper.commissionCommissionPropertyTypes, null, null)), (boolean)refund);
                    vendorCommissionsBaseValue = BookingHelper.getCommissionValue((BigDecimal)AirProductHelper.calculateCommissionsBaseValue((Collection)GeneralProductHelper.filterCommissions((Collection)AirProductHelper.getUnmodifiableCommissions((Product)product, (ContractType)ContractType.VENDOR), (Set)GeneralProductHelper.commissionCommissionPropertyTypes, null, null)), (boolean)refund);
                    data.setVendorCommissionRate(vendorCommissionRate);
                    data.setVendorCommissionValue(vendorCommissionsValue);
                } else {
                    vendorCommissionsRate = AirProductHelper.calculateCommissionsRate((Collection)GeneralProductHelper.filterCommissions((Collection)AirProductHelper.getUnmodifiableCommissions((Product)product, (ContractType)ContractType.VENDOR), (Set)GeneralProductHelper.commissionCommissionPropertyTypes, null, null), (boolean)true);
                    Double d = vendorCommissionRate = vendorCommissionsRate != null ? Double.valueOf(vendorCommissionsRate.doubleValue()) : null;
                    if (refund && vendorCommissionRate != null) {
                        vendorCommissionRate = BigDecimal.valueOf(-1.0 * vendorCommissionRate).doubleValue();
                    }
                    vendorCommissionsValue = BookingHelper.getCommissionValue((BigDecimal)AirProductHelper.calculateCommissionsEquivalentValue((Collection)GeneralProductHelper.filterCommissions((Collection)AirProductHelper.getUnmodifiableCommissions((Product)product, (ContractType)ContractType.VENDOR), (Set)GeneralProductHelper.commissionCommissionPropertyTypes, null, null)), (boolean)refund);
                    vendorCommissionsBaseValue = BookingHelper.getCommissionValue((BigDecimal)AirProductHelper.calculateCommissionsBaseValue((Collection)GeneralProductHelper.filterCommissions((Collection)AirProductHelper.getUnmodifiableCommissions((Product)product, (ContractType)ContractType.VENDOR), (Set)GeneralProductHelper.commissionCommissionPropertyTypes, (Set)GeneralProductHelper.subagentCommissionTypes, null)), (boolean)refund);
                    data.setVendorCommissionRate(vendorCommissionRate);
                    data.setVendorCommissionValue(vendorCommissionsValue);
                }
                data.setSubagencyCommissionValue(BookingHelper.getCommissionValue((BigDecimal)AirProductHelper.calculateCommissionsEquivalentValue((Collection)GeneralProductHelper.filterCommissions((Collection)AirProductHelper.getUnmodifiableCommissions((Product)product, (ContractType)ContractType.SUBAGENCY), (Set)GeneralProductHelper.commissionCommissionPropertyTypes, (Set)GeneralProductHelper.standardCommissionTypes, null)), (boolean)refund));
                data.setSubagencyCommissionRate(AirProductHelper.calculateCommissionsRateAsDouble((Collection)GeneralProductHelper.filterCommissions((Collection)AirProductHelper.getUnmodifiableCommissions((Product)product, (ContractType)ContractType.SUBAGENCY), (Set)GeneralProductHelper.commissionCommissionPropertyTypes, (Set)GeneralProductHelper.standardCommissionTypes, null), (boolean)true));
                data.setSubagencyBonusValue(BookingHelper.getCommissionValue((BigDecimal)AirProductHelper.calculateCommissionsEquivalentValue((Collection)GeneralProductHelper.filterCommissions((Collection)AirProductHelper.getUnmodifiableCommissions((Product)product, (ContractType)ContractType.SUBAGENCY), (Set)GeneralProductHelper.commissionCommissionPropertyTypes, (Set)GeneralProductHelper.bonusCommissionTypes, null)), (boolean)refund));
                data.setSubagencyBonusRate(AirProductHelper.calculateCommissionsRateAsDouble((Collection)GeneralProductHelper.filterCommissions((Collection)AirProductHelper.getUnmodifiableCommissions((Product)product, (ContractType)ContractType.SUBAGENCY), (Set)GeneralProductHelper.commissionCommissionPropertyTypes, (Set)GeneralProductHelper.bonusCommissionTypes, null), (boolean)true));
                data.setClientCommissionValue(BookingHelper.getCommissionValue((BigDecimal)AirProductHelper.calculateCommissionsEquivalentValue((Collection)GeneralProductHelper.filterCommissions((Collection)AirProductHelper.getUnmodifiableCommissions((Product)product, (ContractType)ContractType.CLIENT), (Set)GeneralProductHelper.commissionCommissionPropertyTypes, (Set)GeneralProductHelper.standardCommissionTypes, null)), (boolean)refund));
                data.setClientCommissionRate(AirProductHelper.calculateCommissionsRateAsDouble((Collection)GeneralProductHelper.filterCommissions((Collection)AirProductHelper.getUnmodifiableCommissions((Product)product, (ContractType)ContractType.CLIENT), (Set)GeneralProductHelper.commissionCommissionPropertyTypes, (Set)GeneralProductHelper.standardCommissionTypes, null), (boolean)true));
                data.setClientBonusValue(BookingHelper.getCommissionValue((BigDecimal)AirProductHelper.calculateCommissionsEquivalentValue((Collection)GeneralProductHelper.filterCommissions((Collection)AirProductHelper.getUnmodifiableCommissions((Product)product, (ContractType)ContractType.CLIENT), (Set)GeneralProductHelper.commissionCommissionPropertyTypes, (Set)GeneralProductHelper.bonusCommissionTypes, null)), (boolean)refund));
                data.setClientBonusRate(AirProductHelper.calculateCommissionsRateAsDouble((Collection)GeneralProductHelper.filterCommissions((Collection)AirProductHelper.getUnmodifiableCommissions((Product)product, (ContractType)ContractType.CLIENT), (Set)GeneralProductHelper.commissionCommissionPropertyTypes, (Set)GeneralProductHelper.bonusCommissionTypes, null), (boolean)true));
                data.setVendorFeeValue(BookingHelper.getCommissionValue((BigDecimal)AirProductHelper.calculateCommissionsEquivalentValue((Collection)GeneralProductHelper.filterCommissions((Collection)AirProductHelper.getUnmodifiableCommissions((Product)product, (ContractType)ContractType.VENDOR), (Set)GeneralProductHelper.serviceFeePropertyTypes, null, null)), (boolean)refund));
                data.setVendorFeeRate(AirProductHelper.calculateCommissionsRateAsDouble((Collection)GeneralProductHelper.filterCommissions((Collection)AirProductHelper.getUnmodifiableCommissions((Product)product, (ContractType)ContractType.VENDOR), (Set)GeneralProductHelper.serviceFeePropertyTypes, null, null), (boolean)true));
                data.setSubagencyFeeValue(BookingHelper.getCommissionValue((BigDecimal)AirProductHelper.calculateCommissionsEquivalentValue((Collection)GeneralProductHelper.filterCommissions((Collection)AirProductHelper.getUnmodifiableCommissions((Product)product, (ContractType)ContractType.SUBAGENCY), (Set)GeneralProductHelper.serviceFeePropertyTypes, null, null)), (boolean)refund));
                data.setSubagencyFeeRate(AirProductHelper.calculateCommissionsRateAsDouble((Collection)GeneralProductHelper.filterCommissions((Collection)AirProductHelper.getUnmodifiableCommissions((Product)product, (ContractType)ContractType.SUBAGENCY), (Set)GeneralProductHelper.serviceFeePropertyTypes, null, null), (boolean)true));
                data.setSubagencyHiddenFeeValue(BookingHelper.getCommissionValue((BigDecimal)AirProductHelper.calculateCommissionsEquivalentValue((Collection)GeneralProductHelper.filterCommissions((Collection)AirProductHelper.getUnmodifiableCommissions((Product)product, (ContractType)ContractType.SUBAGENCY), (Set)GeneralProductHelper.serviceFeePropertyTypes, null, (Set)GeneralProductHelper.hiddenCommissionCategories)), (boolean)refund));
                BigDecimal fee = BookingHelper.getCommissionValue((BigDecimal)AirProductHelper.calculateCommissionsEquivalentValue((Collection)GeneralProductHelper.filterCommissions((Collection)AirProductHelper.getUnmodifiableCommissions((Product)product, (ContractType)ContractType.CLIENT), (Set)GeneralProductHelper.serviceFeePropertyTypes, null, null)), (boolean)refund);
                if (fee == null) {
                    fee = BigDecimal.ZERO;
                }
                data.setClientFeeValue((fee2 = BookingHelper.getCommissionValue((BigDecimal)AirProductHelper.calculateCommissionsEquivalentValue((Collection)GeneralProductHelper.filterCommissions((Collection)AirProductHelper.getUnmodifiableCommissions((Product)product, (ContractType)ContractType.CLIENT), (Set)GeneralProductHelper.paymentFeePropertyTypes, null, null)), (boolean)refund)) == null ? fee : fee.add(fee2));
                data.setClientServiceFeeValue(fee);
                data.setClientPaymentFeeValue(fee2);
                BigDecimal fee3 = BookingHelper.getCommissionValue((BigDecimal)AirProductHelper.calculateCommissionsEquivalentValue((Collection)GeneralProductHelper.filterCommissions((Collection)AirProductHelper.getUnmodifiableCommissions((Product)product, (ContractType)ContractType.VENDOR), (Set)GeneralProductHelper.paymentFeePropertyTypes, null, null)), (boolean)refund);
                data.setVendorPaymentFeeValue(fee3);
                data.setClientFeeRate(AirProductHelper.calculateCommissionsRateAsDouble((Collection)GeneralProductHelper.filterCommissions((Collection)AirProductHelper.getUnmodifiableCommissions((Product)product, (ContractType)ContractType.CLIENT), (Set)GeneralProductHelper.serviceFeePropertyTypes, null, null), (boolean)true));
                data.setVendorBonusRate(AirProductHelper.calculateCommissionsRateAsDouble((Collection)GeneralProductHelper.filterCommissions((Collection)AirProductHelper.getUnmodifiableCommissions((Product)product, (ContractType)ContractType.VENDOR), (Set)GeneralProductHelper.commissionCommissionPropertyTypes, (Set)GeneralProductHelper.bonusCommissionTypes, null), (boolean)true));
                data.setVendorBonusValue(BookingHelper.getCommissionValue((BigDecimal)AirProductHelper.calculateCommissionsEquivalentValue((Collection)GeneralProductHelper.filterCommissions((Collection)AirProductHelper.getUnmodifiableCommissions((Product)product, (ContractType)ContractType.VENDOR), (Set)GeneralProductHelper.commissionCommissionPropertyTypes, (Set)GeneralProductHelper.bonusCommissionTypes, null)), (boolean)refund));
                data.setAgentPenaltyForService(BookingHelper.calculateAgentPenaltyForProduct((BaseProduct)product));
                data.setAgentPenaltyForCommissions(AirProductHelper.calculateAgentPenaltyForCommissions((Product)product));
                data.setAgentPenaltyForFees(BookingHelper.calculateAgentPenaltyForFees((BaseProduct)product));
            }
            catch (Exception e) {
                this.log.error("failed calculating commissions ", (Throwable)e);
            }
            Object date = null;
            EntityReference agent = null;
            boolean hasClientDebt = false;
            HashSet<PaymentType> clientFopTypes = new HashSet<PaymentType>();
            HashSet<PaymentType> clientFeesFopTypes = new HashSet<PaymentType>();
            BigDecimal clientFOPAmount = null;
            BigDecimal clientFOPAddAmount = null;
            BigDecimal clientFOPTotalAddAmount = null;
            EnumSet<PaymentType> addPaymentTypes = EnumSet.allOf(PaymentType.class);
            addPaymentTypes.remove(PaymentType.TICKET);
            addPaymentTypes.remove(PaymentType.VOUCHER);
            addPaymentTypes.remove(PaymentType.MTD);
            addPaymentTypes.remove(PaymentType.MTD_AGENCY);
            addPaymentTypes.remove(PaymentType.CREDIT);
            addPaymentTypes.remove(PaymentType.CREDIT_CARD);
            for (ProductFop fop3 : clientContractRelation.getFops()) {
                Object fopAmount;
                if (fop3.getAmount() != null && fop3.getAmount().getValue() != null) {
                    fopAmount = fop3.getAmount().getValue();
                    BigDecimal bigDecimal = clientFOPAmount = clientFOPAmount != null ? clientFOPAmount.add((BigDecimal)fopAmount) : fopAmount;
                }
                if (!exchange && fop3.getAmount() != null && fop3.getAmount().getValue() != null && addPaymentTypes.contains(fop3.getType()) && GeneralProductHelper.productFopTypes.contains(AirProductHelper.getFopType((ProductFop)fop3))) {
                    fopAmount = fop3.getAmount().getValue();
                    BigDecimal bigDecimal = clientFOPAddAmount = clientFOPAddAmount != null ? clientFOPAddAmount.add((BigDecimal)fopAmount) : fopAmount;
                }
                if (!exchange && fop3.getAmount() != null && fop3.getAmount().getValue() != null && addPaymentTypes.contains(fop3.getType()) && !GeneralProductHelper.discountFopTypes.contains(AirProductHelper.getFopType((ProductFop)fop3))) {
                    fopAmount = fop3.getAmount().getValue();
                    BigDecimal bigDecimal = clientFOPTotalAddAmount = clientFOPTotalAddAmount != null ? clientFOPTotalAddAmount.add((BigDecimal)fopAmount) : fopAmount;
                }
                if (fop3.getType() != null) {
                    if (AirProductHelper.isServiceFop((ProductFop)fop3)) {
                        clientFopTypes.add(fop3.getType());
                    } else {
                        clientFeesFopTypes.add(fop3.getType());
                    }
                }
                if (fop3.getOperationDate() == null) {
                    hasClientDebt = true;
                    continue;
                }
                if (date != null && !((Date)date).before(fop3.getOperationDate())) continue;
                date = fop3.getOperationDate();
                agent = fop3.getAgent();
            }
            if (refund && clientFOPAmount != null) {
                clientFOPAmount = clientFOPAmount.negate();
            }
            data.setClientFopAmount(clientFOPAmount);
            aggregator.aggregate((Object)clientFOPAmount);
            if (refund && clientFOPAddAmount != null) {
                clientFOPAddAmount = clientFOPAddAmount.negate();
            }
            data.setClientFopAddAmount(clientFOPAddAmount);
            aggregator.aggregate((Object)clientFOPAddAmount);
            if (refund && clientFOPTotalAddAmount != null) {
                clientFOPTotalAddAmount = clientFOPTotalAddAmount.negate();
            }
            data.setClientFopTotalAddAmount(clientFOPTotalAddAmount);
            aggregator.aggregate((Object)clientFOPTotalAddAmount);
            data.setClientFopTypes(clientFopTypes);
            aggregator.aggregate(clientFopTypes);
            data.setClientFeesFopTypes(clientFeesFopTypes);
            aggregator.aggregate(clientFeesFopTypes);
            data.setDateOfClientPayment((Date)date);
            aggregator.aggregate((Date)date);
            data.setClientFopAgent(agent);
            aggregator.aggregate((Object)agent);
            data.setHasClientDebt(Boolean.valueOf(hasClientDebt));
            HashSet<PaymentType> vendorFopTypes = new HashSet<PaymentType>();
            BigDecimal vendorFOPAmount = null;
            date = null;
            for (ProductFop fop4 : vendorContractRelation.getFops()) {
                if (fop4.getAmount() != null && fop4.getAmount().getValue() != null) {
                    BigDecimal fopAmount = fop4.getAmount().getValue();
                    BigDecimal bigDecimal = vendorFOPAmount = vendorFOPAmount != null ? vendorFOPAmount.add(fopAmount) : fopAmount;
                }
                if (fop4.getType() != null) {
                    vendorFopTypes.add(fop4.getType());
                }
                if (fop4.getOperationDate() == null || date != null && !((Date)date).before(fop4.getOperationDate())) continue;
                date = fop4.getOperationDate();
            }
            if (refund && vendorFOPAmount != null) {
                vendorFOPAmount = vendorFOPAmount.negate();
            }
            data.setVendorFopAmount(vendorFOPAmount);
            aggregator.aggregate((Object)vendorFOPAmount);
            data.setDateOfVendorPayment((Date)date);
            aggregator.aggregate((Date)date);
            data.setVendorFopTypes(vendorFopTypes);
            aggregator.aggregate(vendorFopTypes);
            HashSet<PaymentType> subagentFopTypes = new HashSet<PaymentType>();
            HashSet<PaymentType> subagentFeesFopTypes = new HashSet<PaymentType>();
            if (subagentContractRelation != null) {
                if (subagentContractRelation.getFops() != null) {
                    for (ProductFop fop5 : subagentContractRelation.getFops()) {
                        if (fop5.getType() == null) continue;
                        if (AirProductHelper.isServiceFop((ProductFop)fop5)) {
                            subagentFopTypes.add(fop5.getType());
                            continue;
                        }
                        subagentFeesFopTypes.add(fop5.getType());
                    }
                }
                BigDecimal subagencyContractFare = MiscUtil.guarded((BigDecimal)subagentContractRelation.getServiceData().getDetalization().getFare());
                BigDecimal subagencyContractPenalty = MiscUtil.guarded((BigDecimal)subagentContractRelation.getServiceData().getDetalization().getPenalty());
                List taxes = subagentContractRelation.getServiceData().getDetalization().getTaxes();
                BigDecimal subagencyContractTaxesSum = taxes.stream().map(SimpleTax::getAmount).filter(Objects::nonNull).reduce((xva$0, xva$1) -> MiscUtil.sum((BigDecimal[])new BigDecimal[]{xva$0, xva$1})).orElse(BigDecimal.ZERO);
                List<String> taxesForBlankCodes = Arrays.asList(AirProductTaxHelper.getTaxesForBlankCodes((DictionaryReference)airline));
                BigDecimal subagencyContractTaxesForBlankSum = taxes.stream().filter(tax -> TextUtil.nonBlank((String)tax.getCode()) && taxesForBlankCodes.contains(tax.getCode())).map(SimpleTax::getAmount).filter(Objects::nonNull).reduce((xva$0, xva$1) -> MiscUtil.sum((BigDecimal[])new BigDecimal[]{xva$0, xva$1})).orElse(BigDecimal.ZERO);
                BigDecimal subagencyContractOtherTaxesSum = MiscUtil.sub((BigDecimal)subagencyContractTaxesSum, (BigDecimal[])new BigDecimal[]{subagencyContractTaxesForBlankSum});
                data.setSubagencyContractFare(refund ? subagencyContractFare.negate() : subagencyContractFare);
                data.setSubagencyContractPenalty(subagencyContractPenalty);
                if (product.getProductCategory() == ProductCategory.MCO && product.getMcoCategory() == MCOCategory.PENALTY) {
                    data.setSubagencyContractFare(BigDecimal.ZERO);
                    data.setSubagencyContractPenalty(subagencyContractFare);
                }
                data.setSubagencyContractTaxesForBlankSum(refund ? subagencyContractTaxesForBlankSum.negate() : subagencyContractTaxesForBlankSum);
                data.setSubagencyContractOtherTaxesSum(refund ? subagencyContractOtherTaxesSum.negate() : subagencyContractOtherTaxesSum);
                data.setSubagencyContractTotalSum(BookingHelper.calculateProductPrice((BaseProduct)product, (ContractType)ContractType.SUBAGENCY).getTotal());
            }
            data.setSubagentFopTypes(subagentFopTypes);
            data.setSubagentFeesFopTypes(subagentFeesFopTypes);
            data.setPayers((Collection)GeneralProductHelper.getClientFops((BaseProduct)product).stream().filter(fop -> fop.getPayer() != null).map(fop -> fop.getPayer()).collect(Collectors.toSet()));
        } else {
            data.setValid(Boolean.valueOf(true));
            data.setHasOtherErrors(Boolean.valueOf(false));
            data.setHasErrors(Boolean.valueOf(false));
            BaseCommonProductIndexHandler.setVoidFees(data, (BaseProduct)product);
        }
        String notes = product.getReservation().getBookingFile().getNotes();
        data.setHasNotes(Boolean.valueOf(notes != null && !notes.trim().isEmpty()));
        boolean inFinanceDocuments = IndexBuilderHelper.isInFinanceDocuments((BaseProduct)product);
        data.setInFinanceDocuments(Boolean.valueOf(inFinanceDocuments));
        boolean inDelivery = IndexBuilderHelper.isInDelivery((BaseProduct)product);
        data.setInDelivery(Boolean.valueOf(inDelivery));
        StringBuilder email = new StringBuilder();
        if (product.getReservation().getBookingFile() != null && product.getReservation().getBookingFile().getCustomer() != null) {
            for (Communication c : product.getReservation().getBookingFile().getCustomer().getCommunications()) {
                if (c == null || !CommunicationType.EMAIL.equals((Object)c.getType()) || TextUtil.isBlank((String)c.getSense())) continue;
                email = email.append(email.length() > 0 ? ", " + c.getSense() : c.getSense());
            }
        }
        if (!TextUtil.isBlank((String)email.toString())) {
            data.setEmail(TextUtil.adjustStringToLimit((String)email.toString(), (String)", ", (int)255));
            aggregator.aggregate((Object)email.toString());
        }
        ArrayList<DictionaryReference> opCarriersRef = new ArrayList<DictionaryReference>();
        int segCount = 0;
        for (SegmentTariff st : product.getSegmentTariffs()) {
            for (Segment seg : st.getSegments()) {
                ++segCount;
                if (seg.getCodeShareCarrier() == null || opCarriersRef.contains(seg.getCodeShareCarrier())) continue;
                opCarriersRef.add(seg.getCodeShareCarrier());
            }
        }
        data.setSegmentsCount(Integer.valueOf(segCount));
        data.setOperatingCarriers(opCarriersRef);
        EntityContainer agentContainer = EntityStorage.get().resolve(product.getCashier());
        if (agentContainer != null) {
            Person agent = (Person)agentContainer.getEntity();
            for (PersonMetadata meta : agent.getMetadata()) {
                if (meta.getKey() == null || meta.getKey().getCode() == null || !MetadataKey.KEY_PERSON_PROFILE_GROUP.name().equals(meta.getKey().getCode())) continue;
                DictionaryReference profileGroup = (DictionaryReference)meta.getValue();
                if (profileGroup != null) {
                    aggregator.aggregate((Object)profileGroup);
                }
                data.setProfileGroup(profileGroup);
            }
        }
        data.setAggregator(aggregator);
        this.updateStatisticalData(data, product.getStatisticalData(), (EntityReference<Organization>)product.getReservation().getBookingFile().getCustomerProfile());
        data.setAggregator(null);
        Set shipments = product.getFopDetalizations().values().stream().flatMap(item -> item.getComponents().stream()).filter(item -> item.getShipment() != null).map(item -> item.getShipment()).collect(Collectors.toSet());
        data.setShipments(shipments);
        aggregator.aggregate(shipments);
        data.setShipmentsDate(product.getShipmentsDate());
        data.setShipmentsDateSubagent(product.getShipmentsDateSubagent());
        data.setFopComponentsAllUsed(Boolean.valueOf(product.getFopDetalizations().values().stream().flatMap(item -> item.getComponents().stream()).allMatch(item -> item.getShipment() != null)));
        String comments = TextUtil.getFieldOrTrimToLength((String)product.getComments(), (int)255);
        data.setComments(comments);
        aggregator.aggregate((Object)comments);
        EntityReference clientPrepaymentDocument = null;
        EntityReference subagentPrepaymentDocument = null;
        for (EntityReference prepaymentDocumentReference : product.getPrepaymentDocuments()) {
            EntityContainer contract;
            EntityContainer prepaymentDocument = EntityStorage.get().resolve(prepaymentDocumentReference);
            if (prepaymentDocument == null || (contract = EntityStorage.get().resolve(((FinanceDocument)prepaymentDocument.getEntity()).getContract())) == null) continue;
            if (((Contract)contract.getEntity()).getContractType() == ContractType.CLIENT) {
                clientPrepaymentDocument = prepaymentDocumentReference;
                continue;
            }
            if (((Contract)contract.getEntity()).getContractType() != ContractType.SUBAGENCY) continue;
            subagentPrepaymentDocument = prepaymentDocumentReference;
        }
        data.setClientPrepaymentDocument(clientPrepaymentDocument);
        data.setSubagentPrepaymentDocument(subagentPrepaymentDocument);
        aggregator.aggregate(clientPrepaymentDocument);
        aggregator.aggregate(subagentPrepaymentDocument);
        Set receipts = product.getFopDetalizations().values().stream().flatMap(fopDetalization -> fopDetalization.getComponents().stream()).map(FopComponent::getReceipt).collect(Collectors.toSet());
        data.setReceipts(receipts);
        Set travellersGroups = GeneralProductHelper.getHandler((BaseProduct)product).getTravellers((BaseProduct)product).stream().map(item -> EntityStorage.get().resolve(item.getPassenger())).filter(item -> item != null).flatMap(item -> ((Person)item.getEntity()).getMetadata().stream()).filter(item -> item.getKey() != null && item.getValue() != null && MiscUtil.equals((Object)item.getKey().getCode(), (Object)MetadataKey.KEY_PERSON_PROFILE_GROUP.name())).map(item -> (ProfileGroupReference)item.getValue()).collect(Collectors.toSet());
        data.setTravellersGroups(travellersGroups);
        aggregator.aggregate(travellersGroups);
        Set agentsGroups = Optional.ofNullable(EntityStorage.get().resolve(GeneralProductHelper.getHandler((BaseProduct)product).findIssuingAgent((BaseProduct)product))).map(item -> ((Person)item.getEntity()).getMetadata()).orElse(Collections.emptyList()).stream().filter(item -> item.getKey() != null && item.getValue() != null && MiscUtil.equals((Object)item.getKey().getCode(), (Object)MetadataKey.KEY_PERSON_PROFILE_GROUP.name())).map(item -> (ProfileGroupReference)item.getValue()).collect(Collectors.toSet());
        data.setAgentsGroups(agentsGroups);
        aggregator.aggregate(agentsGroups);
        this.fillProductVoidingData(data, etc, product);
    }

    private String buildFullNumber(List<String> numbers) {
        StringBuilder sb = new StringBuilder();
        for (String number : numbers) {
            if (TextUtil.isBlank((String)number)) continue;
            if (sb.length() == 0) {
                sb.append(number.trim());
                continue;
            }
            sb.append("/").append(number.trim().substring(number.trim().length() - 1));
        }
        return sb.length() > 0 ? sb.toString() : null;
    }

    private void fillProductVoidingData(CommonProductIndexData data, EntityContainer<BookingFile> etc, Product product) {
        ProductVoiding productVoiding = BookingStreamHelper.getProductsStream((BookingFile)((BookingFile)etc.getEntity()), ProductVoiding.class).filter(p -> p.getRelatedProduct() != null && MiscUtil.equals((Object)product.getUid(), (Object)p.getRelatedProduct().getUid())).findFirst().orElse(null);
        if (productVoiding != null) {
            data.setProductVoidingUid(productVoiding.getUid());
            TicketType ticketType = productVoiding.getTicketType() != null ? productVoiding.getTicketType() : TicketType.OWN;
            data.setProductVoidingTicketType(ticketType);
            data.setProductVoidingFopComponentsAllUsed(Boolean.valueOf(productVoiding.getFopDetalizations().values().stream().flatMap(item -> item.getComponents().stream()).allMatch(item -> item.getShipment() != null)));
            data.setProductVoidingShipmentsDate(productVoiding.getShipmentsDate());
            data.setProductVoidingShipmentsDateSubagent(productVoiding.getShipmentsDateSubagent());
        }
    }
}

