/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.model.index;

import com.gridnine.xtrip.common.model.EntityContainer;
import com.gridnine.xtrip.common.model.EntityReference;
import com.gridnine.xtrip.common.model.booking.BaseProduct;
import com.gridnine.xtrip.common.model.booking.BookingFile;
import com.gridnine.xtrip.common.model.booking.ProductStatus;
import com.gridnine.xtrip.common.model.booking.Reservation;
import com.gridnine.xtrip.common.model.booking.TicketType;
import com.gridnine.xtrip.common.model.booking.Traveller;
import com.gridnine.xtrip.common.model.booking.air.Product;
import com.gridnine.xtrip.common.model.booking.archive.ArchivedBooking;
import com.gridnine.xtrip.common.model.booking.archive.ArchivedBookingHelper;
import com.gridnine.xtrip.common.model.booking.archive.ArchivedProductIndex;
import com.gridnine.xtrip.common.model.booking.archive.ArchivedProductIndexData;
import com.gridnine.xtrip.common.model.booking.commission.ProductType;
import com.gridnine.xtrip.common.model.dict.Airline;
import com.gridnine.xtrip.common.model.dict.DictionaryCache;
import com.gridnine.xtrip.common.model.dict.GdsName;
import com.gridnine.xtrip.common.model.entity.EntityStorage;
import com.gridnine.xtrip.common.model.handlers.HandlersRegistry;
import com.gridnine.xtrip.common.model.handlers.ProductHandler;
import com.gridnine.xtrip.common.model.helpers.CommonReservationGdsNameInfoHelper;
import com.gridnine.xtrip.common.model.helpers.GeneralProductHelper;
import com.gridnine.xtrip.common.model.profile.Organization;
import com.gridnine.xtrip.common.util.CompositeNumber;
import com.gridnine.xtrip.common.util.TextUtil;
import com.gridnine.xtrip.server.db.storage.model.BaseIndexData;
import com.gridnine.xtrip.server.db.storage.model.DataAggregator;
import com.gridnine.xtrip.server.db.storage.model.IndexHandler;
import com.gridnine.xtrip.server.model.helpers.IndexBuilderHelper;
import java.util.Collection;
import java.util.List;

public class ArchivedProductIndexHandler
implements IndexHandler<ArchivedBooking, ArchivedProductIndex> {
    public Class<? extends BaseIndexData<ArchivedBooking, ArchivedProductIndex>> getDataClass() {
        return ArchivedProductIndexData.class;
    }

    public Class<ArchivedProductIndex> getIndexClass() {
        return ArchivedProductIndex.class;
    }

    public Class<ArchivedBooking> getEntityType() {
        return ArchivedBooking.class;
    }

    public void create(EntityContainer<ArchivedBooking> etc, Collection<BaseIndexData<ArchivedBooking, ArchivedProductIndex>> indexes) throws Exception {
        EntityContainer<BookingFile> bookingFileContainer = this.getBookingContainer(etc);
        if (bookingFileContainer == null) {
            return;
        }
        this.updateIndexData(bookingFileContainer, indexes);
    }

    protected void updateIndexData(EntityContainer<BookingFile> bookingFileContainer, Collection<BaseIndexData<ArchivedBooking, ArchivedProductIndex>> indexes) throws Exception {
        BookingFile bookingFile = (BookingFile)bookingFileContainer.getEntity();
        for (Reservation res : bookingFile.getReservations()) {
            for (BaseProduct bp : this.collectProducts(res)) {
                ArchivedProductIndexData indexData = new ArchivedProductIndexData();
                indexes.add((BaseIndexData<ArchivedBooking, ArchivedProductIndex>)indexData);
                DataAggregator aggregator = new DataAggregator();
                this.updateIndexData(indexData, bp, aggregator, bookingFileContainer.getUid(), bookingFile, res);
                indexData.setAggregatedData(aggregator.toString());
            }
        }
    }

    protected Collection<BaseProduct> collectProducts(Reservation res) {
        return res.getProducts();
    }

    protected void updateIndexData(ArchivedProductIndexData indexData, BaseProduct bp, DataAggregator aggregator, String bookingFileContainerUid, BookingFile bookingFile, Reservation reservation) throws Exception {
        ProductHandler handler = HandlersRegistry.get().findProductHandler(bp.getClass());
        EntityReference agency = GeneralProductHelper.getAgency((BaseProduct)bp);
        indexData.setAgency(agency);
        aggregator.aggregate((Object)agency);
        EntityReference agent = handler.findIssuingAgent(bp);
        indexData.setAgent(agent);
        aggregator.aggregate((Object)agent);
        EntityReference blankOwner = handler.getBlankOwner(bp);
        indexData.setBlankOwner(blankOwner);
        aggregator.aggregate((Object)blankOwner);
        String bookingNumber = TextUtil.buildFullNumber((CompositeNumber)bookingFile);
        indexData.setBookingNumber(bookingNumber);
        aggregator.aggregate((Object)bookingNumber);
        indexData.setBookingContainerUid(bookingFileContainerUid);
        EntityReference client = bookingFile.getCustomerProfile();
        indexData.setClient(client);
        aggregator.aggregate((Object)client);
        EntityContainer clientContainer = EntityStorage.get().resolve(bp.getReservation().getBookingFile().getCustomerProfile());
        if (clientContainer != null) {
            indexData.setHolding(((Organization)clientContainer.getEntity()).getHolding());
            aggregator.aggregate((Object)((Organization)clientContainer.getEntity()).getHolding());
        }
        indexData.setIssueDate(handler.findIssueDate(bp));
        indexData.setNavigationKey(bp.getUid());
        List productNumbers = handler.getProductNumbers(bp);
        String productNumber = productNumbers.isEmpty() ? null : (String)productNumbers.get(0);
        indexData.setProductNumber(productNumber);
        aggregator.aggregate((Object)productNumber);
        ProductType productType = handler.getProductType(bp);
        indexData.setProductType(productType);
        indexData.setTravelSubject(handler.findTravelSubject(bp));
        aggregator.aggregate((Enum)productType);
        if (bp instanceof Product) {
            Product prod = (Product)bp;
            Airline airline = (Airline)DictionaryCache.get().resolveReference(prod.getCarrier());
            String providerCode = airline == null ? null : airline.getAirlineNumber();
            indexData.setProviderCode(providerCode);
            aggregator.aggregate((Object)providerCode);
        }
        List<String> recordLocators = IndexBuilderHelper.getRecordLocators(reservation);
        indexData.setRecordLocators(recordLocators);
        aggregator.aggregate(recordLocators);
        String displayedRecordLocator = CommonReservationGdsNameInfoHelper.getDisplayedRecordLocator((Reservation)reservation);
        indexData.setDisplayedRecordLocator(displayedRecordLocator);
        aggregator.aggregate((Object)displayedRecordLocator);
        List<GdsName> gdsNames = IndexBuilderHelper.getGdsNames(reservation);
        indexData.setGdsNames(gdsNames);
        aggregator.aggregate(gdsNames);
        ProductStatus status = handler.getStatus(bp);
        indexData.setStatus(status);
        aggregator.aggregate((Enum)status);
        EntityReference subagency = GeneralProductHelper.getSubagency((BaseProduct)bp);
        indexData.setSubagency(subagency);
        aggregator.aggregate((Object)subagency);
        Collection travellers = handler.getTravellers(bp);
        TicketType ticketType = handler.getTicketType(bp);
        indexData.setTicketType(ticketType);
        aggregator.aggregate((Enum)ticketType);
        String travellerName = null;
        if (travellers.size() == 1) {
            travellerName = ((Traveller)travellers.iterator().next()).getName();
            indexData.setTravellerName(travellerName);
        } else if (travellers.size() > 1) {
            StringBuilder sb = new StringBuilder();
            int n = 0;
            for (Traveller item : travellers) {
                if (n >= 1) {
                    sb.append(", ");
                }
                sb.append(item.getName());
                ++n;
            }
            travellerName = sb.toString();
        }
        indexData.setTravellerName(TextUtil.getFieldOrTrimToLength((String)travellerName, (int)255));
        aggregator.aggregate((Object)travellerName);
    }

    protected EntityContainer<BookingFile> getBookingContainer(EntityContainer<ArchivedBooking> etc) {
        return ArchivedBookingHelper.getBookingContainer((ArchivedBooking)((ArchivedBooking)etc.getEntity()));
    }
}

