/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.model.index;

import com.gridnine.xtrip.common.model.EntityContainer;
import com.gridnine.xtrip.common.model.EntityReference;
import com.gridnine.xtrip.common.model.booking.BaseProduct;
import com.gridnine.xtrip.common.model.booking.BookingFile;
import com.gridnine.xtrip.common.model.booking.CommonProductFopIndex;
import com.gridnine.xtrip.common.model.booking.CommonProductFopIndexData;
import com.gridnine.xtrip.common.model.booking.GeneralProductContractRelationData;
import com.gridnine.xtrip.common.model.booking.GeneralProductFop;
import com.gridnine.xtrip.common.model.booking.ProductStatus;
import com.gridnine.xtrip.common.model.booking.Reservation;
import com.gridnine.xtrip.common.model.booking.Traveller;
import com.gridnine.xtrip.common.model.dict.Airline;
import com.gridnine.xtrip.common.model.dict.ContractType;
import com.gridnine.xtrip.common.model.dict.DictionaryCache;
import com.gridnine.xtrip.common.model.dict.DictionaryReference;
import com.gridnine.xtrip.common.model.entity.EntityStorage;
import com.gridnine.xtrip.common.model.handlers.ProductHandler;
import com.gridnine.xtrip.common.model.helpers.GeneralProductHelper;
import com.gridnine.xtrip.common.model.profile.Card;
import com.gridnine.xtrip.common.model.profile.Organization;
import com.gridnine.xtrip.common.util.CompositeNumber;
import com.gridnine.xtrip.common.util.TextUtil;
import com.gridnine.xtrip.server.db.storage.model.BaseIndexData;
import com.gridnine.xtrip.server.db.storage.model.DataAggregator;
import com.gridnine.xtrip.server.db.storage.model.IndexHandler;
import com.gridnine.xtrip.server.model.helpers.IndexBuilderHelper;
import java.math.BigDecimal;
import java.util.Collection;
import java.util.Date;
import java.util.HashSet;
import java.util.Objects;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class BaseCommonProductFopIndexHandler
implements IndexHandler<BookingFile, CommonProductFopIndex> {
    protected Logger log = LoggerFactory.getLogger(this.getClass());

    protected void updateData(Collection<BaseIndexData<BookingFile, CommonProductFopIndex>> datas, BaseProduct product) {
        DataAggregator aggregator = new DataAggregator();
        ProductHandler handler = GeneralProductHelper.getHandler((BaseProduct)product);
        ProductStatus status = handler.getStatus(product);
        for (GeneralProductContractRelationData contractRelationData : handler.getUnmodifiableContractRelations(product)) {
            ContractType contractType = GeneralProductHelper.getContractType((EntityReference)contractRelationData.getDescription());
            DictionaryReference currency = contractRelationData.getGeneralData().getCurrency();
            String currencyCode = Objects.nonNull(currency) ? currency.getCode() : null;
            for (GeneralProductFop fop : contractRelationData.getFops()) {
                CommonProductFopIndexData data = new CommonProductFopIndexData();
                data.setAggregator(aggregator);
                data.setContractType(contractType);
                this.updateProductData(data, product, (ProductHandler<BaseProduct>)handler);
                this.updateFopData(data, fop, status, currencyCode);
                if (contractType == ContractType.CLIENT) {
                    data.setRefuse(Boolean.valueOf(fop.isRefused()));
                }
                data.setAggregatedData(aggregator.toString());
                aggregator.reset();
                datas.add((BaseIndexData<BookingFile, CommonProductFopIndex>)data);
            }
        }
    }

    protected void updateProductData(CommonProductFopIndexData data, BaseProduct product, ProductHandler<BaseProduct> handler) {
        data.setProductUid(product.getUid());
        Reservation reservation = product.getReservation();
        this.updateBookingFileData(data, reservation.getBookingFile());
        this.updateReservationData(data, reservation);
        data.setProductType(handler.getProductType(product));
        data.setSupplier(GeneralProductHelper.getSupplier((BaseProduct)product));
        data.setAgency(GeneralProductHelper.getAgency((BaseProduct)product));
        data.setSubagency(GeneralProductHelper.getSubagency((BaseProduct)product));
        this.updateBlankOwnerData(data, (EntityReference<Organization>)handler.getBlankOwner(product));
        data.setBranch(handler.getBranch(product));
        data.setSalesPoint(handler.findSalesPoint(product));
        data.setAgent(handler.findIssuingAgent(product));
        data.setTicketType(handler.getTicketType(product));
        data.setStatus(handler.getStatus(product));
        data.setSystemNumbers((Collection)handler.getProductNumbers(product));
        data.setFirstTravelDate(handler.findFirstTravelDate(product));
        data.setLastTravelDate(handler.findLastTravelDate(product));
        data.setServiceLocationType(handler.getServiceLocationType(product));
        this.updateTravellersData(data, handler.getTravellers(product));
        Date issueDate = handler.findIssueDate(product);
        data.setIssueDate(issueDate);
        data.setIssueDateTime(issueDate);
        String routeLine = handler.getRouteLine(product);
        data.setRouteLine(TextUtil.getFieldOrTrimToLength((String)routeLine, (int)255));
    }

    private void updateBookingFileData(CommonProductFopIndexData data, BookingFile bookingFile) {
        data.setBookingNumber(TextUtil.buildFullNumber((CompositeNumber)bookingFile));
        this.updateClientData(data, (EntityReference<Organization>)bookingFile.getCustomerProfile());
        data.setHasComments(Boolean.valueOf(!TextUtil.isBlank((String)bookingFile.getNotes())));
    }

    private void updateReservationData(CommonProductFopIndexData data, Reservation reservation) {
        IndexBuilderHelper.updateReservationGdsNameInfo(reservation, data, null);
    }

    private void updateClientData(CommonProductFopIndexData data, EntityReference<Organization> clientRef) {
        data.setClient(clientRef);
        EntityContainer clientCtr = EntityStorage.get().resolve(clientRef);
        if (clientCtr != null) {
            data.setHolding(((Organization)clientCtr.getEntity()).getHolding());
        }
    }

    protected void updateBlankOwnerData(CommonProductFopIndexData data, EntityReference<Organization> blankOwnerRef) {
        data.setBlankOwner(blankOwnerRef);
        String blankOwnerCode = null;
        String blankOwnerAirlineNumber = null;
        if (Objects.nonNull(blankOwnerRef)) {
            try {
                EntityContainer blankOwnerCtr = EntityStorage.get().resolve(blankOwnerRef);
                if (blankOwnerCtr != null) {
                    Airline airline = (Airline)DictionaryCache.get().resolveReference(((Organization)blankOwnerCtr.getEntity()).getAirline());
                    if (airline != null) {
                        blankOwnerAirlineNumber = airline.getAirlineNumber();
                    }
                    blankOwnerCode = ((Organization)blankOwnerCtr.getEntity()).getCode();
                }
            }
            catch (Exception e) {
                this.log.error("unable to resolve blank owner", (Throwable)e);
            }
        }
        data.setBlankOwnerCode(blankOwnerCode);
        data.setBlankOwnerAirlineNumber(blankOwnerAirlineNumber);
    }

    protected void updateTravellersData(CommonProductFopIndexData data, Collection<Traveller> travellers) {
        HashSet<String> travellersNames = new HashSet<String>();
        for (Traveller traveller : travellers) {
            if (traveller.getName() == null) continue;
            travellersNames.add(traveller.getName());
        }
        data.setTravellersNames(travellersNames);
    }

    protected void updateFopData(CommonProductFopIndexData data, GeneralProductFop fop, ProductStatus status, String currencyCode) {
        data.setFopUid(fop.getUid());
        data.setFopType(GeneralProductHelper.getFopType((GeneralProductFop)fop));
        data.setPaymentType(fop.getType());
        data.setRelatedTicketNumber(fop.getRelatedTicketNumber());
        data.setFopAgent(fop.getAgent());
        data.setFopDate(fop.getOperationDate());
        data.setPayer(fop.getPayer());
        data.setPassengerStatus(fop.getPassengerStatus());
        BigDecimal equivalentAmount = fop.getEquivalentAmount();
        if (equivalentAmount != null && (status == ProductStatus.REFUND || status == ProductStatus.EXCHANGE)) {
            equivalentAmount = equivalentAmount.negate();
        }
        data.setAmount(equivalentAmount);
        data.setCurrency(currencyCode);
        if (fop.getCard() != null) {
            Card card = fop.getCard();
            data.setCardVendor(card.getVendor());
            data.setCardNumber(card.getNumber());
            data.setCardSecurityCode(card.getSecurityCode());
        }
    }
}

