/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.model.index;

import com.gridnine.xtrip.common.model.EntityContainer;
import com.gridnine.xtrip.common.model.EntityReference;
import com.gridnine.xtrip.common.model.booking.BaseProduct;
import com.gridnine.xtrip.common.model.booking.BookingFile;
import com.gridnine.xtrip.common.model.booking.CommonProductIndex;
import com.gridnine.xtrip.common.model.booking.CommonProductIndexData;
import com.gridnine.xtrip.common.model.booking.FopComponent;
import com.gridnine.xtrip.common.model.booking.GeneralProductContractRelationData;
import com.gridnine.xtrip.common.model.booking.GeneralProductFop;
import com.gridnine.xtrip.common.model.booking.ProductStatus;
import com.gridnine.xtrip.common.model.booking.Reservation;
import com.gridnine.xtrip.common.model.booking.StatisticalData;
import com.gridnine.xtrip.common.model.booking.TicketType;
import com.gridnine.xtrip.common.model.booking.TravelSubject;
import com.gridnine.xtrip.common.model.booking.Traveller;
import com.gridnine.xtrip.common.model.booking.ValidationMessage;
import com.gridnine.xtrip.common.model.booking.ValidationMessageCategory;
import com.gridnine.xtrip.common.model.booking.ValidationMessageSeverity;
import com.gridnine.xtrip.common.model.dict.Airline;
import com.gridnine.xtrip.common.model.dict.ContractType;
import com.gridnine.xtrip.common.model.dict.DictionaryCache;
import com.gridnine.xtrip.common.model.dict.DictionaryReference;
import com.gridnine.xtrip.common.model.dict.ProfileGroup;
import com.gridnine.xtrip.common.model.dict.ProfileGroupReference;
import com.gridnine.xtrip.common.model.entity.EntityStorage;
import com.gridnine.xtrip.common.model.finance.FinanceDocument;
import com.gridnine.xtrip.common.model.handlers.ProductHandler;
import com.gridnine.xtrip.common.model.handlers.ProductStatusHandler;
import com.gridnine.xtrip.common.model.helpers.BookingHelper;
import com.gridnine.xtrip.common.model.helpers.GeneralProductHelper;
import com.gridnine.xtrip.common.model.helpers.StatisticsHelper;
import com.gridnine.xtrip.common.model.helpers.SystemHelper;
import com.gridnine.xtrip.common.model.profile.Contract;
import com.gridnine.xtrip.common.model.profile.CostCode;
import com.gridnine.xtrip.common.model.profile.Organization;
import com.gridnine.xtrip.common.model.profile.Person;
import com.gridnine.xtrip.common.model.system.Metadata;
import com.gridnine.xtrip.common.model.system.MetadataKey;
import com.gridnine.xtrip.common.model.system.PaymentType;
import com.gridnine.xtrip.common.model.system.VatAmount;
import com.gridnine.xtrip.common.util.CompositeNumber;
import com.gridnine.xtrip.common.util.MiscUtil;
import com.gridnine.xtrip.common.util.TextUtil;
import com.gridnine.xtrip.server.db.storage.model.IndexHandler;
import com.gridnine.xtrip.server.model.helpers.IndexBuilderHelper;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.EnumSet;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class BaseCommonProductIndexHandler
implements IndexHandler<BookingFile, CommonProductIndex> {
    protected Logger log = LoggerFactory.getLogger(this.getClass());

    protected void updateData(CommonProductIndexData data, BaseProduct product) {
        Reservation reservation = product.getReservation();
        this.updateBookingFileData(data, reservation.getBookingFile());
        this.updateReservationData(data, reservation);
        IndexBuilderHelper.updateChangeDataSources(product, data);
        data.setNavigationKey(product.getUid());
        Set shipments = product.getFopDetalizations().values().stream().flatMap(item -> item.getComponents().stream()).filter(item -> item.getShipment() != null).map(item -> item.getShipment()).collect(Collectors.toSet());
        data.setShipments(shipments);
        data.setShipmentsDate(product.getShipmentsDate());
        data.setShipmentsDateSubagent(product.getShipmentsDateSubagent());
        data.setFopComponentsAllUsed(Boolean.valueOf(product.getFopDetalizations().values().stream().flatMap(item -> item.getComponents().stream()).allMatch(item -> item.getShipment() != null)));
        ProductHandler handler = GeneralProductHelper.getHandler((BaseProduct)product);
        GeneralProductContractRelationData vendorContractRelation = GeneralProductHelper.getVendorContractRelationByReflection((BaseProduct)product);
        GeneralProductContractRelationData clientContractRelation = GeneralProductHelper.getClientContractRelationByReflection((BaseProduct)product);
        EntityReference clientRelationMediator = GeneralProductHelper.getClientRelationMediator((BaseProduct)product);
        data.setMediator(clientRelationMediator);
        BaseProduct nextProduct = handler.getNextProduct(product);
        data.setNextProductUid(nextProduct == null ? null : nextProduct.getUid());
        this.updateBlankOwnerData(data, (EntityReference<Organization>)handler.getBlankOwner(product));
        ProductStatus status = handler.getStatus(product);
        data.setStatus(status);
        Date firstTravelDate = handler.findFirstTravelDate(product);
        data.setFirstDepartureDate(firstTravelDate);
        Date lastTravelDate = handler.findLastTravelDate(product);
        data.setLastArrivalDate(lastTravelDate);
        Date issueDate = handler.findIssueDate(product);
        data.setIssueDate(issueDate);
        data.setIssueDateTime(issueDate);
        data.setLocalIssueDate(handler.findLocalIssueDate(product));
        data.setSystemNumbers((Collection)handler.getProductNumbers(product));
        data.setTicketType((TicketType)MiscUtil.guarded((Object)handler.getTicketType(product), (Object)TicketType.OWN));
        data.setChecked(Boolean.valueOf(handler.isChecked(product)));
        data.setCompleted(Boolean.valueOf(handler.isCompleted(product)));
        data.setAgent(handler.findIssuingAgent(product));
        data.setSalesPoint(handler.findSalesPoint(product));
        this.updateTravellersData(data, handler.getTravellers(product));
        TravelSubject travelSubject = handler.findTravelSubject(product);
        data.setTravelSubject(travelSubject);
        if (Objects.nonNull(travelSubject)) {
            data.setDescription(travelSubject.toString());
        }
        data.setProductType(handler.getProductType(product));
        String routeLine = handler.getRouteLine(product);
        data.setRouteLine(TextUtil.getFieldOrTrimToLength((String)routeLine, (int)255));
        data.setAgency(GeneralProductHelper.getAgency((BaseProduct)product));
        EntityReference subagencyRef = GeneralProductHelper.getSubagency((BaseProduct)product);
        data.setSubagency(subagencyRef);
        data.setSupplier(GeneralProductHelper.getSupplier((BaseProduct)product));
        data.setMilitaryClaimNumber(GeneralProductHelper.getMilitaryClaimNumber((BaseProduct)product));
        if (subagencyRef != null) {
            try {
                EntityContainer subagencyCtr = EntityStorage.get().resolve(subagencyRef);
                if (subagencyCtr != null) {
                    Organization subagency = (Organization)subagencyCtr.getEntity();
                    data.setSubagencyGroups(this.getProfileGroups(subagency));
                }
            }
            catch (Throwable e) {
                this.log.error("unable to load profile " + subagencyRef, e);
            }
        }
        data.setOperationBatch(BookingHelper.getOperationBatch((BaseProduct)product));
        String sortingNumber = BookingHelper.getSortingTicketNumber((BaseProduct)product);
        if (sortingNumber == null) {
            sortingNumber = BookingHelper.getSystemNumber((BaseProduct)product);
        }
        data.setSortingTicketNumber(sortingNumber);
        data.setInFinanceDocuments(Boolean.valueOf(IndexBuilderHelper.isInFinanceDocuments(product)));
        data.setInDelivery(Boolean.valueOf(IndexBuilderHelper.isInDelivery(product)));
        this.updateStatisticalData(data, handler.getStatisticalData(product), (EntityReference<Organization>)product.getReservation().getBookingFile().getCustomerProfile());
        boolean refund = status == ProductStatus.REFUND || status == ProductStatus.EXCHANGE;
        boolean exchange = status == ProductStatus.EXCHANGE;
        this.updateClentFopsData(data, clientContractRelation.getFops(), refund, exchange, status);
        this.updateVendorFopsData(data, vendorContractRelation.getFops(), refund, status);
        if (!ProductStatusHandler.getAllVoidStatuses().contains(status)) {
            BaseProduct previousProduct = handler.getPreviousProduct(product);
            if (refund && Objects.nonNull(previousProduct)) {
                EntityReference sellAgent = handler.findIssuingAgent(previousProduct);
                data.setSellAgent(sellAgent);
            }
            for (Object related : handler.getRelatedProducts(product)) {
                String relatedTicketNo = BookingHelper.getSystemNumber((BaseProduct)related);
                if (TextUtil.isBlank((String)relatedTicketNo)) continue;
                data.setRelatedTicketNo(relatedTicketNo);
                break;
            }
            data.setServiceLocationType(handler.getServiceLocationType(product));
            data.setFirstTravelDate(firstTravelDate);
            data.setLastTravelDate(lastTravelDate);
            this.updatePricesData(data, product, (ProductHandler<BaseProduct>)handler, refund);
            this.updateSubagencyContractPricesData(data, product, refund);
            this.updateValidationMessagesData(data, handler.getValidationMessages(product));
            data.setPayers((Collection)GeneralProductHelper.getClientFops((BaseProduct)product).stream().filter(fop -> fop.getPayer() != null).map(fop -> fop.getPayer()).collect(Collectors.toSet()));
        } else {
            data.setValid(Boolean.valueOf(true));
            data.setHasOtherErrors(Boolean.valueOf(false));
            data.setHasErrors(Boolean.valueOf(false));
        }
        EntityReference clientPrepaymentDocument = null;
        EntityReference subagentPrepaymentDocument = null;
        for (EntityReference prepaymentDocumentReference : product.getPrepaymentDocuments()) {
            EntityContainer contract;
            EntityContainer prepaymentDocument = EntityStorage.get().resolve(prepaymentDocumentReference);
            if (prepaymentDocument == null || (contract = EntityStorage.get().resolve(((FinanceDocument)prepaymentDocument.getEntity()).getContract())) == null) continue;
            if (((Contract)contract.getEntity()).getContractType() == ContractType.CLIENT) {
                clientPrepaymentDocument = prepaymentDocumentReference;
                continue;
            }
            if (((Contract)contract.getEntity()).getContractType() != ContractType.SUBAGENCY) continue;
            subagentPrepaymentDocument = prepaymentDocumentReference;
        }
        data.setClientPrepaymentDocument(clientPrepaymentDocument);
        data.setSubagentPrepaymentDocument(subagentPrepaymentDocument);
        Set receipts = product.getFopDetalizations().values().stream().flatMap(fopDetalization -> fopDetalization.getComponents().stream()).map(FopComponent::getReceipt).collect(Collectors.toSet());
        data.setReceipts(receipts);
        Set travellersGroups = GeneralProductHelper.getHandler((BaseProduct)product).getTravellers(product).stream().map(item -> EntityStorage.get().resolve(item.getPassenger())).filter(item -> item != null).flatMap(item -> ((Person)item.getEntity()).getMetadata().stream()).filter(item -> item.getKey() != null && item.getValue() != null && MiscUtil.equals((Object)item.getKey().getCode(), (Object)MetadataKey.KEY_PERSON_PROFILE_GROUP.name())).map(item -> (ProfileGroupReference)item.getValue()).collect(Collectors.toSet());
        data.setTravellersGroups(travellersGroups);
        Set agentsGroups = Optional.ofNullable(EntityStorage.get().resolve(GeneralProductHelper.getHandler((BaseProduct)product).findIssuingAgent(product))).map(item -> ((Person)item.getEntity()).getMetadata()).orElse(Collections.emptyList()).stream().filter(item -> item.getKey() != null && item.getValue() != null && MiscUtil.equals((Object)item.getKey().getCode(), (Object)MetadataKey.KEY_PERSON_PROFILE_GROUP.name())).map(item -> (ProfileGroupReference)item.getValue()).collect(Collectors.toSet());
        data.setAgentsGroups(agentsGroups);
    }

    protected void updateBookingFileData(CommonProductIndexData data, BookingFile bookingFile) {
        data.setBookingNumber(TextUtil.buildFullNumber((CompositeNumber)bookingFile));
        data.setBookingCreateDate(bookingFile.getCreateDate());
        data.setWorkflowStatus(bookingFile.getWorkflowStatus());
        String notes = bookingFile.getNotes();
        data.setHasNotes(Boolean.valueOf(notes != null && !notes.trim().isEmpty()));
        data.setClient(bookingFile.getCustomerProfile());
        try {
            EntityContainer clientCtr = EntityStorage.get().resolve(bookingFile.getCustomerProfile());
            if (clientCtr != null) {
                Organization client = (Organization)clientCtr.getEntity();
                data.setClientAccountingCode(this.getAccountingCode(client));
                data.setClientGroups(this.getProfileGroups(client));
                data.setHolding(client.getHolding());
            }
        }
        catch (Throwable e) {
            this.log.error("unable to load profile " + bookingFile.getCustomerProfile(), e);
        }
    }

    private String getAccountingCode(Organization org) {
        String code = SystemHelper.findMetadataAsString((Collection)org.getMetadata(), (MetadataKey)MetadataKey.KEY_ACCOUNTING_SYSTEM_CODE);
        return (String)MiscUtil.guarded((Object)code, (Object)org.getCode());
    }

    private List<DictionaryReference<ProfileGroup>> getProfileGroups(Organization org) {
        ArrayList<DictionaryReference<ProfileGroup>> result = new ArrayList<DictionaryReference<ProfileGroup>>();
        for (Metadata metadata : org.getMetadata()) {
            if (metadata.getKey() == null || !metadata.getKey().getCode().equals(MetadataKey.KEY_ORGANIZATION_PROFILE_GROUP.name()) || metadata.getValue() == null) continue;
            result.add((DictionaryReference<ProfileGroup>)((ProfileGroupReference)metadata.getValue()));
        }
        return result;
    }

    protected void updateReservationData(CommonProductIndexData data, Reservation reservation) {
        data.setTimeLimit(reservation.getTimeLimit());
        data.setReservationStatus(reservation.getStatus());
        IndexBuilderHelper.updateReservationGdsNameInfo(reservation, data, null);
    }

    protected void updateBlankOwnerData(CommonProductIndexData data, EntityReference<Organization> blankOwnerRef) {
        data.setBlankOwner(blankOwnerRef);
        String blankOwnerCode = null;
        String blankOwnerAirlineNumber = null;
        String providerCode = null;
        String providerName = null;
        if (blankOwnerRef != null) {
            try {
                EntityContainer blankOwnerCtr = EntityStorage.get().resolve(blankOwnerRef);
                if (blankOwnerCtr != null) {
                    Organization blankOwner = (Organization)blankOwnerCtr.getEntity();
                    Airline airline = (Airline)DictionaryCache.get().resolveReference(blankOwner.getAirline());
                    if (airline != null) {
                        blankOwnerAirlineNumber = airline.getAirlineNumber();
                    }
                    blankOwnerCode = blankOwner.getCode();
                    providerCode = blankOwner.getCode();
                    providerName = blankOwnerCtr.toReference().toString();
                }
            }
            catch (Exception e) {
                this.log.error("unable to resolve blank owner", (Throwable)e);
            }
        }
        data.setBlankOwnerCode(blankOwnerCode);
        data.setBlankOwnerAirlineNumber(blankOwnerAirlineNumber);
        data.setProviderCode(providerCode);
        data.setProviderName(providerName);
    }

    protected void updateTravellersData(CommonProductIndexData data, Collection<Traveller> travellers) {
        HashSet<String> passportNumbers = new HashSet<String>();
        HashSet<String> travellersNames = new HashSet<String>();
        HashSet<EntityReference> passengers = new HashSet<EntityReference>();
        for (Traveller trav : travellers) {
            if (trav == null) continue;
            if (trav.getPassport() != null && trav.getPassport().getNumber() != null) {
                passportNumbers.add(trav.getPassport().getNumber());
            }
            if (trav.getName() != null) {
                travellersNames.add(trav.getName());
            }
            if (trav.getPassenger() == null) continue;
            passengers.add(trav.getPassenger());
        }
        data.setTravellersPassportsNumbers(passportNumbers);
        data.setTravellersNames(travellersNames);
        data.setPassengers(passengers);
    }

    protected void updateValidationMessagesData(CommonProductIndexData data, List<ValidationMessage> validationMessages) {
        data.setValid(Boolean.valueOf(true));
        data.setHasOtherErrors(Boolean.valueOf(false));
        data.setHasStockControlErrors(Boolean.valueOf(false));
        data.setHasErrors(Boolean.valueOf(false));
        data.setHasRulesErrors(Boolean.valueOf(false));
        data.setHasShipmentErrors(Boolean.valueOf(false));
        for (ValidationMessage message : validationMessages) {
            if (message.getSeverity() == ValidationMessageSeverity.USER_ERROR) {
                data.setHasUserErrors(Boolean.valueOf(true));
                data.setHasErrors(Boolean.valueOf(true));
            }
            if (message.getSeverity() == ValidationMessageSeverity.SHIPMENT_ERROR) {
                data.setHasShipmentErrors(Boolean.valueOf(true));
            }
            if (message.getSeverity() != ValidationMessageSeverity.ERROR) continue;
            data.setHasErrors(Boolean.valueOf(true));
            if (message.getCategory() == ValidationMessageCategory.OTHER) {
                data.setValid(Boolean.valueOf(false));
                data.setHasOtherErrors(Boolean.valueOf(true));
            }
            if (message.getCategory() == ValidationMessageCategory.STOCK_CONTROL) {
                data.setHasStockControlErrors(Boolean.valueOf(true));
            }
            if (message.getCategory() != ValidationMessageCategory.RULES) continue;
            data.setHasRulesErrors(Boolean.valueOf(true));
        }
    }

    protected void updatePricesData(CommonProductIndexData data, BaseProduct product, ProductHandler<BaseProduct> handler, boolean refund) {
        data.setTaxesSum(BigDecimal.ZERO);
        data.setOtherTaxesSum(BigDecimal.ZERO);
        data.setTaxesForBlankSum(BigDecimal.ZERO);
        BigDecimal equivalentFare = MiscUtil.guarded((BigDecimal)handler.getEquivalentFare(product));
        data.setEquivalentFare(refund ? equivalentFare.negate() : equivalentFare);
        data.setEquivalentFareCurrency(handler.getGdsCurrency(product));
        BigDecimal penalty = MiscUtil.guarded((BigDecimal)handler.getPenalty(product));
        data.setPenalty(penalty);
        VatAmount price = BookingHelper.calculateProductPrice((BaseProduct)product, (ContractType)ContractType.CLIENT);
        BigDecimal totalSum = price.getTotal();
        data.setTotalSum(totalSum);
        data.setVatRate(price.getVat());
        data.setVatValue(price.getVatAmount());
        try {
            data.setVendorCommissionValue(BookingHelper.getCommissionValue((BigDecimal)GeneralProductHelper.calculateCommissionsEquivalentValue((Collection)GeneralProductHelper.filterCommissions((Collection)GeneralProductHelper.getUnmodifiableCommissions((BaseProduct)product, (ContractType)ContractType.VENDOR), (Set)GeneralProductHelper.commissionCommissionPropertyTypes, (Set)GeneralProductHelper.standardCommissionTypes, null)), (boolean)refund));
            data.setVendorBonusValue(BookingHelper.getCommissionValue((BigDecimal)GeneralProductHelper.calculateCommissionsEquivalentValue((Collection)GeneralProductHelper.filterCommissions((Collection)GeneralProductHelper.getUnmodifiableCommissions((BaseProduct)product, (ContractType)ContractType.VENDOR), (Set)GeneralProductHelper.commissionCommissionPropertyTypes, (Set)GeneralProductHelper.bonusCommissionTypes, null)), (boolean)refund));
            data.setVendorFeeValue(BookingHelper.getCommissionValue((BigDecimal)GeneralProductHelper.calculateCommissionsEquivalentValue((Collection)GeneralProductHelper.filterCommissions((Collection)GeneralProductHelper.getUnmodifiableCommissions((BaseProduct)product, (ContractType)ContractType.VENDOR), (Set)GeneralProductHelper.feePropertyTypes, null, null)), (boolean)refund));
            data.setVendorCommissionRate(GeneralProductHelper.calculateCommissionsRateAsDouble((Collection)GeneralProductHelper.filterCommissions((Collection)GeneralProductHelper.getUnmodifiableCommissions((BaseProduct)product, (ContractType)ContractType.VENDOR), (Set)GeneralProductHelper.commissionCommissionPropertyTypes, (Set)GeneralProductHelper.standardCommissionTypes, null), (boolean)true));
            data.setVendorBonusRate(GeneralProductHelper.calculateCommissionsRateAsDouble((Collection)GeneralProductHelper.filterCommissions((Collection)GeneralProductHelper.getUnmodifiableCommissions((BaseProduct)product, (ContractType)ContractType.VENDOR), (Set)GeneralProductHelper.commissionCommissionPropertyTypes, (Set)GeneralProductHelper.bonusCommissionTypes, null), (boolean)true));
            data.setVendorFeeRate(GeneralProductHelper.calculateCommissionsRateAsDouble((Collection)GeneralProductHelper.filterCommissions((Collection)GeneralProductHelper.getUnmodifiableCommissions((BaseProduct)product, (ContractType)ContractType.VENDOR), (Set)GeneralProductHelper.feePropertyTypes, null, null), (boolean)true));
            data.setSubagencyCommissionValue(BookingHelper.getCommissionValue((BigDecimal)GeneralProductHelper.calculateCommissionsEquivalentValue((Collection)GeneralProductHelper.filterCommissions((Collection)GeneralProductHelper.getUnmodifiableCommissions((BaseProduct)product, (ContractType)ContractType.SUBAGENCY), (Set)GeneralProductHelper.commissionCommissionPropertyTypes, (Set)GeneralProductHelper.standardCommissionTypes, null)), (boolean)refund));
            data.setSubagencyBonusValue(BookingHelper.getCommissionValue((BigDecimal)GeneralProductHelper.calculateCommissionsEquivalentValue((Collection)GeneralProductHelper.filterCommissions((Collection)GeneralProductHelper.getUnmodifiableCommissions((BaseProduct)product, (ContractType)ContractType.SUBAGENCY), (Set)GeneralProductHelper.commissionCommissionPropertyTypes, (Set)GeneralProductHelper.bonusCommissionTypes, null)), (boolean)refund));
            data.setSubagencyFeeValue(BookingHelper.getCommissionValue((BigDecimal)GeneralProductHelper.calculateCommissionsEquivalentValue((Collection)GeneralProductHelper.filterCommissions((Collection)GeneralProductHelper.getUnmodifiableCommissions((BaseProduct)product, (ContractType)ContractType.SUBAGENCY), (Set)GeneralProductHelper.feePropertyTypes, null, null)), (boolean)refund));
            data.setSubagencyHiddenFeeValue(BookingHelper.getCommissionValue((BigDecimal)GeneralProductHelper.calculateCommissionsEquivalentValue((Collection)GeneralProductHelper.filterCommissions((Collection)GeneralProductHelper.getUnmodifiableCommissions((BaseProduct)product, (ContractType)ContractType.SUBAGENCY), (Set)GeneralProductHelper.feePropertyTypes, null, (Set)GeneralProductHelper.hiddenCommissionCategories)), (boolean)refund));
            data.setSubagencyCommissionRate(GeneralProductHelper.calculateCommissionsRateAsDouble((Collection)GeneralProductHelper.filterCommissions((Collection)GeneralProductHelper.getUnmodifiableCommissions((BaseProduct)product, (ContractType)ContractType.SUBAGENCY), (Set)GeneralProductHelper.commissionCommissionPropertyTypes, (Set)GeneralProductHelper.standardCommissionTypes, null), (boolean)true));
            data.setSubagencyBonusRate(GeneralProductHelper.calculateCommissionsRateAsDouble((Collection)GeneralProductHelper.filterCommissions((Collection)GeneralProductHelper.getUnmodifiableCommissions((BaseProduct)product, (ContractType)ContractType.SUBAGENCY), (Set)GeneralProductHelper.commissionCommissionPropertyTypes, (Set)GeneralProductHelper.bonusCommissionTypes, null), (boolean)true));
            data.setSubagencyFeeRate(GeneralProductHelper.calculateCommissionsRateAsDouble((Collection)GeneralProductHelper.filterCommissions((Collection)GeneralProductHelper.getUnmodifiableCommissions((BaseProduct)product, (ContractType)ContractType.SUBAGENCY), (Set)GeneralProductHelper.feePropertyTypes, null, null), (boolean)true));
            data.setClientCommissionValue(BookingHelper.getCommissionValue((BigDecimal)GeneralProductHelper.calculateCommissionsEquivalentValue((Collection)GeneralProductHelper.filterCommissions((Collection)GeneralProductHelper.getUnmodifiableCommissions((BaseProduct)product, (ContractType)ContractType.CLIENT), (Set)GeneralProductHelper.commissionCommissionPropertyTypes, (Set)GeneralProductHelper.standardCommissionTypes, null)), (boolean)refund));
            data.setClientBonusValue(BookingHelper.getCommissionValue((BigDecimal)GeneralProductHelper.calculateCommissionsEquivalentValue((Collection)GeneralProductHelper.filterCommissions((Collection)GeneralProductHelper.getUnmodifiableCommissions((BaseProduct)product, (ContractType)ContractType.CLIENT), (Set)GeneralProductHelper.commissionCommissionPropertyTypes, (Set)GeneralProductHelper.bonusCommissionTypes, null)), (boolean)refund));
            data.setClientFeeValue(BookingHelper.getCommissionValue((BigDecimal)GeneralProductHelper.calculateCommissionsEquivalentValue((Collection)GeneralProductHelper.filterCommissions((Collection)GeneralProductHelper.getUnmodifiableCommissions((BaseProduct)product, (ContractType)ContractType.CLIENT), (Set)GeneralProductHelper.feePropertyTypes, null, null)), (boolean)refund));
            data.setClientServiceFeeValue(BookingHelper.getCommissionValue((BigDecimal)GeneralProductHelper.calculateCommissionsEquivalentValue((Collection)GeneralProductHelper.filterCommissions((Collection)GeneralProductHelper.getUnmodifiableCommissions((BaseProduct)product, (ContractType)ContractType.CLIENT), (Set)GeneralProductHelper.serviceFeePropertyTypes, null, null)), (boolean)refund));
            data.setClientPaymentFeeValue(BookingHelper.getCommissionValue((BigDecimal)GeneralProductHelper.calculateCommissionsEquivalentValue((Collection)GeneralProductHelper.filterCommissions((Collection)GeneralProductHelper.getUnmodifiableCommissions((BaseProduct)product, (ContractType)ContractType.CLIENT), (Set)GeneralProductHelper.paymentFeePropertyTypes, null, null)), (boolean)refund));
            data.setClientCommissionRate(GeneralProductHelper.calculateCommissionsRateAsDouble((Collection)GeneralProductHelper.filterCommissions((Collection)GeneralProductHelper.getUnmodifiableCommissions((BaseProduct)product, (ContractType)ContractType.CLIENT), (Set)GeneralProductHelper.commissionCommissionPropertyTypes, (Set)GeneralProductHelper.standardCommissionTypes, null), (boolean)true));
            data.setClientBonusRate(GeneralProductHelper.calculateCommissionsRateAsDouble((Collection)GeneralProductHelper.filterCommissions((Collection)GeneralProductHelper.getUnmodifiableCommissions((BaseProduct)product, (ContractType)ContractType.CLIENT), (Set)GeneralProductHelper.commissionCommissionPropertyTypes, (Set)GeneralProductHelper.bonusCommissionTypes, null), (boolean)true));
            data.setClientFeeRate(GeneralProductHelper.calculateCommissionsRateAsDouble((Collection)GeneralProductHelper.filterCommissions((Collection)GeneralProductHelper.getUnmodifiableCommissions((BaseProduct)product, (ContractType)ContractType.CLIENT), (Set)GeneralProductHelper.feePropertyTypes, null, null), (boolean)true));
            data.setAgentPenaltyForService(BookingHelper.calculateAgentPenaltyForProduct((BaseProduct)product));
            data.setAgentPenaltyForCommissions(null);
            data.setAgentPenaltyForFees(BookingHelper.calculateAgentPenaltyForFees((BaseProduct)product));
        }
        catch (Exception e) {
            this.log.error("failed calculating commissions ", (Throwable)e);
        }
    }

    protected void updateSubagencyContractPricesData(CommonProductIndexData data, BaseProduct product, boolean refund) {
        GeneralProductContractRelationData subagentContractRelation = GeneralProductHelper.getSubagentContractRelation((BaseProduct)product);
        if (subagentContractRelation != null) {
            BigDecimal subagencyContractFare = MiscUtil.guarded((BigDecimal)subagentContractRelation.getServiceData().getDetalization().getFare());
            BigDecimal subagencyContractPenalty = MiscUtil.guarded((BigDecimal)subagentContractRelation.getServiceData().getDetalization().getPenalty());
            data.setSubagencyContractFare(refund ? subagencyContractFare.negate() : subagencyContractFare);
            data.setSubagencyContractPenalty(subagencyContractPenalty);
            data.setSubagencyContractTaxesForBlankSum(BigDecimal.ZERO);
            data.setSubagencyContractOtherTaxesSum(BigDecimal.ZERO);
            data.setSubagencyContractTotalSum(BookingHelper.calculateProductPrice((BaseProduct)product, (ContractType)ContractType.SUBAGENCY).getTotal());
        }
    }

    protected void updateClentFopsData(CommonProductIndexData data, List<GeneralProductFop> clientFops, boolean refund, boolean exchange, ProductStatus status) {
        data.setClientCardVendor(GeneralProductHelper.getCreditCardVendor(clientFops));
        Date refuseDate = null;
        for (GeneralProductFop fop : clientFops) {
            if (!fop.isRefused() || fop.getOperationDate() == null || refuseDate != null && !refuseDate.after(fop.getOperationDate())) continue;
            refuseDate = fop.getOperationDate();
        }
        if (refuseDate != null) {
            data.setCancellationDate(refuseDate);
        }
        if (status != ProductStatus.VOID) {
            Date date = null;
            EntityReference agent = null;
            boolean hasClientDebt = false;
            HashSet<PaymentType> clientFopTypes = new HashSet<PaymentType>();
            HashSet<PaymentType> clientFeesFopTypes = new HashSet<PaymentType>();
            BigDecimal clientFOPAmount = null;
            BigDecimal clientFOPAddAmount = null;
            BigDecimal clientFOPTotalAddAmount = null;
            EnumSet<PaymentType> addPaymentTypes = EnumSet.allOf(PaymentType.class);
            addPaymentTypes.remove(PaymentType.TICKET);
            addPaymentTypes.remove(PaymentType.VOUCHER);
            addPaymentTypes.remove(PaymentType.MTD);
            addPaymentTypes.remove(PaymentType.MTD_AGENCY);
            addPaymentTypes.remove(PaymentType.CREDIT);
            addPaymentTypes.remove(PaymentType.CREDIT_CARD);
            for (GeneralProductFop fop : clientFops) {
                if (fop.getEquivalentAmount() != null) {
                    BigDecimal bigDecimal = clientFOPAmount = clientFOPAmount != null ? clientFOPAmount.add(fop.getEquivalentAmount()) : fop.getEquivalentAmount();
                }
                if (!exchange && fop.getEquivalentAmount() != null && addPaymentTypes.contains(fop.getType()) && GeneralProductHelper.productFopTypes.contains(GeneralProductHelper.getFopType((GeneralProductFop)fop))) {
                    BigDecimal bigDecimal = clientFOPAddAmount = clientFOPAddAmount != null ? clientFOPAddAmount.add(fop.getEquivalentAmount()) : fop.getEquivalentAmount();
                }
                if (!exchange && fop.getEquivalentAmount() != null && addPaymentTypes.contains(fop.getType()) && !GeneralProductHelper.discountFopTypes.contains(GeneralProductHelper.getFopType((GeneralProductFop)fop))) {
                    BigDecimal bigDecimal = clientFOPTotalAddAmount = clientFOPTotalAddAmount != null ? clientFOPTotalAddAmount.add(fop.getEquivalentAmount()) : fop.getEquivalentAmount();
                }
                if (fop.getType() != null) {
                    if (GeneralProductHelper.isServiceFop((GeneralProductFop)fop)) {
                        clientFopTypes.add(fop.getType());
                    } else {
                        clientFeesFopTypes.add(fop.getType());
                    }
                }
                if (fop.getOperationDate() == null) {
                    hasClientDebt = true;
                    continue;
                }
                if (date != null && !date.before(fop.getOperationDate())) continue;
                date = fop.getOperationDate();
                agent = fop.getAgent();
            }
            if (refund && clientFOPAmount != null) {
                clientFOPAmount = clientFOPAmount.negate();
            }
            if (refund && clientFOPAddAmount != null) {
                clientFOPAddAmount = clientFOPAddAmount.negate();
            }
            if (refund && clientFOPTotalAddAmount != null) {
                clientFOPTotalAddAmount = clientFOPTotalAddAmount.negate();
            }
            data.setClientFopAmount(clientFOPAmount);
            data.setClientFopAddAmount(clientFOPAddAmount);
            data.setClientFopTotalAddAmount(clientFOPTotalAddAmount);
            data.setClientFopTypes(clientFopTypes);
            data.setClientFeesFopTypes(clientFeesFopTypes);
            data.setDateOfClientPayment(date);
            data.setClientFopAgent(agent);
            data.setHasClientDebt(Boolean.valueOf(hasClientDebt));
        }
    }

    protected void updateVendorFopsData(CommonProductIndexData data, List<GeneralProductFop> vendorFops, boolean refund, ProductStatus status) {
        data.setSupplierCardVendor(GeneralProductHelper.getCreditCardVendor(vendorFops));
        if (status != ProductStatus.VOID) {
            Date date = null;
            HashSet<PaymentType> vendorFopTypes = new HashSet<PaymentType>();
            BigDecimal vendorFOPAmount = null;
            for (GeneralProductFop fop : vendorFops) {
                if (fop.getEquivalentAmount() != null) {
                    BigDecimal bigDecimal = vendorFOPAmount = vendorFOPAmount != null ? vendorFOPAmount.add(fop.getEquivalentAmount()) : fop.getEquivalentAmount();
                }
                if (fop.getType() != null) {
                    vendorFopTypes.add(fop.getType());
                }
                if (fop.getOperationDate() == null || date != null && !date.before(fop.getOperationDate())) continue;
                date = fop.getOperationDate();
            }
            if (refund && vendorFOPAmount != null) {
                vendorFOPAmount = vendorFOPAmount.negate();
            }
            data.setVendorFopAmount(vendorFOPAmount);
            data.setDateOfVendorPayment(date);
            data.setVendorFopTypes(vendorFopTypes);
        }
    }

    protected void updateStatisticalData(CommonProductIndexData data, StatisticalData statisticalData, EntityReference<Organization> clientRef) {
        List costCodes = StatisticsHelper.findCostCenterCostCodes((StatisticalData)statisticalData, clientRef);
        if (!costCodes.isEmpty()) {
            data.setCostCenter(IndexBuilderHelper.getCostCodesJoinValue(costCodes, CostCode::getValue));
            data.setCostCenterLocalValue(IndexBuilderHelper.getCostCodesJoinValue(costCodes, CostCode::getLocalValue));
            data.setCostCenterEnglishValue(IndexBuilderHelper.getCostCodesJoinValue(costCodes, CostCode::getEnglishValue));
            data.setCostCenterList(IndexBuilderHelper.getCostCodeValues(costCodes, CostCode::getValue));
            data.setCostCenterLocalValueList(IndexBuilderHelper.getCostCodeValues(costCodes, CostCode::getLocalValue));
            data.setCostCenterEnglishValueList(IndexBuilderHelper.getCostCodeValues(costCodes, CostCode::getEnglishValue));
        }
    }

    public static void setVoidFees(CommonProductIndexData data, BaseProduct product) {
        BigDecimal vendorFeeValue = IndexBuilderHelper.getVoidFeeValue(product, ContractType.VENDOR);
        BigDecimal subagencyFeeValue = IndexBuilderHelper.getVoidFeeValue(product, ContractType.SUBAGENCY);
        BigDecimal subagencyHiddenFeeValue = IndexBuilderHelper.getVoidFeeValue(product, ContractType.SUBAGENCY, true);
        BigDecimal clientFeeValue = IndexBuilderHelper.getVoidFeeValue(product, ContractType.CLIENT);
        Double vendorFeeRate = IndexBuilderHelper.getVoidFeeRate(product, ContractType.VENDOR);
        Double subagencyFeeRate = IndexBuilderHelper.getVoidFeeRate(product, ContractType.SUBAGENCY);
        Double clientFeeRate = IndexBuilderHelper.getVoidFeeRate(product, ContractType.CLIENT);
        data.setVendorFeeValue(vendorFeeValue);
        data.setSubagencyFeeValue(subagencyFeeValue);
        data.setSubagencyHiddenFeeValue(subagencyHiddenFeeValue);
        data.setClientFeeValue(clientFeeValue);
        data.setClientServiceFeeValue(clientFeeValue);
        data.setVendorFeeRate(vendorFeeRate);
        data.setSubagencyFeeRate(subagencyFeeRate);
        data.setClientFeeRate(clientFeeRate);
        data.setVendorFopAmount(vendorFeeValue);
        data.setSubagentFopAmount(MiscUtil.sum((BigDecimal[])new BigDecimal[]{subagencyFeeValue, subagencyHiddenFeeValue}));
        data.setClientFopAmount(clientFeeValue);
    }
}

