/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.model.index;

import com.gridnine.xtrip.common.model.EntityContainer;
import com.gridnine.xtrip.common.model.NestedEntityReference;
import com.gridnine.xtrip.common.model.entity.EntityStorageContext;
import com.gridnine.xtrip.common.model.entity.EntityStorageHelper;
import com.gridnine.xtrip.common.model.finance.BasePaymentDocument;
import com.gridnine.xtrip.common.model.finance.BasicPaymentDocumentIndex;
import com.gridnine.xtrip.common.model.finance.BasicPaymentDocumentIndexData;
import com.gridnine.xtrip.common.model.finance.PaymentItem;
import com.gridnine.xtrip.common.model.system.Money;
import com.gridnine.xtrip.common.util.CompositeNumber;
import com.gridnine.xtrip.common.util.TextUtil;
import com.gridnine.xtrip.server.db.storage.model.BaseIndexData;
import com.gridnine.xtrip.server.db.storage.model.DataAggregator;
import com.gridnine.xtrip.server.db.storage.model.IndexHandler;
import java.math.BigDecimal;
import java.util.Collection;
import java.util.Objects;

abstract class BasePaymentDocumentIndexHandler<E extends BasePaymentDocument>
implements IndexHandler<BasePaymentDocument, BasicPaymentDocumentIndex> {
    BasePaymentDocumentIndexHandler() {
    }

    public Class<? extends BaseIndexData<BasePaymentDocument, BasicPaymentDocumentIndex>> getDataClass() {
        return BasicPaymentDocumentIndexData.class;
    }

    public Class<BasicPaymentDocumentIndex> getIndexClass() {
        return BasicPaymentDocumentIndex.class;
    }

    public void create(EntityContainer<BasePaymentDocument> etc, Collection<BaseIndexData<BasePaymentDocument, BasicPaymentDocumentIndex>> indexes) {
        BasePaymentDocument payment = (BasePaymentDocument)etc.getEntity();
        BasicPaymentDocumentIndexData data = new BasicPaymentDocumentIndexData();
        DataAggregator aggregator = new DataAggregator();
        data.setName(payment.getName());
        data.setDate(payment.getDate());
        data.setNavigationKey(payment.getUid());
        data.setNumber(TextUtil.buildFullNumber((CompositeNumber)payment));
        data.setOrganization(payment.getOrganization());
        data.setPayer(payment.getPayer());
        BasePaymentDocumentIndexHandler.updateMoneyAmounts(payment, data);
        aggregator.aggregate((Object)payment.getName());
        aggregator.aggregate((Object)TextUtil.buildFullNumber((CompositeNumber)payment));
        aggregator.aggregate((Object)payment.getOrganization());
        aggregator.aggregate((Object)payment.getPayer());
        this.updateData(payment, data, aggregator);
        data.setAggregatedData(aggregator.toString());
        indexes.add((BaseIndexData<BasePaymentDocument, BasicPaymentDocumentIndex>)data);
    }

    protected void updateData(E payment, BasicPaymentDocumentIndexData data, DataAggregator aggregator) {
    }

    private static void updateMoneyAmounts(BasePaymentDocument document, BasicPaymentDocumentIndexData index) {
        EntityStorageContext ctx = EntityStorageHelper.createContext();
        if (document.getTotalAmount() != null) {
            index.setTotalAmount(document.getTotalAmount().getValue());
        }
        BigDecimal paymentSum = null;
        if (document.getPaymentItems() != null) {
            paymentSum = document.getPaymentItems().stream().map(item -> (PaymentItem)EntityStorageHelper.resolve((NestedEntityReference)item, (EntityStorageContext)ctx)).filter(Objects::nonNull).map(PaymentItem::getAmount).filter(Objects::nonNull).map(Money::getValue).filter(Objects::nonNull).reduce(BigDecimal::add).orElse(BigDecimal.ZERO);
            index.setPaymentsTotalAmount(paymentSum);
        }
        if (document.getTotalAmount() != null && document.getPaymentItems() != null) {
            index.setDifferenceAmount(document.getTotalAmount().getValue().subtract(paymentSum));
        }
    }
}

