/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.model.index;

import com.gridnine.xtrip.common.model.BaseEntity;
import com.gridnine.xtrip.server.BaseScheduledTask;
import com.gridnine.xtrip.server.model.helpers.IndexBuilderHelper;

public abstract class BaseReindexScheduledTask
extends BaseScheduledTask {
    protected abstract <E extends BaseEntity> Class<E> getEntityType();

    protected void doJob() throws Exception {
        Class entityType = this.getEntityType();
        this.log.debug(String.format("BEGIN reindexing entities of type %s", entityType.getName()));
        try {
            IndexBuilderHelper.rebuild(entityType);
        }
        catch (Throwable e) {
            try {
                this.log.error(String.format("unable to rebuild indexes for %s", entityType.getName()), e);
            }
            catch (Throwable throwable) {
                this.log.debug(String.format("END reindexing entities of type %s", entityType.getName()));
                throw throwable;
            }
            this.log.debug(String.format("END reindexing entities of type %s", entityType.getName()));
        }
        this.log.debug(String.format("END reindexing entities of type %s", entityType.getName()));
    }
}

