/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.model.index;

import com.gridnine.xtrip.common.model.EntityContainer;
import com.gridnine.xtrip.common.model.system.BillingTransactionChange;
import com.gridnine.xtrip.common.model.system.BillingTransactionChangeIndex;
import com.gridnine.xtrip.common.model.system.BillingTransactionChangeIndexData;
import com.gridnine.xtrip.common.model.system.CardTransactionDetails;
import com.gridnine.xtrip.server.db.storage.model.BaseIndexData;
import com.gridnine.xtrip.server.db.storage.model.DataAggregator;
import com.gridnine.xtrip.server.db.storage.model.IndexHandler;
import java.util.Collection;

public class BillingTransactionChangeIndexHandler
implements IndexHandler<BillingTransactionChange, BillingTransactionChangeIndex> {
    public Class<? extends BaseIndexData<BillingTransactionChange, BillingTransactionChangeIndex>> getDataClass() {
        return BillingTransactionChangeIndexData.class;
    }

    public Class<BillingTransactionChangeIndex> getIndexClass() {
        return BillingTransactionChangeIndex.class;
    }

    public Class<BillingTransactionChange> getEntityType() {
        return BillingTransactionChange.class;
    }

    public void create(EntityContainer<BillingTransactionChange> etc, Collection<BaseIndexData<BillingTransactionChange, BillingTransactionChangeIndex>> indexes) {
        BillingTransactionChangeIndexData data = new BillingTransactionChangeIndexData();
        BillingTransactionChange entity = (BillingTransactionChange)etc.getEntity();
        data.setContractType(entity.getContractType());
        data.setTransactionCurrency(entity.getSum() != null ? entity.getSum().getCurrency() : null);
        data.setTransactionDate(entity.getDate());
        data.setDescription(entity.getDescription());
        data.setReferencedEntity(entity.getEntity());
        data.setNavigationKey(entity.getUid());
        data.setPaymentType(entity.getPaymentType());
        data.setTransactionSum(entity.getSum() != null ? entity.getSum().getValue() : null);
        data.setTransactionCode(entity.getDetails() != null ? entity.getDetails().getTransactionCode() : null);
        data.setCategory(entity.getCategory());
        data.setType(entity.getType());
        data.setParent(entity.getParent());
        data.setClient(entity.getClient());
        data.setAgency(entity.getAgency());
        data.setAgent(entity.getAgent());
        data.setProductType(entity.getProductType());
        data.setChangeDate(entity.getChangeDate());
        data.setChangeType(entity.getChangeType());
        if (entity.getDetails() != null && entity.getDetails() instanceof CardTransactionDetails) {
            CardTransactionDetails details = (CardTransactionDetails)entity.getDetails();
            data.setCardNumber(details.getNumber());
            data.setAuthCode(details.getSecurityCode());
        }
        DataAggregator aggregator = new DataAggregator();
        aggregator.aggregate(entity.getSum() != null ? entity.getSum().getCurrency() : null);
        aggregator.aggregate((Object)entity.getDescription());
        aggregator.aggregate((Enum)entity.getPaymentType());
        aggregator.aggregate(entity.getDetails() != null ? entity.getDetails().getTransactionCode() : null);
        aggregator.aggregate((Enum)entity.getCategory());
        aggregator.aggregate((Enum)entity.getType());
        aggregator.aggregate((Object)entity.getParent());
        aggregator.aggregate((Object)entity.getClient());
        aggregator.aggregate((Object)entity.getAgency());
        aggregator.aggregate((Object)entity.getAgent());
        aggregator.aggregate((Object)entity.getEntity());
        data.setAggregatedData(aggregator.toString());
        indexes.add((BaseIndexData<BillingTransactionChange, BillingTransactionChangeIndex>)data);
    }
}

