/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.model.index;

import com.gridnine.xtrip.common.model.EntityContainer;
import com.gridnine.xtrip.common.model.system.BillingTransaction;
import com.gridnine.xtrip.common.model.system.BillingTransactionIndex;
import com.gridnine.xtrip.common.model.system.BillingTransactionIndexData;
import com.gridnine.xtrip.common.model.system.CardTransactionDetails;
import com.gridnine.xtrip.server.db.storage.model.BaseIndexData;
import com.gridnine.xtrip.server.db.storage.model.DataAggregator;
import com.gridnine.xtrip.server.db.storage.model.IndexHandler;
import java.util.Collection;

public class BillingTransactionIndexHandler
implements IndexHandler<BillingTransaction, BillingTransactionIndex> {
    public Class<? extends BaseIndexData<BillingTransaction, BillingTransactionIndex>> getDataClass() {
        return BillingTransactionIndexData.class;
    }

    public Class<BillingTransactionIndex> getIndexClass() {
        return BillingTransactionIndex.class;
    }

    public Class<BillingTransaction> getEntityType() {
        return BillingTransaction.class;
    }

    public void create(EntityContainer<BillingTransaction> etc, Collection<BaseIndexData<BillingTransaction, BillingTransactionIndex>> indexes) {
        BillingTransactionIndexData data = new BillingTransactionIndexData();
        this.fillData(data, (BillingTransaction)etc.getEntity());
        indexes.add((BaseIndexData<BillingTransaction, BillingTransactionIndex>)data);
    }

    protected void fillData(BillingTransactionIndexData data, BillingTransaction bi) {
        data.setFopUid(bi.getFopUid());
        data.setContractType(bi.getContractType());
        data.setTransactionCurrency(bi.getSum() != null ? bi.getSum().getCurrency() : null);
        data.setTransactionDate(bi.getDate());
        data.setDescription(bi.getDescription());
        data.setReferencedEntity(bi.getEntity());
        data.setNavigationKey(bi.getUid());
        data.setPaymentType(bi.getPaymentType());
        data.setTransactionSum(bi.getSum() != null ? bi.getSum().getValue() : null);
        data.setTransactionCode(bi.getDetails() != null ? bi.getDetails().getTransactionCode() : null);
        data.setCategory(bi.getCategory());
        data.setType(bi.getType());
        data.setStatus(bi.getStatus());
        data.setParent(bi.getParent());
        data.setClient(bi.getClient());
        data.setAgency(bi.getAgency());
        data.setAgent(bi.getAgent());
        data.setFinDocNumber(bi.getFinDocNumber());
        data.setFinDocDate(bi.getFinDocDate());
        data.setProductType(bi.getProductType());
        if (bi.getDetails() != null && bi.getDetails() instanceof CardTransactionDetails) {
            CardTransactionDetails details = (CardTransactionDetails)bi.getDetails();
            data.setCardNumber(details.getNumber());
            data.setAuthCode(details.getSecurityCode());
        }
        data.setAutoCreated(Boolean.valueOf(bi.isAutoCreated()));
        DataAggregator aggregator = new DataAggregator();
        aggregator.aggregate(bi.getSum() != null ? bi.getSum().getCurrency() : null);
        aggregator.aggregate((Object)bi.getDescription());
        aggregator.aggregate((Enum)bi.getPaymentType());
        aggregator.aggregate(bi.getDetails() != null ? bi.getDetails().getTransactionCode() : null);
        aggregator.aggregate((Enum)bi.getCategory());
        aggregator.aggregate((Enum)bi.getType());
        aggregator.aggregate((Enum)bi.getStatus());
        aggregator.aggregate((Object)bi.getParent());
        aggregator.aggregate((Object)bi.getClient());
        aggregator.aggregate((Object)bi.getAgency());
        aggregator.aggregate((Object)bi.getAgent());
        aggregator.aggregate((Object)bi.getEntity());
        data.setAggregatedData(aggregator.toString());
    }
}

