/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.model.index;

import com.gridnine.xtrip.common.model.EntityContainer;
import com.gridnine.xtrip.common.model.profile.BaseContractAppendix;
import com.gridnine.xtrip.common.model.profile.BlockCharterAppendixIndex;
import com.gridnine.xtrip.common.model.profile.BlockCharterAppendixIndexData;
import com.gridnine.xtrip.common.model.profile.Contract;
import com.gridnine.xtrip.common.model.profile.ContractCustomerInfo;
import com.gridnine.xtrip.common.model.profile.SUBlockCharterAppendix;
import com.gridnine.xtrip.server.db.storage.model.BaseIndexData;
import com.gridnine.xtrip.server.db.storage.model.DataAggregator;
import com.gridnine.xtrip.server.db.storage.model.IndexHandler;
import java.util.Collection;

public class BlockCharterAppendixIndexHandler
implements IndexHandler<Contract, BlockCharterAppendixIndex> {
    public Class<? extends BaseIndexData<Contract, BlockCharterAppendixIndex>> getDataClass() {
        return BlockCharterAppendixIndexData.class;
    }

    public Class<BlockCharterAppendixIndex> getIndexClass() {
        return BlockCharterAppendixIndex.class;
    }

    public Class<Contract> getEntityType() {
        return Contract.class;
    }

    public void create(EntityContainer<Contract> etc, Collection<BaseIndexData<Contract, BlockCharterAppendixIndex>> indexes) {
        Contract entity = (Contract)etc.getEntity();
        DataAggregator aggregator = new DataAggregator();
        for (ContractCustomerInfo info : entity.getCustomers()) {
            for (BaseContractAppendix app : info.getAppendices()) {
                if (!(app instanceof SUBlockCharterAppendix)) continue;
                SUBlockCharterAppendix bcapp = (SUBlockCharterAppendix)app;
                aggregator.reset();
                BlockCharterAppendixIndexData data = new BlockCharterAppendixIndexData();
                data.setCustomer(info.getCustomer());
                data.setSupplier(entity.getSupplier());
                data.setBlankOwner(entity.getVendor());
                data.setContractEndDate(info.getEndDate());
                data.setContractIssueDate(info.getIssueDate());
                data.setContractNumber(info.getNumber());
                data.setContractStartDate(info.getStartDate());
                data.setVendorContractType(info.getVendorContractType());
                data.setAppendixEndDate(bcapp.getEndDate());
                data.setAppendixFareBasises(bcapp.getFareBasis());
                data.setAppendixIssueDate(bcapp.getIssueDate());
                data.setAppendixItinerary(bcapp.getItinerary());
                data.setAppendixNumber(bcapp.getNumber());
                data.setAppendixStartDate(bcapp.getStartDate());
                data.setAppendixType(bcapp.getType());
                data.setNavigationKey(bcapp.getUid());
                aggregator.aggregate((Enum)entity.getContractType());
                aggregator.aggregate((Object)entity.getName());
                aggregator.aggregate((Object)entity.getNotes());
                aggregator.aggregate(info.getEndDate());
                aggregator.aggregate(info.getIssueDate());
                aggregator.aggregate((Object)info.getNumber());
                aggregator.aggregate((Object)info.getCustomer());
                aggregator.aggregate(info.getStartDate());
                aggregator.aggregate((Enum)info.getVendorContractType());
                aggregator.aggregate(bcapp.getEndDate());
                aggregator.aggregate((Object)bcapp.getFareBasis());
                aggregator.aggregate(bcapp.getIssueDate());
                aggregator.aggregate((Object)bcapp.getItinerary());
                aggregator.aggregate((Object)bcapp.getNumber());
                aggregator.aggregate(bcapp.getStartDate());
                aggregator.aggregate((Enum)bcapp.getType());
                data.setAggregatedData(aggregator.toString());
                aggregator.reset();
                indexes.add((BaseIndexData<Contract, BlockCharterAppendixIndex>)data);
            }
        }
    }
}

