/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.model.index;

import com.gridnine.xtrip.common.l10n.model.LocaleHelper;
import com.gridnine.xtrip.common.model.EntityContainer;
import com.gridnine.xtrip.common.model.dict.AddressType;
import com.gridnine.xtrip.common.model.helpers.CommunicationFormat;
import com.gridnine.xtrip.common.model.helpers.ProfileHelper;
import com.gridnine.xtrip.common.model.profile.Address;
import com.gridnine.xtrip.common.model.profile.Branch;
import com.gridnine.xtrip.common.model.profile.BranchIndex;
import com.gridnine.xtrip.common.model.profile.BranchIndexData;
import com.gridnine.xtrip.common.model.profile.Communication;
import com.gridnine.xtrip.common.util.TextUtil;
import com.gridnine.xtrip.server.db.storage.model.BaseIndexData;
import com.gridnine.xtrip.server.db.storage.model.DataAggregator;
import com.gridnine.xtrip.server.db.storage.model.IndexHandler;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Locale;

public class BranchIndexHandler
implements IndexHandler<Branch, BranchIndex> {
    public Class<? extends BaseIndexData<Branch, BranchIndex>> getDataClass() {
        return BranchIndexData.class;
    }

    public Class<BranchIndex> getIndexClass() {
        return BranchIndex.class;
    }

    public Class<Branch> getEntityType() {
        return Branch.class;
    }

    public void create(EntityContainer<Branch> etc, Collection<BaseIndexData<Branch, BranchIndex>> indexes) {
        BranchIndexData data = new BranchIndexData();
        DataAggregator aggregator = new DataAggregator();
        this.updateData(data, aggregator, etc);
        data.setAggregatedData(aggregator.toString());
        indexes.add((BaseIndexData<Branch, BranchIndex>)data);
    }

    protected void updateData(BranchIndexData data, DataAggregator aggregator, EntityContainer<Branch> etc) {
        Branch entity = (Branch)etc.getEntity();
        data.setDisabled(Boolean.valueOf(entity.isDisabled()));
        data.setCode(entity.getCode());
        data.setShortName(entity.getShortName());
        data.setFullName(entity.getFullName());
        data.setAgency(entity.getAgency());
        data.setPreferredLocale(entity.getPreferredLocale());
        data.setKpp(entity.getKpp());
        ArrayList<String> communications = new ArrayList<String>();
        for (Communication communication : entity.getCommunications()) {
            if (TextUtil.isBlank((String)communication.getSense())) continue;
            CommunicationFormat phoneFormat = new CommunicationFormat("+C (T) N #I");
            CommunicationFormat emailFormat = new CommunicationFormat("N");
            CommunicationFormat webFormat = new CommunicationFormat("N");
            String communicationString = null;
            switch (communication.getType()) {
                case WORK_PHONE: 
                case HOME_PHONE: 
                case FAX: 
                case MOBILE: 
                case AGENCY: 
                case HOTEL: 
                case CELL: 
                case EMERGENCY: {
                    communicationString = phoneFormat.format(communication);
                    break;
                }
                case EMAIL: {
                    communicationString = emailFormat.format(communication);
                    break;
                }
                case WEB: {
                    communicationString = webFormat.format(communication);
                }
            }
            if (communicationString == null) continue;
            communications.add(communication.getType() != null ? communication.getType() + ": " + communicationString : communicationString);
        }
        data.setCommunications(communications);
        data.setAddressLegal(ProfileHelper.buildFullAddress((Address)ProfileHelper.filterAddresses((Collection)entity.getAddresses(), (AddressType)AddressType.LEGAL), (Locale)LocaleHelper.getCurrentLocale(), (boolean)false));
        data.setAddressFactual(ProfileHelper.buildFullAddress((Address)ProfileHelper.filterAddresses((Collection)entity.getAddresses(), (AddressType)AddressType.FACTUAL), (Locale)LocaleHelper.getCurrentLocale(), (boolean)false));
        data.setAddressContact(ProfileHelper.buildFullAddress((Address)ProfileHelper.filterAddresses((Collection)entity.getAddresses(), (AddressType)AddressType.CONTACT), (Locale)LocaleHelper.getCurrentLocale(), (boolean)false));
        data.setAddressDelivery(ProfileHelper.buildFullAddress((Address)ProfileHelper.filterAddresses((Collection)entity.getAddresses(), (AddressType)AddressType.DELIVERY), (Locale)LocaleHelper.getCurrentLocale(), (boolean)false));
        aggregator.aggregate((Object)entity.getCode());
        aggregator.aggregate(entity.getShortName());
        aggregator.aggregate(entity.getFullName());
        aggregator.aggregate((Object)entity.getPreferredLocale());
        aggregator.aggregate((Object)entity.getAgency());
        aggregator.aggregate((Object)entity.getKpp());
    }
}

