/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.model.index;

import com.gridnine.xtrip.common.model.EntityContainer;
import com.gridnine.xtrip.common.model.trip.BusinessTrip;
import com.gridnine.xtrip.common.model.trip.BusinessTripBookingFile;
import com.gridnine.xtrip.common.model.trip.BusinessTripIndex;
import com.gridnine.xtrip.common.model.trip.BusinessTripIndexData;
import com.gridnine.xtrip.server.db.storage.model.BaseIndexData;
import com.gridnine.xtrip.server.db.storage.model.DataAggregator;
import com.gridnine.xtrip.server.db.storage.model.IndexHandler;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;

public class BusinessTripIndexHandler
implements IndexHandler<BusinessTrip, BusinessTripIndex> {
    public Class<? extends BaseIndexData<BusinessTrip, BusinessTripIndex>> getDataClass() {
        return BusinessTripIndexData.class;
    }

    public Class<BusinessTripIndex> getIndexClass() {
        return BusinessTripIndex.class;
    }

    public Class<BusinessTrip> getEntityType() {
        return BusinessTrip.class;
    }

    public void create(EntityContainer<BusinessTrip> etc, Collection<BaseIndexData<BusinessTrip, BusinessTripIndex>> indexes) {
        BusinessTripIndexData data = new BusinessTripIndexData();
        DataAggregator aggregator = new DataAggregator();
        this.updateData(data, aggregator, etc);
        data.setAggregatedData(aggregator.toString());
        indexes.add((BaseIndexData<BusinessTrip, BusinessTripIndex>)data);
    }

    protected void updateData(BusinessTripIndexData data, DataAggregator aggregator, EntityContainer<BusinessTrip> etc) {
        BusinessTrip trip = (BusinessTrip)etc.getEntity();
        data.setContainerUid(etc.getUid());
        data.setNumber(trip.getNumber());
        data.setCreated(trip.getCreated());
        data.setClient(trip.getClient());
        data.setStatus(trip.getStatus());
        List bookingFiles = trip.getBookingFiles().stream().filter(Objects::nonNull).map(BusinessTripBookingFile::getBookingFile).filter(Objects::nonNull).distinct().collect(Collectors.toList());
        data.setBookingFiles(bookingFiles);
        aggregator.aggregate((Object)trip.getNumber());
        aggregator.aggregate((Object)trip.getClient());
        aggregator.aggregate((Enum)trip.getStatus());
        aggregator.aggregate(bookingFiles);
    }
}

